/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVolumeReviewStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JTextArea descLabel = null;
    private JLabel quantityLabel = null;
    private JLabel sizeLabel = null;
    private JLabel arrayLabel = null;
    private JLabel raidLevelLabel = null;
    private JLabel zoneActionLabel = null;
    private JLabel hostPortLabel = null;
    private JLabel subSystemPortLabel = null;
    private JLabel nameLabel = null;
    private JLabel nameTextLabel = null;
    private JLabel volumeListLabel = null;
    private JLabel quantityTextLabel = null;
    private JLabel sizeTextLabel = null;
    private JLabel arrayTextLabel = null;
    private JLabel raidLevelTextLabel = null;
    private JList zoneActionList = null;
    private JList hostPortList = null;
    private JList subSystemPortList = null;
    private JList volumeList = null;
    private DefaultListModel zoneActionListModel = null;
    private DefaultListModel hostPortListModel = null;
    private DefaultListModel subSystemPortListModel = null;
    private DefaultListModel volumeListModel = null;
    private CreateVolumeWizard cvWizard = null;
    private HashMap volumeData = null;
    private int width = 0;
    private int height = 0;
    private boolean isHelpSet = false;
    private HashMap volumesmap = new HashMap();
    private String subsystemID;

    public CreateVolumeReviewStep(int buttonFlags, String SS_ID) {
        super(buttonFlags);
        this.setName("CreateVolumeReviewStep");
        this.subsystemID = SS_ID;
        Container pane = this.getContentPane();
        pane.add(this.create());
        this.getExistingVolumes();
        this.setUpHelp(DiskConstants.DISK_CREATE_VOLUME_REVIEW);
    }

    public Object next() {
        return null;
    }

    public Container create() {
        GridBagPanel tempPanel = new GridBagPanel();
        tempPanel.setDefaultInsets(new Insets(0, 12, 0, 8));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_REVIEW_SETTINGS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 3, 5));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        tempPanel.add((JComponent)titlePanel, 23);
        tempPanel.newRow();
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JTextArea(Util.getString("DISK_VOLUME_REVIEW_SETTINGS_DESC_LABEL"));
        this.descLabel.setEditable(false);
        this.descLabel.setLineWrap(true);
        this.descLabel.setWrapStyleWord(true);
        this.descLabel.setBackground((Color)UIManager.get("Label.background"));
        this.descLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.descLabel.setFont((Font)UIManager.get("Label.font"));
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 5));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        tempPanel.add((JComponent)descPanel, 0, 1, 2);
        tempPanel.newRow();
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 18;
        con.insets = new Insets(0, 5, 0, 0);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.weightx = 0.5;
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridBagLayout());
        this.quantityLabel = new JLabel(Util.getString("DISK_VOLUME_QUANTITY_LABEL"));
        this.quantityTextLabel = new JLabel();
        this.width = 16 * this.quantityTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.quantityTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.quantityTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.quantityTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.quantityTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        con.gridx = 0;
        textPanel.add((Component)this.quantityLabel, con);
        this.quantityLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.quantityTextLabel, con);
        this.quantityTextLabel.setAlignmentX(0.0f);
        this.sizeLabel = new JLabel(Util.getString("DISK_VOLUME_SIZE_LABEL"));
        this.sizeTextLabel = new JLabel();
        this.width = 16 * this.sizeTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.sizeTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.sizeTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.sizeTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.sizeTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        con.gridx = 0;
        con.gridy = 1;
        textPanel.add((Component)this.sizeLabel, con);
        this.sizeLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.sizeTextLabel, con);
        this.sizeTextLabel.setAlignmentX(0.0f);
        this.arrayLabel = new JLabel(Util.getString("DISK_ARRAY_LABEL"));
        this.arrayTextLabel = new JLabel();
        con.gridx = 0;
        con.gridy = 2;
        textPanel.add((Component)this.arrayLabel, con);
        this.arrayLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.arrayTextLabel, con);
        this.arrayTextLabel.setAlignmentX(0.0f);
        this.width = 16 * this.arrayTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.arrayTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.arrayTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.arrayTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.arrayTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.raidLevelLabel = new JLabel(Util.getString("DISK_RAIDLEVEL_LABEL"));
        this.raidLevelTextLabel = new JLabel();
        con.gridx = 0;
        con.gridy = 3;
        textPanel.add((Component)this.raidLevelLabel, con);
        this.raidLevelLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.raidLevelTextLabel, con);
        this.raidLevelTextLabel.setAlignmentX(0.0f);
        this.width = 16 * this.raidLevelTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.raidLevelTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.raidLevelTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.raidLevelTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.raidLevelTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        con.gridx = 0;
        con.gridy = 4;
        con.insets = new Insets(0, 5, 5, 0);
        this.nameLabel = new JLabel(Util.getString("DISK_VOLUME_NAME_PREFIX_LABEL"));
        this.nameTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.nameLabel, con);
        this.nameLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.nameTextLabel, con);
        this.nameTextLabel.setAlignmentX(0.0f);
        tempPanel.add(textPanel);
        tempPanel.newRow();
        JPanel volumeListPanel = new JPanel();
        JPanel volumeLabelPanel = new JPanel();
        volumeLabelPanel.setLayout(new BoxLayout(volumeLabelPanel, 0));
        this.volumeListLabel = new JLabel(Util.getString("DISK_VOLUME_CREATE_VOLUME_LABEL"));
        volumeLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        volumeLabelPanel.add(this.volumeListLabel);
        volumeLabelPanel.add(Box.createHorizontalGlue());
        volumeListPanel.setLayout(new BoxLayout(volumeListPanel, 0));
        this.volumeList = new JList();
        JScrollPane volumeScrollPanel = new JScrollPane(this.volumeList);
        volumeListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        volumeListPanel.add(volumeScrollPanel);
        tempPanel.add(volumeLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)volumeListPanel, 0, 1, 2);
        tempPanel.newRow();
        this.width = 16 * this.volumeList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.volumeList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        volumeListPanel.setMinimumSize(new Dimension(this.width, this.height));
        volumeListPanel.setPreferredSize(new Dimension(this.width, this.height));
        volumeListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        volumeListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.volumeList.setSelectionMode(0);
        GuiUtil.setAccessibleLabel(this.volumeListLabel, this.volumeList, "", this.volumeListLabel.getText(), this.volumeListLabel.getText());
        JPanel zoneListPanel = new JPanel();
        JPanel zoneLabelPanel = new JPanel();
        zoneLabelPanel.setLayout(new BoxLayout(zoneLabelPanel, 0));
        this.zoneActionLabel = new JLabel(Util.getString("DISK_ZONE_ACTIONS_LABEL"));
        zoneLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneLabelPanel.add(this.zoneActionLabel);
        tempPanel.newRow();
        zoneLabelPanel.add(Box.createHorizontalGlue());
        tempPanel.newRow();
        zoneListPanel.setLayout(new BoxLayout(zoneListPanel, 0));
        this.zoneActionList = new JList();
        JScrollPane zoneScrollPanel = new JScrollPane(this.zoneActionList);
        zoneListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneListPanel.add(zoneScrollPanel);
        this.width = 16 * this.zoneActionList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.zoneActionList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        zoneListPanel.setMinimumSize(new Dimension(this.width, this.height));
        zoneListPanel.setPreferredSize(new Dimension(this.width, this.height));
        zoneListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        zoneListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.zoneActionLabel, this.zoneActionList, "", this.zoneActionLabel.getText(), this.zoneActionLabel.getText());
        tempPanel.add(zoneLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)zoneListPanel, 0, 1, 2);
        tempPanel.newRow();
        JPanel portListPanel = new JPanel();
        JPanel portLabelPanel = new JPanel();
        portLabelPanel.setLayout(new BoxLayout(portLabelPanel, 0));
        this.hostPortLabel = new JLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        portLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portLabelPanel.add(this.hostPortLabel);
        portLabelPanel.add(Box.createHorizontalGlue());
        portListPanel.setLayout(new BoxLayout(portListPanel, 0));
        this.hostPortList = new JList();
        JScrollPane portScrollPanel = new JScrollPane(this.hostPortList);
        portListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portListPanel.add(portScrollPanel);
        this.width = 16 * this.hostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.hostPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        portListPanel.setMinimumSize(new Dimension(this.width, this.height));
        portListPanel.setPreferredSize(new Dimension(this.width, this.height));
        portListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        portListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.hostPortLabel, this.hostPortList, "", this.hostPortLabel.getText(), this.hostPortLabel.getText());
        tempPanel.add(portLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)portListPanel, 0, 1, 2);
        tempPanel.newRow();
        JPanel subSystemPortPanel = new JPanel();
        JPanel subSystemLabelPanel = new JPanel();
        subSystemLabelPanel.setLayout(new BoxLayout(subSystemLabelPanel, 0));
        this.subSystemPortLabel = new JLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        subSystemLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        subSystemLabelPanel.add(this.subSystemPortLabel);
        subSystemLabelPanel.add(Box.createHorizontalGlue());
        subSystemPortPanel.setLayout(new BoxLayout(subSystemPortPanel, 0));
        this.subSystemPortList = new JList();
        JScrollPane subSystemScrollPanel = new JScrollPane(this.subSystemPortList);
        subSystemPortPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        subSystemPortPanel.add(subSystemScrollPanel);
        this.width = 16 * this.subSystemPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.subSystemPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        subSystemPortPanel.setMinimumSize(new Dimension(this.width, this.height));
        subSystemPortPanel.setPreferredSize(new Dimension(this.width, this.height));
        subSystemPortPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        subSystemPortPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.subSystemPortLabel, this.subSystemPortList, "", this.subSystemPortLabel.getText(), this.subSystemPortLabel.getText());
        tempPanel.add(subSystemLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)subSystemPortPanel, 0, 1, 2);
        tempPanel.newRow();
        tempPanel.add((JComponent)new JLabel(), 1);
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.getNextButton().setEnabled(false);
        return tempPanel;
    }

    public void fillData() {
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.volumeData = this.cvWizard.getData();
        this.quantityTextLabel.setText(this.volumeData.get(Util.getString("DISK_VOLUME_QUANTITY_LABEL")).toString());
        this.sizeTextLabel.setText(this.volumeData.get(Util.getString("DISK_VOLUME_SIZE_LABEL")).toString() + " " + this.volumeData.get(Util.getString("DISK_UNITS_LABEL")).toString());
        Object tempObject = this.volumeData.get(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
        if (tempObject != null) {
            GUIStoragePool pool = (GUIStoragePool)tempObject;
            if (pool.getDeviceId().toString().length() == 0) {
                this.arrayTextLabel.setText(" (" + pool.getInstanceId() + ")");
            } else {
                this.arrayTextLabel.setText(pool.getDeviceId());
            }
        }
        this.raidLevelTextLabel.setText(this.volumeData.get(Util.getString("DISK_RAIDLEVEL_LABEL")).toString());
        String vName = this.volumeData.get(Util.getString("DISK_NAME_LABEL")).toString();
        if (vName.length() <= 0) {
            vName = Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL");
        }
        this.nameTextLabel.setText(vName);
        Vector volumeNames = this.generateVolumeList(this.nameTextLabel.getText(), Integer.valueOf(this.quantityTextLabel.getText()));
        if (volumeNames.size() == 0) {
            volumeNames = null;
        }
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUMES_LABEL"), volumeNames);
        this.volumeListModel = this.addVectorToModel(volumeNames);
        this.volumeList.setModel(this.volumeListModel);
        Vector hostports = (Vector)this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_DATA);
        Vector<String> hostportString = new Vector<String>();
        GUIPort port = null;
        String portname = new String();
        String hostname = new String();
        for (int i = 0; hostports != null && i < hostports.size(); ++i) {
            try {
                port = (GUIPort)hostports.get(i);
            }
            catch (ClassCastException ce) {
                port = null;
            }
            if (port != null) {
                portname = port.getWwpn();
                hostname = port.getHostName();
                if (hostname != null && hostname.trim().length() > 0) {
                    portname = portname + " (" + hostname + ")";
                }
                hostportString.add(portname);
                continue;
            }
            hostportString.add((String)hostports.get(i));
        }
        this.hostPortListModel = this.addVectorToModel(hostportString);
        this.hostPortList.setModel(this.hostPortListModel);
        Vector sshostports = (Vector)this.volumeData.get(CreateVolumeSelectSubsystemPortsStep.SUBSYSTEM_DATA);
        Vector<String> sshostportString = new Vector<String>();
        port = null;
        for (int i = 0; sshostports != null && i < sshostports.size(); ++i) {
            port = (GUIPort)sshostports.get(i);
            portname = port.getWwpn();
            hostname = port.getHostName();
            if (hostname != null && hostname.trim().length() > 0) {
                portname = portname + " (" + hostname + ")";
            }
            sshostportString.add(portname);
        }
        this.subSystemPortListModel = this.addVectorToModel(sshostportString);
        this.subSystemPortList.setModel(this.subSystemPortListModel);
        HashMap zoneAction = (HashMap)this.volumeData.get(CreateVolumeZoneActionStep.ZONE_LIST_DATA);
        Vector<Object> zoneVector = new Vector();
        if (zoneAction != null) {
            zoneVector = new Vector(zoneAction.values());
        }
        this.zoneActionListModel = this.addVectorToModel(zoneVector);
        this.zoneActionList.setModel(this.zoneActionListModel);
    }

    public boolean nextBegin() {
        return false;
    }

    public boolean previousBegin() {
        this.volumeData = null;
        return true;
    }

    private void getExistingVolumes() {
        DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
        diskAccessor.getVolumeNamesBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    String[] vNames = (String[])response.responseData;
                    CreateVolumeReviewStep.this.volumesmap = new HashMap();
                    for (int i = 0; vNames != null && i < vNames.length; ++i) {
                        CreateVolumeReviewStep.this.volumesmap.put(vNames[i], vNames[i]);
                    }
                }
            }
        }, this.subsystemID);
    }

    private Vector generateVolumeList(String prefix, int volumeNo) {
        Vector<String> volumeList = new Vector<String>();
        if (prefix.length() == 0) {
            volumeList.add(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
            return volumeList;
        }
        if (prefix.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
            return volumeList;
        }
        if (volumeNo == 1 && this.volumesmap.get(prefix) == null) {
            if (!prefix.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
                volumeList.add(prefix);
            }
            return volumeList;
        }
        int ipostfix = 1;
        String volumeName = new String();
        for (int i = 0; i < volumeNo; ++i) {
            volumeName = prefix + ipostfix;
            while (this.volumesmap.get(volumeName) != null) {
                volumeName = prefix + ++ipostfix;
            }
            volumeList.add(volumeName);
            volumeName = prefix + ++ipostfix;
        }
        return volumeList;
    }

    private DefaultListModel addVectorToModel(Vector vv) {
        DefaultListModel model = new DefaultListModel();
        if (vv == null) {
            return model;
        }
        for (int i = 0; i < vv.size(); ++i) {
            model.add(i, vv.get(i));
        }
        return model;
    }
}

