/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.volume.VDiskDetailsPanel;
import org.eclipse.aperi.gui.disk.volume.VDiskListPanel;
import org.eclipse.aperi.gui.disk.volume.VDiskPanel;
import org.eclipse.aperi.request.Response;

public class VDiskDDI
extends DataDisplayInfo
implements ActionListener {
    private VDiskPanel mainPanel;
    private HashMap hmapVDofSS;
    public GUIStorageSubsystem subsystem;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    private Vector vdisks = new Vector();
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public VDiskDDI(GUIStorageSubsystem ss) {
        this.setDescription(Util.getString("DISK_VDISKS_LABEL"));
        this.displayInScrollPane = true;
        this.subsystem = ss;
    }

    public String getHelpID() {
        Component panel = this.mainPanel.tabs.getSelectedComponent();
        if (panel instanceof VDiskListPanel) {
            return DiskConstants.DISK_LIST_VDISKS;
        }
        if (panel instanceof VDiskDetailsPanel) {
            return DiskConstants.DISK_VDISKS_DETAILS;
        }
        return "welcome_gettingstarted";
    }

    public void getVDisks(String filterName, int filterType) {
        if (filterType == 0) {
            this.diskAccessor.getVDisksBySVC(new GuiRequestor(){

                public void handleResponse(short status, Response response) {
                    if (status <= 4) {
                        VDiskDDI.this.hmapVDofSS = (HashMap)response.responseData;
                        VDiskDDI.this.vdisks.removeAllElements();
                        VDiskDDI.this.vdisks = new Vector(VDiskDDI.this.hmapVDofSS.values());
                    }
                    ((VDiskDDI)VDiskDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId());
        } else if (filterType == 1) {
            this.diskAccessor.getVDisksByMDiskGroup(new GuiRequestor(){

                public void handleResponse(short status, Response response) {
                    if (status <= 4) {
                        VDiskDDI.this.hmapVDofSS = (HashMap)response.responseData;
                        VDiskDDI.this.vdisks.removeAllElements();
                        VDiskDDI.this.vdisks = new Vector(VDiskDDI.this.hmapVDofSS.values());
                    }
                    ((VDiskDDI)VDiskDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId(), filterName);
        } else if (filterType == 2) {
            this.diskAccessor.getVDisksByHost(new GuiRequestor(){

                public void handleResponse(short status, Response response) {
                    if (status <= 4) {
                        VDiskDDI.this.hmapVDofSS = (HashMap)response.responseData;
                        VDiskDDI.this.vdisks.removeAllElements();
                        VDiskDDI.this.vdisks = new Vector(VDiskDDI.this.hmapVDofSS.values());
                    }
                    ((VDiskDDI)VDiskDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId(), filterName);
        } else if (filterType == 3) {
            this.vdisks.removeAllElements();
            this.mainPanel.listPanel.buildtable();
        }
    }

    public void reDisplay() {
        this.buildPanel();
        this.showAndAddListeners();
    }

    public void buildPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new VDiskPanel(this);
        }
        this.panel = this.mainPanel.getComponent();
    }

    private void showAndAddListeners() {
        this.show();
        this.guiMain.setSaveActionEnabled(false, false);
    }

    public void panelToBeNulled() {
        this.mainPanel = null;
    }

    public void losingFocus() {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void actionPerformed(ActionEvent event) {
    }

    void showDetails(int dataRow) {
        GUIVDisk vd = (GUIVDisk)this.vdisks.elementAt(dataRow);
        this.mainPanel.showDetails(vd);
    }

    public GUIVDisk getRowDataAt(int dataRow) {
        GUIVDisk vd = (GUIVDisk)this.vdisks.elementAt(dataRow);
        return vd;
    }

    public int getRowCount() {
        return this.vdisks.size();
    }
}

