/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.TableCapacityRenderer;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentWizard;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;
import org.eclipse.aperi.gui.disk.volume.VDiskTableModel;
import org.eclipse.aperi.request.Response;

public class VDiskListPanel
extends JPanel
implements ActionListener,
MouseListener,
TJCTableMouseInterface {
    private JTextField vdisk_id;
    private JRadioButton radioButMDiskG;
    private JRadioButton radioButHost;
    private JComboBox cbvdisk;
    private JComboBox cbhost;
    private JButton buttoncreate;
    private JButton buttondelete;
    private JButton buttonHPA;
    private JButton buttonGOa;
    private JButton buttonGOh;
    private JLabel label;
    private ButtonGroup group = new ButtonGroup();
    private VDiskDDI theVdDDI;
    private GUIVDisk vd;
    private DiskGuiTable table;
    private VDiskTableModel tableModel;
    private JPanel mainpanel = new JPanel();
    private JPanel filterpanel = new JPanel();
    private boolean dblClick = false;
    private HashMap hmapArrofSS;
    private GUIMDiskGroup[] arrpool;
    private HashMap hmapHostPortofSS;
    private static final String ACTION_VIEW_DETAILS = Util.getString("DISK_VIEW_DETAILS_LABEL");
    private GridBagConstraints con = new GridBagConstraints();
    private int filtermode = 3;
    private String filtername = "NONE";
    private String strHPnameBr = "( ";
    private String endHPnameBr = " )";
    private String noselect = Util.getString("DISK_COMMON_NO_SELECTION");
    private boolean hostplistavailable = false;
    private static DefaultTableCellRenderer capacityRenderer = new TableCapacityRenderer();
    private JDialog wizardDialog = null;
    private CreateVDiskWizard crvd = null;
    private PortAssignmentWizard HPAwiz = null;
    private JPanel tablePanel = GuiUtil.getPanel();
    private int width = 0;
    private int height = 0;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();

    public VDiskListPanel(VDiskDDI ddi) {
        this.theVdDDI = ddi;
        this.table = new DiskGuiTable();
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.mainpanel.setLayout(new BorderLayout());
        this.buttoncreate = new JButton(Util.getString("DISK_CREATE_BUTTON"));
        this.buttoncreate.addActionListener(this);
        GuiUtil.setAccessible(this.buttoncreate, this.buttoncreate.getText(), this.buttoncreate.getText());
        this.buttonHPA = new JButton(Util.getString("DISK_HPA_BUTTON"));
        this.buttonHPA.addActionListener(this);
        GuiUtil.setAccessible(this.buttonHPA, this.buttonHPA.getText(), this.buttonHPA.getText());
        this.buttondelete = new JButton(Util.getString("DISK_DELETE_BUTTON"));
        this.buttondelete.addActionListener(this);
        GuiUtil.setAccessible(this.buttondelete, this.buttondelete.getText(), this.buttondelete.getText());
        this.selectionChanged(true);
        JPanel pbutton_line1 = new JPanel();
        pbutton_line1.setLayout(new FlowLayout(0));
        pbutton_line1.add(this.buttoncreate);
        pbutton_line1.add(this.buttonHPA);
        pbutton_line1.add(this.buttondelete);
        this.filterpanel.setLayout(new GridBagLayout());
        this.con.anchor = 17;
        this.con.insets = new Insets(3, 3, 3, 3);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.radioButMDiskG = new JRadioButton(Util.getString("DISK_FILTER_MDISKG_LABEL"), true);
        this.radioButMDiskG.addMouseListener(this);
        GuiUtil.setAccessible(this.radioButMDiskG, this.radioButMDiskG.getText(), this.radioButMDiskG.getText());
        this.filterpanel.add((Component)this.radioButMDiskG, this.con);
        this.group.add(this.radioButMDiskG);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.cbvdisk = new JComboBox();
        this.cbvdisk.setEnabled(true);
        GuiUtil.setAccessible(this.cbvdisk, this.radioButMDiskG.getText(), this.radioButMDiskG.getText());
        this.width = 40 * this.cbvdisk.getFontMetrics(this.getFont()).charWidth(0) + 15;
        this.height = this.cbvdisk.getFontMetrics(this.getFont()).getHeight() + 5;
        this.cbvdisk.setMinimumSize(new Dimension(this.width, this.height));
        this.cbvdisk.setPreferredSize(new Dimension(this.width, this.height));
        this.cbvdisk.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbvdisk, this.con);
        this.theVdDDI.diskAccessor.getMDiskGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    GUIMDiskGroup pool;
                    int i;
                    VDiskListPanel.this.hmapArrofSS = (HashMap)response.responseData;
                    Collection colmdg = VDiskListPanel.this.hmapArrofSS.values();
                    VDiskListPanel.access$102(VDiskListPanel.this, new GUIMDiskGroup[colmdg.size()]);
                    VDiskListPanel.access$102(VDiskListPanel.this, colmdg.toArray(VDiskListPanel.this.arrpool));
                    VDiskListPanel.this.cbvdisk.addItem(VDiskListPanel.this.noselect);
                    boolean sorted = false;
                    while (!sorted) {
                        sorted = true;
                        for (i = 0; i < VDiskListPanel.this.arrpool.length - 1; ++i) {
                            if (VDiskListPanel.this.arrpool[i].getDeviceId().compareTo(VDiskListPanel.this.arrpool[i + 1].getDeviceId()) <= 0) continue;
                            pool = VDiskListPanel.this.arrpool[i];
                            ((VDiskListPanel)VDiskListPanel.this).arrpool[i] = VDiskListPanel.this.arrpool[i + 1];
                            ((VDiskListPanel)VDiskListPanel.this).arrpool[i + 1] = pool;
                            sorted = false;
                        }
                    }
                    for (i = 0; i < VDiskListPanel.this.arrpool.length; ++i) {
                        pool = VDiskListPanel.this.arrpool[i];
                        String entry = pool.getDeviceId();
                        VDiskListPanel.this.cbvdisk.addItem(entry);
                    }
                }
            }
        }, this.theVdDDI.subsystem.getId());
        this.con.gridx = 2;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.buttonGOa = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOa.addActionListener(this);
        GuiUtil.setAccessible(this.buttonGOa, this.buttonGOa.getText(), this.buttonGOa.getText());
        this.filterpanel.add((Component)this.buttonGOa, this.con);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.radioButHost = new JRadioButton(Util.getString("DISK_FILTER_HOST_LABEL"));
        this.radioButHost.addMouseListener(this);
        GuiUtil.setAccessible(this.radioButHost, this.radioButHost.getText(), this.radioButHost.getText());
        this.filterpanel.add((Component)this.radioButHost, this.con);
        this.group.add(this.radioButHost);
        this.con.gridx = 1;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.cbhost = new JComboBox();
        this.cbhost.setEnabled(false);
        GuiUtil.setAccessible(this.cbhost, this.radioButHost.getText(), this.radioButHost.getText());
        this.cbhost.setMinimumSize(new Dimension(this.width, this.height));
        this.cbhost.setPreferredSize(new Dimension(this.width, this.height));
        this.cbhost.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbhost, this.con);
        this.hostplistavailable = false;
        this.con.gridx = 2;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.buttonGOh = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOh.addActionListener(this);
        this.buttonGOh.setEnabled(false);
        GuiUtil.setAccessible(this.buttonGOh, this.buttonGOh.getText(), this.buttonGOh.getText());
        this.filterpanel.add((Component)this.buttonGOh, this.con);
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("DISK_VDISKVOLUME_LABEL") + " " + "(" + this.theVdDDI.subsystem.getName() + "):"));
        GridBagConstraints tgbc = new GridBagConstraints();
        tgbc.gridheight = 0;
        tgbc.insets.bottom = 0;
        tgbc.insets.top = 10;
        tgbc.gridwidth = 1;
        tgbc.anchor = 10;
        tgbc.fill = 1;
        tgbc.weighty = 1.0;
        tgbc.weightx = 0.5;
        tgbc.insets = new Insets(3, 3, 3, 3);
        this.table.setMouseListener(this);
        this.theVdDDI.getVDisks(this.filtername, this.filtermode);
        this.tablePanel.add((Component)this.table, tgbc);
        this.add((Component)this.mainpanel, "Center");
        JPanel operational_panel = new JPanel();
        operational_panel.setLayout(new BorderLayout());
        operational_panel.add((Component)pbutton_line1, "North");
        operational_panel.add((Component)this.filterpanel, "West");
        this.mainpanel.add((Component)operational_panel, "North");
        this.mainpanel.add((Component)this.tablePanel, "Center");
        return this;
    }

    public void actionPerformed(ActionEvent event) {
        int[] selectedRows;
        Object sourceB = null;
        String sourceKM = null;
        sourceB = event.getSource();
        sourceKM = event.getActionCommand();
        if (event == null) {
            return;
        }
        if (sourceB == null) {
            return;
        }
        if (sourceB == this.buttondelete) {
            this.doDelete();
        } else if (sourceB == this.buttoncreate) {
            this.opencreateWizard(this.theVdDDI.subsystem);
        } else if (sourceB == this.buttonHPA) {
            this.openWizardHPA(this.theVdDDI.subsystem);
        } else if (sourceB == this.buttonGOa) {
            int idx = this.cbvdisk.getSelectedIndex();
            String sel = idx == 0 ? this.noselect : this.arrpool[idx - 1].getName();
            if (sel == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = this.arrpool[idx - 1].getId();
                this.filtermode = 1;
            }
            this.theVdDDI.getVDisks(this.filtername, this.filtermode);
        } else if (sourceB == this.buttonGOh) {
            String sel;
            int idx = this.cbhost.getSelectedIndex();
            if (idx == 0) {
                sel = this.noselect;
            } else {
                sel = (String)this.cbhost.getItemAt(idx);
                int ii = sel.indexOf(this.strHPnameBr);
                if (ii > 0) {
                    sel = sel.substring(0, ii);
                }
            }
            if (sel == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = sel;
                this.filtermode = 2;
            }
            this.theVdDDI.getVDisks(this.filtername, this.filtermode);
        } else if (sourceKM == ACTION_VIEW_DETAILS && (selectedRows = this.table.getSelectedRows()).length > 0) {
            this.theVdDDI.showDetails(selectedRows[0]);
        }
    }

    public void doDelete() {
        int sel = this.table.getNumRows();
        if (sel != 0) {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length > 0) {
                this.vd = this.theVdDDI.getRowDataAt(selectedRows[0]);
                this.theVdDDI.diskAccessor.getPortAssignments(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                        if (status <= 4) {
                            HashMap hmapHostPortVol = (HashMap)response.responseData;
                            if (!hmapHostPortVol.isEmpty()) {
                                String[] args = new String[]{VDiskListPanel.this.vd.getName()};
                                String s = Util.getString("DMSG_DISK_VDISK_EXISTING_ASSIGNMENTS", args);
                                JOptionPane.showMessageDialog(VDiskListPanel.this.guiMain.getFrame(), s, Util.getString("DISK_DELETE_VDISK_LABEL"), 0);
                            } else {
                                int action = JOptionPane.showConfirmDialog(VDiskListPanel.this.guiMain.getFrame(), Util.getString("DISK_REALLY_DELETE_VDISK_LABEL", VDiskListPanel.this.vd.getDeviceId()), Util.getString("DISK_DELETE_VDISK_LABEL"), 1);
                                switch (action) {
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        DiskDataController.getInstance().deleteVolumes(new GuiRequestor(){

                                            public void handleResponse(short status, Response response) {
                                                AsyncResult[] subResults;
                                                AsyncResult result;
                                                int jobID;
                                                Response jobStatusResponse;
                                                if (status <= 4 && (jobStatusResponse = GuiDeviceJob.getJobStatus(jobID = ((Integer)response.responseData).intValue(), true)) != null && (result = (AsyncResult)jobStatusResponse.responseData) != null && (subResults = result.getSubJobResults()) != null && subResults.length == 1) {
                                                    Exception tpcEx = subResults[0].getReturnException();
                                                    if (tpcEx != null) {
                                                        String errorMsg = tpcEx.getMessage();
                                                        if (tpcEx instanceof SRMRuntimeException) {
                                                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                                                        }
                                                        if (errorMsg != null) {
                                                            JOptionPane.showMessageDialog(VDiskListPanel.this.guiMain.getFrame(), errorMsg, Util.getString("DISK_DELETE_VDISK_LABEL"), 0);
                                                        }
                                                    }
                                                    VolumeID[] volumeIds = (VolumeID[])subResults[0].getResults();
                                                    VDiskListPanel.this.theVdDDI.getVDisks(VDiskListPanel.this.filtername, VDiskListPanel.this.filtermode);
                                                }
                                            }
                                        }, new String[]{VDiskListPanel.this.vd.getId()});
                                    }
                                }
                            }
                        }
                    }
                }, this.theVdDDI.subsystem.getId(), this.vd.getId());
            }
        } else {
            String s = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_DELETE_LABEL"), 0);
        }
    }

    public void opencreateWizard(GUIStorageSubsystem ss) {
        this.crvd = new CreateVDiskWizard(ss);
        this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_CREATE_VDISK_WIZARD_LABEL", ss.getDeviceId()), true);
        this.wizardDialog.getContentPane().add(this.crvd);
        this.wizardDialog.setResizable(false);
        this.wizardDialog.pack();
        GuiUtil.centerDialog(this.wizardDialog);
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                VDiskListPanel.this.crvd.cancel();
            }
        });
        this.wizardDialog.show();
    }

    public void openWizardHPA(GUIStorageSubsystem ss) {
        int sel = this.table.getNumRows();
        if (sel != 0) {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length > 0) {
                this.vd = this.theVdDDI.getRowDataAt(selectedRows[0]);
                this.HPAwiz = new PortAssignmentWizard(ss, this.vd);
                this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_HPA_WIZARD_LABEL", ss.getDeviceId()), true);
                this.wizardDialog.getContentPane().add(this.HPAwiz);
                this.wizardDialog.setResizable(false);
                this.wizardDialog.pack();
                GuiUtil.centerDialog(this.wizardDialog);
                this.wizardDialog.setDefaultCloseOperation(0);
                this.wizardDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent event) {
                        VDiskListPanel.this.HPAwiz.cancel();
                    }
                });
                this.wizardDialog.show();
            }
        } else {
            String s = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_DELETE_LABEL"), 0);
        }
    }

    public void mouseClicked(MouseEvent click) {
        if (this.radioButMDiskG.isSelected()) {
            this.cbvdisk.setEnabled(true);
            this.cbhost.setEnabled(false);
            this.buttonGOa.setEnabled(true);
            this.buttonGOh.setEnabled(false);
        } else if (this.radioButHost.isSelected()) {
            if (!this.hostplistavailable) {
                this.theVdDDI.diskAccessor.getAssignedHostPortsBySubsystem(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                        if (status <= 4) {
                            VDiskListPanel.this.hmapHostPortofSS = (HashMap)response.responseData;
                            Collection colhost = VDiskListPanel.this.hmapHostPortofSS.values();
                            VDiskListPanel.this.cbhost.addItem(VDiskListPanel.this.noselect);
                            ArrayList<String> list = new ArrayList<String>();
                            for (GUIPort port : colhost) {
                                String hpwwpn = port.getWwpn();
                                String hpname = port.getHostName();
                                if (hpwwpn == null || hpwwpn.equals("null")) continue;
                                if (hpname != null && hpname.trim().length() > 0) {
                                    hpwwpn = hpwwpn + VDiskListPanel.this.strHPnameBr + hpname + VDiskListPanel.this.endHPnameBr;
                                }
                                list.add(hpwwpn);
                            }
                            Collections.sort(list);
                            for (int i = 0; i < list.size(); ++i) {
                                VDiskListPanel.this.cbhost.addItem(list.get(i));
                            }
                        }
                    }
                }, this.theVdDDI.subsystem.getId());
            }
            this.hostplistavailable = true;
            this.cbhost.setEnabled(true);
            this.buttonGOh.setEnabled(true);
            this.cbvdisk.setEnabled(false);
            this.buttonGOa.setEnabled(false);
        }
    }

    public void mouseEntered(MouseEvent click) {
    }

    public void mouseExited(MouseEvent click) {
    }

    public void mousePressed(MouseEvent click) {
    }

    public void mouseReleased(MouseEvent click) {
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (dataRow < 0 || dataCol < 0) {
            return;
        }
        int selectedRow = this.table.getPointedRow(y);
        this.table.setSelectedRows(selectedRow, selectedRow);
        this.selectionChanged(true);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = menu.add(Util.getString("DISK_VIEW_DETAILS_LABEL"));
        mi.setActionCommand(ACTION_VIEW_DETAILS);
        mi.addActionListener(this);
        mi.setEnabled(true);
        menu.show(c, x, y);
        menu.requestFocus();
    }

    public void selectionChanged(boolean state) {
        if (this.capabilities.isDiskAdmin() && this.theVdDDI.subsystem.isVolumeCreationSupported() && this.theVdDDI.subsystem.getCapabilityData() != null && this.theVdDDI.subsystem.isDetectable()) {
            this.buttoncreate.setEnabled(true);
        } else {
            this.buttoncreate.setEnabled(false);
        }
        if (!this.table.rowsSelected()) {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
            return;
        }
        if (this.theVdDDI.getRowCount() != 0) {
            if (this.capabilities.isDiskAdmin() && this.theVdDDI.subsystem.isVolumeDeletionSupported() && this.theVdDDI.subsystem.getCapabilityData() != null && this.theVdDDI.subsystem.isDetectable()) {
                this.buttondelete.setEnabled(true);
            } else {
                this.buttondelete.setEnabled(false);
            }
            if (this.capabilities.isDiskAdmin() && this.theVdDDI.subsystem.isPortAssignmentSupported() && this.theVdDDI.subsystem.getCapabilityData() != null && this.theVdDDI.subsystem.isDetectable()) {
                this.buttonHPA.setEnabled(true);
            } else {
                this.buttonHPA.setEnabled(false);
            }
        } else {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
        }
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
        this.theVdDDI.showDetails(dataRow);
    }

    public void showDefaultChart(int dataRow) {
    }

    public void buildtable() {
        this.tableModel = new VDiskTableModel(this.theVdDDI);
        this.table.setBaseTableModel(this.tableModel);
        this.table.setCellRenderer(Double.class, capacityRenderer);
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.sortByColumn(0, 1);
        this.table.setSelectionPolicy(0);
        this.table.setSelectedRows(0, 0);
        this.selectionChanged(true);
        this.table.updateUI();
    }

    static /* synthetic */ GUIMDiskGroup[] access$102(VDiskListPanel x0, GUIMDiskGroup[] x1) {
        x0.arrpool = x1;
        return x1;
    }
}

