/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIPortAssignment;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeDetailsPanel
extends JPanel
implements ActionListener {
    private VolumeDDI theDDI;
    private GUIVolume volume;
    private Vector hostvct;
    private Vector subportvct;
    private JList lstSubsystemPorts;
    private JList lstHostPorts;
    private JScrollPane scrollSubP;
    private JScrollPane scrollHostP;
    private JLabel lbVolume;
    private JLabel lbVolumeSize;
    private JLabel lbArray;
    private JLabel lbRaid;
    private JLabel lbSubsystem;
    private JLabel lbSubsystemName;
    private JLabel lbSubsystemPorts = null;
    private JLabel lbHostPorts = null;
    private HashMap hmapHosttoSub = new HashMap();
    protected DefaultListModel subportModel = new DefaultListModel();
    protected DefaultListModel hostportModel = new DefaultListModel();

    public VolumeDetailsPanel(VolumeDDI ddi, GUIVolume vol) {
        this.theDDI = ddi;
        this.volume = vol;
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 20, 5, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_VOLUME_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.lbVolume = new JLabel();
        this.lbVolume.setText(GUIEntityUtil.getDisplayText(this.volume.getDeviceId()));
        propPanel.add((Component)this.lbVolume, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_VOLUMESIZE_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.lbVolumeSize = new JLabel();
        double capacity = GUIEntityUtil.convertStorageCapacity(this.volume.getCapacity(), 0, 3, 10);
        String unit = "";
        long cylinder = 0L;
        switch (this.volume.getFormat()) {
            case 0: {
                unit = Util.getString("DISK_GB_LABEL");
                this.lbVolumeSize.setText(GUIEntityUtil.getNumberString(new Double(capacity), 2, Locale.getDefault()) + " " + unit);
                break;
            }
            case 1: {
                unit = Util.getString("DISK_CYL_LABEL");
                switch (this.theDDI.subsystem.getType()) {
                    case 0: {
                        cylinder = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("798720"), 4).longValue();
                        break;
                    }
                    case 2: 
                    case 3: {
                        cylinder = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("712140"), 4).longValue();
                    }
                }
                this.lbVolumeSize.setText(GUIEntityUtil.getNumberString(new Long(cylinder), 0, Locale.getDefault()) + " " + unit + "; " + GUIEntityUtil.getNumberString(new Double(capacity), 2, Locale.getDefault()) + " " + Util.getString("DISK_GB_LABEL"));
                break;
            }
            case 2: {
                unit = Util.getString("DISK_CYL_LABEL");
                switch (this.theDDI.subsystem.getType()) {
                    case 0: {
                        cylinder = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("860160"), 4).longValue();
                        break;
                    }
                    case 2: 
                    case 3: {
                        cylinder = BigDecimal.valueOf(this.volume.getCapacity()).divide(new BigDecimal("849960"), 4).longValue();
                    }
                }
                this.lbVolumeSize.setText(GUIEntityUtil.getNumberString(new Long(cylinder), 0, Locale.getDefault()) + " " + unit + "; " + GUIEntityUtil.getNumberString(new Double(capacity), 2, Locale.getDefault()) + " " + Util.getString("DISK_GB_LABEL"));
            }
        }
        propPanel.add((Component)this.lbVolumeSize, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_ARRAY_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.lbArray = new JLabel();
        this.lbArray.setText(GUIEntityUtil.getDisplayText(this.volume.getStoragePoolName()));
        propPanel.add((Component)this.lbArray, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_RAIDLEVEL_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.lbRaid = new JLabel();
        int iRaid = this.volume.getRaidLevel();
        if (iRaid == 77) {
            this.lbRaid.setText(Util.getString("DISK_MIXED_LABEL"));
        } else if (iRaid == 99) {
            this.lbRaid.setText(MessageLog.getMessageNoID("GUI0129T"));
        } else {
            this.lbRaid.setText(Util.getString("DISK_RAID_LABEL", String.valueOf(iRaid)));
        }
        propPanel.add((Component)this.lbRaid, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_SUBSYSTEM_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.lbSubsystem = new JLabel();
        this.lbSubsystem.setText(GUIEntityUtil.getDisplayText(this.volume.getSubsystemDeviceId()));
        propPanel.add((Component)this.lbSubsystem, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        propPanel.add((Component)new BoldLabel(Util.getString("DISK_COMMON_SUBSYSTEM_LABEL")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        this.lbSubsystemName = new JLabel();
        this.lbSubsystemName.setText(GUIEntityUtil.getDisplayText(this.volume.getSubsystemName()));
        propPanel.add((Component)this.lbSubsystemName, gbc);
        gbc.insets = new Insets(10, 20, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 6;
        this.lbHostPorts = new BoldLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        propPanel.add((Component)this.lbHostPorts, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        this.lstHostPorts = new JList(this.hostportModel);
        GuiUtil.setAccessibleLabel(this.lbHostPorts, this.lstHostPorts, "", this.lbHostPorts.getText(), this.lbHostPorts.getText());
        TitledBorder listPanelBorder = BorderFactory.createTitledBorder("");
        this.lstHostPorts.setBorder(listPanelBorder);
        int cellWidth = 200;
        this.lstHostPorts.setFixedCellWidth(cellWidth);
        this.lstHostPorts.setVisibleRowCount(10);
        this.lstHostPorts.setSelectionMode(0);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                JList theList = (JList)mouseEvent.getSource();
                if ((mouseEvent.getClickCount() == 1 || mouseEvent.getClickCount() == 2) && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    Object o = theList.getModel().getElementAt(index);
                    Vector ssp_vec = (Vector)VolumeDetailsPanel.this.hmapHosttoSub.get(o.toString());
                    if (ssp_vec != null) {
                        VolumeDetailsPanel.this.subportModel.removeAllElements();
                        Iterator it = ssp_vec.iterator();
                        while (it.hasNext()) {
                            VolumeDetailsPanel.this.subportModel.addElement((String)it.next());
                        }
                    }
                }
            }
        };
        this.lstHostPorts.addMouseListener(mouseListener);
        this.scrollHostP = new JScrollPane(this.lstHostPorts);
        propPanel.add((Component)this.scrollHostP, gbc);
        String[] volarr = new String[]{this.volume.getId()};
        this.theDDI.diskAccessor.getPortAssignments(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    HashMap hmapHostPortVol = (HashMap)response.responseData;
                    Collection clhost = hmapHostPortVol.values();
                    Iterator iterhost = clhost.iterator();
                    if (!iterhost.hasNext()) {
                        VolumeDetailsPanel.this.hostportModel.addElement(Util.getString("DISK_NA_LABEL"));
                        VolumeDetailsPanel.this.subportModel.addElement(Util.getString("DISK_NA_LABEL"));
                    } else {
                        while (iterhost.hasNext()) {
                            GUIPortAssignment assignport = (GUIPortAssignment)iterhost.next();
                            String hpwwpn = assignport.getHostPortWwpn();
                            if (hpwwpn == null || hpwwpn.equals("null")) continue;
                            Vector sspvec = assignport.getSubsystemPorts();
                            Collections.sort(sspvec);
                            VolumeDetailsPanel.this.hmapHosttoSub.put(hpwwpn, sspvec);
                        }
                        Vector hp_vec = new Vector(VolumeDetailsPanel.this.hmapHosttoSub.keySet());
                        Collections.sort(hp_vec);
                        Iterator<Object> it = hp_vec.iterator();
                        while (it.hasNext()) {
                            VolumeDetailsPanel.this.hostportModel.addElement((String)it.next());
                        }
                        VolumeDetailsPanel.this.lstHostPorts.setSelectedIndex(0);
                        Vector ssp_vec = (Vector)VolumeDetailsPanel.this.hmapHosttoSub.get(hp_vec.elementAt(0));
                        it = ssp_vec.iterator();
                        while (it.hasNext()) {
                            VolumeDetailsPanel.this.subportModel.addElement((String)it.next());
                        }
                    }
                }
            }
        }, this.theDDI.subsystem.getId(), volarr[0]);
        gbc.gridx = 1;
        gbc.gridy = 6;
        this.lbSubsystemPorts = new BoldLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        propPanel.add((Component)this.lbSubsystemPorts, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        this.lstSubsystemPorts = new JList(this.subportModel);
        GuiUtil.setAccessibleLabel(this.lbSubsystemPorts, this.lstSubsystemPorts, "", this.lbSubsystemPorts.getText(), this.lbSubsystemPorts.getText());
        this.lstSubsystemPorts.setBorder(listPanelBorder);
        this.lstSubsystemPorts.setFixedCellWidth(cellWidth);
        this.lstSubsystemPorts.setVisibleRowCount(10);
        this.scrollSubP = new JScrollPane(this.lstSubsystemPorts);
        propPanel.add((Component)this.scrollSubP, gbc);
        this.add((Component)propPanel, "Before");
        return this;
    }

    public void actionPerformed(ActionEvent e) {
    }
}

