/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.gui.disk.volume.VolumeDetailsPanel;
import org.eclipse.aperi.gui.disk.volume.VolumeListPanel;

public class VolumePanel
extends JPanel {
    private VolumeDDI theDDI;
    TCloseTabPane tabs = null;
    VolumeListPanel listPanel = null;

    public VolumePanel(VolumeDDI ddi) {
        this.theDDI = ddi;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        if (this.tabs == null) {
            this.tabs = new TCloseTabPane(1);
            this.tabs.setFont(BaseTree.boldFont);
            this.listPanel = new VolumeListPanel(this.theDDI);
            String title = Util.getString("DISK_VOLUMES_LABEL");
            this.tabs.addTab(title, this.listPanel.getComponent(), Util.getString("DISK_TOOLTIP_VOLUMES_LABEL"), false);
            this.add((Component)this.tabs, "Center");
        }
        return this;
    }

    public void showDetails(GUIVolume vol) {
        VolumeDetailsPanel detailPanel = new VolumeDetailsPanel(this.theDDI, vol);
        String tabTitle = String.valueOf(Util.getString("DISK_DETAILS_LABEL", vol.getDeviceId()));
        this.tabs.addTab(tabTitle, detailPanel.getComponent(), Util.getString("DISK_TOOLTIP_DETAILSVOLUME_LABEL"), true);
        this.tabs.setSelectedComponent(detailPanel);
    }
}

