/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.fabric.reports.PortConnectionsAdjuster;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.reports.RespPortConnections;

public class PortConnectionsTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    PortConnectionsModel PortConnectionsModel;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespPortConnections[] data;
    private PortConnectionsAdjuster adjuster;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();

    public PortConnectionsTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new PortConnectionsAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.data = status <= 4 ? (RespPortConnections[])response.responseData : null;
        int cnt = this.data != null ? this.data.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespPortConnections[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.PortConnectionsModel = new PortConnectionsModel();
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        this.table.setBaseTableModel(this.PortConnectionsModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public class SelectListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if ((dataRow -= ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels) < 0 || PortConnectionsTable.this.adjuster.hasTotalsRow() && dataRow == 0) {
                return;
            }
        }
    }

    private class PortConnectionsModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        PortConnectionsModel() {
            this.columnNames = ((PortConnectionsTable)PortConnectionsTable.this).adjuster.colNames;
            this.rowCount = PortConnectionsTable.this.data.length + ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenLabels;
            this.commonAdjuster = PortConnectionsTable.this.adjuster;
        }

        public boolean changeIcon(int rowNum) {
            return rowNum < ((PortConnectionsTable)PortConnectionsTable.this).adjuster.frozenRows;
        }

        public Object getTableDataItem(int row, int col) {
            return PortConnectionsTable.this.adjuster.getCellData(row, PortConnectionsTable.this.adjuster.translateColumn(col));
        }
    }
}

