/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetTablePanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneTablePanel;

public class ZoneDefinitionPanel
extends JPanel
implements ActionListener {
    protected ZoneCNS zoneCNS = null;
    private JButton activateButton = new JButton(FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"));
    private JButton updateButton = new JButton(FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"));
    private static final int ZS_DESCRIPTION_COL = 2;
    private static final int STATE_COL = 1;
    private static final int ZONESET_COL = 0;
    private boolean closeNow = false;
    private ZoneTablePanel zoneTable;
    private ZoneSetTablePanel zoneSetTable;
    private String sanWWN = null;
    private String sanLabel = null;

    public ZoneDefinitionPanel(ZoneCNS cns) {
        this.zoneCNS = cns;
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "North");
        this.add((Component)this.createTablesPanel(), "Center");
        this.activateButton.addActionListener(this);
        this.updateButton.addActionListener(this);
    }

    private JPanel createTablesPanel() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        this.zoneTable = new ZoneTablePanel(this.zoneCNS);
        this.zoneSetTable = new ZoneSetTablePanel(this.zoneCNS);
        tablePanel.add((Component)this.zoneSetTable, "North");
        tablePanel.add((Component)this.zoneTable, "Center");
        return tablePanel;
    }

    public JPanel createButtonPanel() {
        JPanel buttons = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.activateButton, FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"));
        this.activateButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricButtonMnemonic_updateAndActivate")));
        buttons.add(this.activateButton);
        if (this.zoneCNS.getZoneCapabilities().isSupportsFullZoneDB()) {
            GuiUtil.setAccessible(this.updateButton, FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"), FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"));
            this.updateButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricButtonMnemonic_updateOnly")));
            buttons.add(this.updateButton);
        }
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(new TitledBorder(Util.getString("FabricZone_DisplayZones")));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(15, 10, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        tempPanel.add((Component)buttons, c);
        return tempPanel;
    }

    public void refreshDefPanel() {
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.zoneTable.refreshTable(this.zoneCNS);
        this.zoneSetTable.refreshTable(this.zoneCNS);
        this.repaint();
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public void setCloseNow(boolean close) {
        this.closeNow = close;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.activateButton) {
            if (this.zoneCNS.hasAnyZoneError() || this.zoneCNS.hasAnyZoneSetError()) {
                this.displayZoneDefError();
                return;
            }
            this.zoneCNS.saveZoneDef(this, 1);
        } else if (source == this.updateButton) {
            if (this.zoneCNS.hasAnyZoneError() || this.zoneCNS.hasAnyZoneSetError()) {
                this.displayZoneDefError();
                return;
            }
            this.zoneCNS.saveZoneDef(this, 0);
        }
    }

    private int promptForSaveAction() {
        int flag = 1;
        if (this.zoneCNS.getZoneCapabilities().isSupportsFullZoneDB()) {
            Object[] options = new Object[]{FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"), FabricGuiUtil.getString("FabricButton_Cancel")};
            int option = JOptionPane.showOptionDialog(this, FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_ua") + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_u") + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_c"), FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestionTitle"), -1, 2, null, options, options[0]);
            if (option == 2) {
                flag = 9;
            } else if (option == 1) {
                flag = 0;
            }
        } else {
            Object[] options = new Object[]{FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricButton_Cancel")};
            flag = JOptionPane.showOptionDialog(this, FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_ua") + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_c"), FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestionTitle"), -1, 2, null, options, options[0]);
            if (flag == 1) {
                flag = 9;
            }
        }
        return flag;
    }

    public boolean closeNow() {
        return this.closeNow;
    }

    private void displayZoneDefError() {
        String msgLabel = Util.getString("FabricZoneNotebook_IncorrectZoningConfig");
        JOptionPane.showMessageDialog(this, msgLabel);
    }
}

