/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSelectorPanel
implements ActionListener {
    ZoneCNS zoneCNS;
    ZoneSet zoneSet;
    Zone[] origZones;
    DefaultListModel srcModel = new DefaultListModel();
    DefaultListModel selModel = new DefaultListModel();
    JList selList;
    TUpDownListSelector listSelector;

    public ZoneSelectorPanel(ZoneCNS cns, ZoneSet zs, Zone[] zones) {
        this.zoneCNS = cns;
        this.zoneSet = zs;
        this.origZones = zones;
    }

    public JPanel createPanel() {
        JPanel returnPanel = new JPanel(new BorderLayout());
        this.selList = this.createCurrentZonesList();
        this.listSelector = new TUpDownListSelector(this.createAvailableZonesList(), this.selList, FabricGuiUtil.getString("FabricZone_PotentialZones"), FabricGuiUtil.getString("FabricZone_CurrentZones"), false);
        this.populateModels();
        returnPanel.add((Component)this.listSelector, "Center");
        return returnPanel;
    }

    private void populateModels() {
        int i;
        Zone[] allZones = this.zoneCNS.getAllZones();
        HashMap<String, String> zones = new HashMap<String, String>();
        if (this.origZones != null) {
            for (i = 0; i < this.origZones.length; ++i) {
                this.selModel.addElement(this.origZones[i].getName());
                zones.put(this.origZones[i].getName(), this.origZones[i].getName());
            }
        }
        for (i = 0; i < allZones.length; ++i) {
            if (zones.containsKey(allZones[i].getName())) continue;
            this.srcModel.addElement(allZones[i].getName());
        }
    }

    public ArrayList getSelectList() {
        return this.listSelector.getSelList();
    }

    private JList createAvailableZonesList() {
        return new JList(this.srcModel);
    }

    private JList createCurrentZonesList() {
        return new JList(this.selModel);
    }

    public void actionPerformed(ActionEvent e) {
    }
}

