/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneTablePanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    protected ZoneCNS zoneCNS = null;
    private MegaTable zoneTable = new MegaTable();
    private ZoneTableModel zoneModel;
    private Zone[] zoneTableData;
    private JPanel tablePanel;
    private JLabel zoneLabel = new JLabel(FabricGuiUtil.getString("FabricZonePage_PageTitle"));
    private boolean dblClick = false;
    private JButton addZoneButton = new JButton(FabricGuiUtil.getString("FabricZonePanel_add"));
    private JButton delZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Delete"));
    private JButton dupZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Duplicate"));
    private JButton editZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Edit"));
    private static final ImageIcon ERROR_ICON = GuiUtil.createImageIcon("images/exclam.gif", Util.getString("DESC_ZONE_ERROR"));
    private static final int ZONE_COL = 0;
    private static final int ZONE_DESCRIPTION_COL = 1;
    private static final String[] ZONE_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_Column"), FabricGuiUtil.getString("FabricZone_Description_Column")};
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ZoneTablePanel(ZoneCNS ddi) {
        this.zoneCNS = ddi;
        this.setBorder(new TitledBorder(Util.getString("FabricZonePage_PageTitle")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.add((Component)this.createButtonPanel(), "North");
        this.tablePanel = this.createZoneTable();
        tempPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)tempPanel, c);
        this.addZoneButton.addActionListener(this);
        this.editZoneButton.addActionListener(this);
        this.dupZoneButton.addActionListener(this);
        this.delZoneButton.addActionListener(this);
        this.refreshTable(this.zoneCNS);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel2 = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.addZoneButton, FabricGuiUtil.getString("FabricZonePanel_add"), FabricGuiUtil.getString("FabricZonePanel_add"));
        this.addZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZonePanel_add_M")));
        buttonPanel2.add(this.addZoneButton);
        GuiUtil.setAccessible(this.delZoneButton, FabricGuiUtil.getString("FabricZone_Delete"), FabricGuiUtil.getString("FabricZone_Delete"));
        this.delZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Delete_M")));
        buttonPanel2.add(this.delZoneButton);
        GuiUtil.setAccessible(this.editZoneButton, FabricGuiUtil.getString("FabricZone_Edit"), FabricGuiUtil.getString("FabricZone_Edit"));
        this.editZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Edit_M")));
        buttonPanel2.add(this.editZoneButton);
        GuiUtil.setAccessible(this.dupZoneButton, FabricGuiUtil.getString("FabricZone_Duplicate"), FabricGuiUtil.getString("FabricZone_Duplicate"));
        this.dupZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Duplicate_M")));
        buttonPanel2.add(this.dupZoneButton);
        return buttonPanel2;
    }

    private JPanel createZoneTable() {
        JPanel fabricPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(15, 10, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        JPanel tempPanel = new JPanel(new FlowLayout());
        this.initializeZoneTable();
        tempPanel.add(this.zoneTable);
        fabricPanel.add((Component)tempPanel, c);
        return tempPanel;
    }

    public void refreshTable(ZoneCNS ddi) {
        this.zoneCNS = ddi;
        boolean empty = this.zoneModel.refreshTableData();
        this.zoneModel.tableDataReset();
        this.tablePanel.removeAll();
        if (!empty) {
            this.tablePanel.add(this.zoneTable);
        } else {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        }
        this.zoneTable.sortByColumn(0, -1);
    }

    private void initializeZoneTable() {
        this.zoneTable.setSelectionPolicy(0);
        this.zoneTable.setMouseListener(this);
        this.zoneModel = new ZoneTableModel();
        this.zoneTable.setCellRenderer(String.class, new IconTableCellRenderer());
        this.zoneTable.setBaseTableModel(this.zoneModel);
        boolean vColIndex = false;
        this.zoneTable.sortByColumn(0, -1);
    }

    public void actionPerformed(ActionEvent event) {
        Zone[] zones;
        Object source = event.getSource();
        if (source == this.addZoneButton) {
            if (this.zoneCNS.getZoneCapabilities().getMaxZones() == this.zoneTable.getNumRows()) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZonePage_MaxZones"));
            } else {
                ZoneWizard wiz = new ZoneWizard(this.zoneCNS);
                JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
                wizardDialog.getContentPane().add(wiz);
                wizardDialog.pack();
                GuiUtil.centerDialog(wizardDialog);
                wizardDialog.show();
            }
        } else if (source == this.delZoneButton) {
            int result = JOptionPane.showConfirmDialog(this, FabricGuiUtil.getString("FabricZonePage_DeleteZoneWarning"), FabricGuiUtil.getString("FabricZonePage_DeleteZoneTitle"), 0);
            if (result == 0) {
                Zone[] zoneArray = this.getSelectedZones();
                this.zoneCNS.deleteZones(zoneArray);
                for (int i = 0; i < zoneArray.length; ++i) {
                    this.zoneCNS.removeZoneConfigError(zoneArray[i].getName());
                }
                ZoneSet[] zSets = this.zoneCNS.deleteZones(zoneArray);
                if (zSets.length != 0) {
                    for (int j = 0; j < zSets.length; ++j) {
                        this.zoneCNS.addZoneSet(zSets[j]);
                        this.zoneCNS.addZoneSetConfigError(zSets[j].getName());
                    }
                }
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (source == this.dupZoneButton) {
            Zone[] zones2 = this.getSelectedZones();
            if (zones2 != null && zones2.length > 0) {
                Zone editZone = zones2[0];
                ZoneWizard wiz = new ZoneWizard(editZone, this.zoneCNS, true, false);
                JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
                wizardDialog.getContentPane().add(wiz);
                wizardDialog.pack();
                GuiUtil.centerDialog(wizardDialog);
                wizardDialog.show();
            }
        } else if (source == this.editZoneButton && (zones = this.getSelectedZones()) != null && zones.length > 0) {
            Zone editZone = zones[0];
            ZoneWizard wiz = new ZoneWizard(editZone, this.zoneCNS, false, true);
            JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
            wizardDialog.getContentPane().add(wiz);
            wizardDialog.pack();
            GuiUtil.centerDialog(wizardDialog);
            wizardDialog.show();
        }
    }

    private Zone[] getSelectedZones() {
        int[] selected = this.zoneTable.getSelectedRows();
        Zone[] zones = new Zone[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            zones[i] = this.zoneTableData[selected[i]];
        }
        return zones;
    }

    private JPanel getPane(JComponent component, JLabel title) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(component);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)title, "North");
        pane.add((Component)scrollPane, "Center");
        return pane;
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
    }

    public void selectionChanged(boolean state) {
    }

    public void doubleClick(int dataRow, int dataCol) {
    }

    public void showDefaultChart(int dataRow) {
    }

    static /* synthetic */ Zone[] access$102(ZoneTablePanel x0, Zone[] x1) {
        x0.zoneTableData = x1;
        return x1;
    }

    class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object o) {
            this.setHorizontalAlignment(2);
            this.setVerticalTextPosition(1);
            String name = (String)o;
            if (name != null && this.hasIcon(name)) {
                this.setIcon(ERROR_ICON);
            } else {
                this.setIcon(null);
            }
            this.setText(name);
        }

        protected boolean hasIcon(String name) {
            return ZoneTablePanel.this.zoneCNS.hasZoneError(name);
        }
    }

    private class ZoneTableModel
    extends BaseTableModel {
        ZoneTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean empty = false;
            this.columnNames = ZONE_COL_NAMES;
            ZoneTablePanel.access$102(ZoneTablePanel.this, ZoneTablePanel.this.zoneCNS.getZoneDefinition(false).getZones());
            if (ZoneTablePanel.this.zoneTableData == null || ZoneTablePanel.this.zoneTableData.length == 0) {
                empty = true;
                return empty;
            }
            return empty;
        }

        public void tableDataReset() {
            this.rowCount = ZoneTablePanel.this.zoneTableData.length;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int row, int col) {
            try {
                switch (col) {
                    case 0: {
                        return ZoneTablePanel.this.zoneTableData[row].getName();
                    }
                    case 1: {
                        return ZoneTablePanel.this.zoneTableData[row].getDescription();
                    }
                }
                return FabricGuiUtil.getString("FabricAgent_Unknown");
            }
            catch (Exception ex) {
                return null;
            }
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            ZoneTablePanel.this.zoneTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            ZoneTablePanel.this.zoneTable.sortByColumn(0, -1);
        }
    }
}

