/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.frames;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.tape.common.model.GUIFrame;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;

public class FramesTableModel
extends BaseTableModel {
    private FramesDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_NAME_LABEL"), Util.getString("TAPE_LOCK_PRESENT_LABEL"), Util.getString("TAPE_LOCKED_LABEL"), Util.getString("TAPE_SECURITY_LABEL")};
    private static final int FRAME_NAME = 0;
    private static final int FRAME_LOCK = 1;
    private static final int FRAME_LOCKED = 2;
    private static final int FRAME_SEC = 3;

    FramesTableModel(FramesDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getLibraryDetails().size();
    }

    public Object getTableDataItem(int row, int col) {
        GUIFrame frame = (GUIFrame)this.aDDI.getLibraryDetails().elementAt(row);
        switch (col) {
            case 0: {
                return frame.getName();
            }
            case 1: {
                if (!frame.isLockPresent()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 2: {
                if (!frame.isLocked()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
        }
        return "";
    }
}

