/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.mediachangers;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.model.GUIMediaChanger;
import org.eclipse.aperi.gui.tape.mediachangers.MediaChangersDDI;

public class MediaChangersTableModel
extends BaseTableModel {
    private MediaChangersDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_MEDIA_CHANGER_LABEL"), Util.getString("TAPE_STATE_LABEL"), Util.getString("TAPE_MEDIA_FLIP_SUPPORTED"), Util.getString("TAPE_WWNN_LABEL"), Util.getString("TAPE_FIRMWARE_LABEL")};
    private static final int LIB_MEDIACHANGER = 0;
    private static final int LIB_STATE = 1;
    private static final int LIB_MEDIA = 2;
    private static final int LIB_WWPN = 3;
    private static final int LIB_FIRMWARE = 4;

    MediaChangersTableModel(MediaChangersDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getMediaChangers().size();
    }

    public Object getTableDataItem(int row, int col) {
        GUIMediaChanger MD = (GUIMediaChanger)this.aDDI.getMediaChangers().elementAt(row);
        switch (col) {
            case 0: {
                return MD.getName();
            }
            case 1: {
                JLabel lb = GUIEntityUtil.getEntityStateLabel(MD);
                return lb;
            }
            case 2: {
                if (!MD.isMediaFlipSupported()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 3: {
                return MD.getWwpn();
            }
            case 4: {
                return MD.getVersion();
            }
        }
        return "";
    }
}

