/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.text.CollationKey;
import java.util.HashSet;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;

public class GraphEntity
implements Serializable,
Comparable {
    protected ID entityID;
    protected String DisplayName;
    protected Integer HealthStatus;
    protected Integer OperationalStatus;
    protected Integer ConsolidatedStatus;
    protected Integer PerfStatus;
    protected String UDP1;
    protected String UDP2;
    protected String UDP3;
    protected HashSet ScopeSet;
    protected Boolean IsHelper;
    protected Boolean IsFilterable;
    protected GraphGroupKey GroupKey;
    protected Comparable SortingValue;
    protected CollationKey CollationKey;

    public GraphEntity(ID entityID) {
        this.entityID = entityID;
        this.ScopeSet = new HashSet();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.entityID.getType().getType() + "(id=" + this.entityID.getID() + ", ScopeSet=" + this.ScopeSet + ")");
        sb.append(" {");
        StringBuffer propSB = new StringBuffer();
        this.toString_helper(propSB);
        sb.append(propSB);
        sb.append("}");
        return sb.toString();
    }

    protected void toString_helper(StringBuffer sb) {
        sb.append("DisplayName=" + this.DisplayName + ",");
        sb.append("HealthStatus=" + this.HealthStatus + ",");
        sb.append("OperationalStatus=" + this.OperationalStatus + ",");
        sb.append("ConsolidatedStatus=" + this.ConsolidatedStatus + ",");
        sb.append("PerfStatus=" + this.PerfStatus + ",");
        sb.append("UDP1=" + this.UDP1 + ",");
        sb.append("UDP2=" + this.UDP2 + ",");
        sb.append("UDP3=" + this.UDP3 + ",");
        sb.append("ScopeSet=" + this.ScopeSet + ",");
        sb.append("IsHelper=" + this.IsHelper + ",");
        sb.append("IsFilterable=" + this.IsFilterable + ",");
        sb.append("GroupKey=" + this.GroupKey + ",");
        sb.append("SortingValue=" + this.SortingValue + ",");
        sb.append("CollationKey=" + this.CollationKey + ",");
    }

    public Object clone() {
        GraphEntity o = new GraphEntity((ID)this.entityID.clone());
        this.clone_helper(o);
        return o;
    }

    protected void clone_helper(GraphEntity entity) {
        GraphEntity o = entity;
        o.setDisplayName(this.DisplayName);
        o.setHealthStatus(this.HealthStatus);
        o.setOperationalStatus(this.OperationalStatus);
        o.setConsolidatedStatus(this.ConsolidatedStatus);
        o.setPerfStatus(this.PerfStatus);
        o.setUDP1(this.UDP1);
        o.setUDP2(this.UDP2);
        o.setUDP3(this.UDP3);
        o.setScopeSet(new HashSet(this.ScopeSet));
        o.setIsHelper(this.IsHelper);
        o.setIsFilterable(this.IsFilterable);
        o.setGroupKey(this.GroupKey == null ? null : new GraphGroupKey(this.GroupKey));
        o.setSortingValue(this.SortingValue);
        o.setCollationKey(this.CollationKey);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphEntity)) {
            return false;
        }
        GraphEntity a = (GraphEntity)o;
        return this.entityID.equals(a.getEntityID());
    }

    public int hashCode() {
        return this.entityID.hashCode();
    }

    public int compareTo(Object o) {
        ID a = this.getEntityID();
        ID b = ((GraphEntity)o).getEntityID();
        return a.compareTo(b);
    }

    public ID getEntityID() {
        return this.entityID;
    }

    public void setEntityID(ID entityID) {
        this.entityID = entityID;
    }

    public void setEntityID(GraphEntity entity) {
        this.entityID = entity.getEntityID();
    }

    public String getDisplayName() {
        return this.DisplayName;
    }

    public void setDisplayName(String value) {
        this.DisplayName = value;
    }

    public Integer getHealthStatus() {
        return this.HealthStatus;
    }

    public void setHealthStatus(Integer value) {
        this.HealthStatus = value;
    }

    public Integer getOperationalStatus() {
        return this.OperationalStatus;
    }

    public void setOperationalStatus(Integer value) {
        this.OperationalStatus = value;
    }

    public Integer getConsolidatedStatus() {
        return this.ConsolidatedStatus;
    }

    public void setConsolidatedStatus(Integer value) {
        this.ConsolidatedStatus = value;
    }

    public Integer getPerfStatus() {
        return this.PerfStatus;
    }

    public void setPerfStatus(Integer value) {
        this.PerfStatus = value;
    }

    public String getUDP1() {
        return this.UDP1;
    }

    public void setUDP1(String value) {
        this.UDP1 = value;
    }

    public String getUDP2() {
        return this.UDP2;
    }

    public void setUDP2(String value) {
        this.UDP2 = value;
    }

    public String getUDP3() {
        return this.UDP3;
    }

    public void setUDP3(String value) {
        this.UDP3 = value;
    }

    public HashSet getScopeScopeSet() {
        return this.ScopeSet;
    }

    public void setScopeSet(HashSet ScopeSet) {
        this.ScopeSet = ScopeSet;
    }

    public boolean containScope(String scope) {
        return this.ScopeSet.contains(scope);
    }

    public void addScope(String scope) {
        this.ScopeSet.add(scope);
    }

    public void removeScope(String scope) {
        this.ScopeSet.remove(scope);
    }

    public void removeAllScopes() {
        this.ScopeSet.clear();
    }

    public Boolean getIsHelper() {
        return this.IsHelper;
    }

    public void setIsHelper(Boolean value) {
        this.IsHelper = value;
    }

    public Boolean getIsFilterable() {
        return this.IsFilterable;
    }

    public void setIsFilterable(Boolean value) {
        this.IsFilterable = value;
    }

    public GraphGroupKey getGroupKey() {
        return this.GroupKey;
    }

    public void setGroupKey(GraphGroupKey value) {
        this.GroupKey = value;
    }

    public Comparable getSortingValue() {
        return this.SortingValue;
    }

    public void setSortingValue(Comparable value) {
        this.SortingValue = value;
    }

    public CollationKey getCollationKey() {
        return this.CollationKey;
    }

    public void setCollationKey(CollationKey value) {
        this.CollationKey = value;
    }

    public static class ID
    implements Serializable,
    Comparable {
        protected Type type;
        protected Object id;

        public ID(Type entityType, Object id) {
            this.type = entityType;
            this.id = id;
        }

        public String toString() {
            return this.type.getType() + ".ID(" + this.id + ")";
        }

        public Object clone() {
            ID o = new ID(this.type, this.id);
            return o;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof ID)) {
                return false;
            }
            ID a = (ID)o;
            if (!this.type.equals(a.getType())) {
                return false;
            }
            return this.id.equals(a.getID());
        }

        public int hashCode() {
            return this.type.hashCode() + this.id.hashCode();
        }

        public int compareTo(Object o) {
            Comparable a = (Comparable)this.getID();
            Object b = ((ID)o).getID();
            return a.compareTo(b);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Object getID() {
            return this.id;
        }

        public void setID(Object id) {
            this.id = id;
        }
    }

    public static class Type
    implements Serializable,
    Comparable {
        protected Object type;
        protected boolean isAssociation;

        public Type(Object type, boolean isAssociation) {
            this.type = type;
            this.isAssociation = isAssociation;
        }

        public String toString() {
            return this.type.toString();
        }

        public Object clone() {
            Type o = new Type(this.type, this.isAssociation);
            return o;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Type)) {
                return false;
            }
            Type a = (Type)o;
            return this.type.equals(a.getType());
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public int compareTo(Object o) {
            Comparable a = (Comparable)this.getType();
            Object b = ((Type)o).getType();
            return a.compareTo(b);
        }

        public Object getType() {
            return this.type;
        }

        public void setType(Object type) {
            this.type = type;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public void setAssociation(boolean isAssoc) {
            this.isAssociation = isAssoc;
        }
    }
}

