/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.eclipse.aperi.gui.topo.model.GraphEntity;

public class GraphGroupKey
implements Serializable,
Comparable {
    protected Vector keyV = new Vector();

    public GraphGroupKey() {
        this(null);
    }

    public GraphGroupKey(GraphGroupKey old) {
        if (old != null) {
            Vector v = old.getKeys();
            for (int i = 0; i < v.size(); ++i) {
                Key key = (Key)v.elementAt(i);
                this.addKey(key);
            }
        }
    }

    public String getID() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.keyV.size(); ++i) {
            if (i != 0) {
                sb.append("+");
            }
            Key key = (Key)this.keyV.elementAt(i);
            sb.append(key.getMethodValue());
        }
        return sb.toString();
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.keyV.size(); ++i) {
            if (i != 0) {
                sb.append("+");
            }
            Key key = (Key)this.keyV.elementAt(i);
            sb.append(key.getMethodValueAlias());
        }
        return sb.toString();
    }

    public String getFullLabel() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.keyV.size(); ++i) {
            if (i != 0) {
                sb.append("+");
            }
            Key k = (Key)this.keyV.elementAt(i);
            sb.append(k.getMethodName() + ":" + k.getMethodValueAlias());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GraphGroupKeys{");
        for (int i = 0; i < this.keyV.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            Key key = (Key)this.keyV.elementAt(i);
            sb.append(key);
        }
        sb.append("}");
        return sb.toString();
    }

    public Object clone() {
        return new GraphGroupKey(this);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphGroupKey)) {
            return false;
        }
        GraphGroupKey a = (GraphGroupKey)o;
        Vector v = a.getKeys();
        if (this.keyV.size() != v.size()) {
            return false;
        }
        for (int i = 0; i < this.keyV.size(); ++i) {
            Key key2;
            Key key1 = (Key)this.keyV.elementAt(i);
            if (key1.equals(key2 = (Key)v.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.keyV.size(); ++i) {
            Key key = (Key)this.keyV.elementAt(i);
            hash += key.hashCode();
        }
        return hash;
    }

    public int compareTo(Object o) {
        Key key2;
        Key key1;
        GraphGroupKey a = (GraphGroupKey)o;
        int result = 0;
        for (int i = 0; i < this.keyV.size() && (result = (key1 = (Key)this.keyV.elementAt(i)).compareTo(key2 = (Key)a.getKeys().elementAt(i))) == 0; ++i) {
        }
        return result;
    }

    public Vector getKeys() {
        return this.keyV;
    }

    public Key getKey(int index) {
        return (Key)this.keyV.elementAt(index);
    }

    public void addKey(Key key) {
        this.keyV.add(key);
    }

    public boolean isEmpty() {
        return this.keyV.isEmpty();
    }

    public static class Key
    implements Serializable,
    Comparable {
        protected String methodName;
        protected Comparable methodValue;
        protected String methodValueAlias;
        protected GraphEntity entity;
        protected ImageIcon iconSelected;
        protected ImageIcon iconUnselected;

        public Key(String methodName, Comparable methodValue) {
            this(methodName, methodValue, methodValue.toString());
        }

        public Key(String methodName, Comparable methodValue, String methodValueAlias) {
            this.methodName = methodName;
            this.methodValue = methodValue;
            this.methodValueAlias = methodValueAlias;
        }

        public String toString() {
            return "(" + this.methodName + "," + this.methodValue + "," + this.entity + ")";
        }

        public Object clone() {
            Key k = new Key(this.methodName, this.methodValue, this.methodValueAlias);
            k.setJumping(this.entity, this.iconSelected, this.iconUnselected);
            return k;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key a = (Key)o;
            if (!this.methodName.equals(a.getMethodName())) {
                return false;
            }
            return this.methodValue.equals(a.getMethodValue());
        }

        public int hashCode() {
            return this.methodName.hashCode() + this.methodValue.hashCode();
        }

        public int compareTo(Object o) {
            Key a = (Key)o;
            return this.methodValue.compareTo(a.getMethodValue());
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Comparable getMethodValue() {
            return this.methodValue;
        }

        public String getMethodValueAlias() {
            return this.methodValueAlias;
        }

        public GraphEntity getJumpingEntity() {
            return this.entity;
        }

        public ImageIcon getIconSelected() {
            return this.iconSelected;
        }

        public ImageIcon getIconUnselected() {
            return this.iconUnselected;
        }

        public void setJumping(GraphEntity entity, ImageIcon iconSelected, ImageIcon iconUnselected) {
            this.entity = entity;
            this.iconSelected = iconSelected;
            this.iconUnselected = iconUnselected;
            entity.setCollationKey(null);
        }
    }
}

