/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSubsystemL1Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;

public class GraphModelSubsystemL1
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelSubsystemL1(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        ID multiEntityID = (ID)this.modelID;
        GraphEntity srcGroupEntity = multiEntityID.getSrcGroupEntity();
        Vector childFocusEntityIDV = multiEntityID.getChildFocusEntityIDs();
        Vector<GraphEntity> childFocusEntityV = new Vector<GraphEntity>();
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphEntity.ID entityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
            GraphEntity entity = this.get(entityID);
            childFocusEntityV.add(entity);
        }
        String subsystemGroupIDStr = "Focus";
        GraphSubsystemGroup subsystemGroup = new GraphSubsystemGroup(subsystemGroupIDStr);
        GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
        subsystemGroup.setDisplayName(srcGroupEntity.getDisplayName());
        subsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(childFocusEntityV));
        subsystemGroup.setSortingValue(srcGroupEntity.getSortingValue());
        subsystemGroup.setGroupKey(srcGroupEntity.getGroupKey());
        this.put(subsystemGroup);
        multiEntityID.setFocusEntityID(subsystemGroupID);
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)childFocusEntityIDV.elementAt(i);
            GraphSubsystemGroup2Subsystem assoc = new GraphSubsystemGroup2Subsystem(subsystemGroupID.getID() + "+" + subsystemID.getID());
            assoc.setSubsystemGroupID(subsystemGroupID);
            assoc.setSubsystemID(subsystemID);
            this.put(assoc);
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewSubsystemL1Connectivity connectivity = new GraphSubviewSubsystemL1Connectivity("Connectivity");
        GraphSubviewSubsystemL1Connectivity.ID connectivityID = (GraphSubviewSubsystemL1Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphSwitch2Subsystem sw2subsystem;
        Boolean filterable;
        int unfilteredCount;
        int totalCount;
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration subsystemEnu = this.associator(GraphSubsystemGroup2Subsystem.TYPE, subsystemGroupID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(subsystem)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration sw2subsytemEnu = this.reference(GraphSwitch2Subsystem.TYPE, subsystemID);
                        while (sw2subsytemEnu.hasMoreElements()) {
                            sw2subsystem = (GraphSwitch2Subsystem)sw2subsytemEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2subsystem)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSwitch.ID swID = sw2subsystem.getSwitchID();
                            GraphSwitch sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                subsystem.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            subsystemGroup.setNumOfSubsystems(new Integer(totalCount));
            subsystemGroup.setNumOfAbnormalSubsystems(new Integer(unfilteredCount));
            subsystemGroup.setIsFilterable(Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration sw2subsystemEnu = this.reference(GraphSwitch2Subsystem.TYPE, swID);
                        while (sw2subsystemEnu.hasMoreElements()) {
                            sw2subsystem = (GraphSwitch2Subsystem)sw2subsystemEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2subsystem)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSubsystem.ID subsystemID = sw2subsystem.getSubsystemID();
                            GraphSubsystem subsystem = (GraphSubsystem)this.get(subsystemID);
                            if (!GraphModelUtilities.isAbnormal(subsystem)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewSubsystemL1Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewSubsystemL1Connectivity connectivity = (GraphSubviewSubsystemL1Connectivity)connectivityEnu.nextElement();
            int totalCount2 = 0;
            int unfilteredCount2 = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount2 += swGroup.getNumOfSwitches().intValue();
                unfilteredCount2 += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount2));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount2));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.MultiEntityID {
        public ID(GraphSubsystemGroup srcGroupEntity, Vector childFocusEntityIDV) {
            super("SubsystemL1", srcGroupEntity, childFocusEntityIDV);
        }
    }
}

