/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;

public class GraphScopedID
implements Serializable,
Comparable {
    protected GraphEntity.ID entityID;
    protected String scope;
    protected GraphScopedType scopedType;

    public GraphScopedID(GraphEntity.ID entityID, String scope) {
        this.entityID = entityID;
        this.scope = scope;
        this.scopedType = new GraphScopedType(entityID.getType(), scope);
    }

    public String toString() {
        return this.entityID.getType() + "(" + this.scope + "," + this.entityID.getID() + ")";
    }

    public Object clone() {
        GraphScopedID o = new GraphScopedID(this.entityID, this.scope);
        return o;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphScopedID)) {
            return false;
        }
        GraphScopedID a = (GraphScopedID)o;
        if (!this.entityID.equals(a.getEntityID())) {
            return false;
        }
        return this.scopedType.equals(a.getScopedType());
    }

    public int hashCode() {
        return this.entityID.hashCode() + this.scopedType.hashCode();
    }

    public int compareTo(Object o) {
        GraphScopedID a = (GraphScopedID)o;
        int result = this.entityID.compareTo(a.getEntityID());
        if (result == 0) {
            result = this.scopedType.compareTo(a.getScopedType());
        }
        return result;
    }

    public GraphEntity.ID getEntityID() {
        return this.entityID;
    }

    public void setEntityID(GraphEntity.ID entityID) {
        this.entityID = entityID;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public GraphScopedType getScopedType() {
        return this.scopedType;
    }
}

