/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.test;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOverview;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL2;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2DatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2HBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2LogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk2DiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2PoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Pool;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2SwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2TapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.gui.topo.test.SampleGraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class SampleTopoDataManager
implements ITopoBackend {
    private ControllerApp controllerApp;
    private BackendData data;
    private LinkedList queue = new LinkedList();
    private Vector mgrV;

    public SampleTopoDataManager() {
        this.data = new BackendData();
        this.mgrV = new Vector();
        for (int i = 0; i < 3; ++i) {
            BackendMgr backendMgr = new BackendMgr(i);
            this.mgrV.add(backendMgr);
            backendMgr.start();
        }
        TopoSetting setting = new TopoSetting();
        this.controllerApp = new ControllerApp();
        this.controllerApp.setSessionModel(this, setting);
    }

    public ControllerApp getTopoControllerApp() {
        return this.controllerApp;
    }

    public JTopoApp getTopoViewer() {
        return this.controllerApp.getTopoApp();
    }

    private void simulateDataChange_SubsystemStatus() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_SubsystemStatus' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_SubsystemStatus' wake up!");
                    String[] ids = new String[]{"subsystem0"};
                    SampleTopoDataManager.this.data.simulateDataChange_SubsystemStatus(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_ComputerStatus() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_ComputerStatus' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_ComputerStatus' wake up!");
                    String[] ids = new String[]{"computer0"};
                    SampleTopoDataManager.this.data.simulateDataChange_ComputerStatus(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidFabric() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidFabric' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidFabric' wake up!");
                    String[] ids = new String[]{"fabric0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidFabric(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidSwitch() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidSwitch' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidSwitch' wake up!");
                    String[] ids = new String[]{"sw0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidSwitch(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidComputer() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidComputer' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidComputer' wake up!");
                    String[] ids = new String[]{"computer0", "computer4"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidComputer(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidSubsystem() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidSubsystem' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidSubsystem' wake up!");
                    String[] ids = new String[]{"subsystem0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidSubsystem(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidTapeLibrary() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidTapeLibrary' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidTapeLibrary' wake up!");
                    String[] ids = new String[]{"tape0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidTapeLibrary(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void simulateDataChange_InvalidOther() {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidOther' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidOther' wake up!");
                    String[] ids = new String[]{"other0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidOther(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public void refreshView(GraphModel.ID modelID) {
        GraphDebug.info("SampleTopoDataManager, refreshView, modelID=" + modelID);
        Hashtable<String, Object> req = new Hashtable<String, Object>();
        req.put("cmd", "refresh");
        req.put("modelID", modelID);
        this.addJob(req);
    }

    public void refreshAllViews() {
        GraphDebug.info("SampleTopoDataManager, refreshAllViews");
        Vector v = this.controllerApp.getOpenedViews();
        for (int i = 0; i < v.size(); ++i) {
            GraphModel.ID modelID = (GraphModel.ID)v.elementAt(i);
            Hashtable<String, Object> req = new Hashtable<String, Object>();
            req.put("cmd", "refresh");
            req.put("modelID", modelID);
            this.addJob(req);
        }
    }

    public void closeView(GraphModel.ID modelID) {
        GraphDebug.info("SampleTopoDataManager, closeView, modelID=" + modelID);
    }

    public void removeEntity(Vector v) {
        GraphDebug.info("SampleTopoDataManager, removeEntity, v=" + v);
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof GraphEntity.ID)) continue;
            System.out.println("WARNING:, removeEntity is a GraphNode.ID, =" + v.elementAt(i));
        }
    }

    public void launchElementManager(GraphEntity node) {
        GraphDebug.info("SampleTopoDataManager, launchElementManager, node=" + node);
    }

    public void launchDetailsPanel(GraphEntity.ID nodeID) {
        GraphDebug.info("SampleTopoDataManager, launchDetailsPanel, nodeID=" + nodeID);
    }

    public void setTimeout(int newtimeout) {
        GraphDebug.info("SampleTopoDataManager, setTimeout, new timeout=" + newtimeout);
    }

    public void refreshPinList(GraphModel.ID modelID) {
        GraphDebug.info("SampleTopoDataManager, refreshPinList");
    }

    public synchronized void addJob(Object req) {
        this.queue.addLast(req);
        this.notifyAll();
    }

    public synchronized Object getJob() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return this.queue.removeFirst();
    }

    public void persistTopoSettings(TopoSetting settings) {
    }

    private static class BackendData {
        private SampleGraphModel model = new SampleGraphModel();
        private Vector pinListV = new Vector();

        private int getAbnormalSize(Vector v) {
            int count = 0;
            for (int i = 0; i < v.size(); ++i) {
                GraphEntity node = (GraphEntity)v.elementAt(i);
                if (!GraphModelUtilities.isAbnormal(node)) continue;
                ++count;
            }
            return count;
        }

        private GraphModelOverview generateOverview(GraphModelOverview.ID modelID) {
            GraphEntity computer;
            GraphModelOverview m = new GraphModelOverview(modelID);
            Vector<GraphEntity> v = new Vector<GraphEntity>();
            Vector<GraphFabric> vfabricV = new Vector<GraphFabric>();
            Enumeration enu = this.model.enumerate(GraphFabric.TYPE);
            while (enu.hasMoreElements()) {
                GraphFabric fabric = (GraphFabric)enu.nextElement();
                v.add(fabric);
                if (fabric.getIsPhysical().booleanValue()) continue;
                vfabricV.add(fabric);
            }
            GraphFabricSummary fabricSummary = new GraphFabricSummary("FabricSummary");
            fabricSummary.setDisplayName("Fabrics");
            fabricSummary.setNumOfFabrics(new Integer(v.size()));
            fabricSummary.setNumOfAbnormalFabrics(new Integer(this.getAbnormalSize(v)));
            fabricSummary.setNumOfVirtualFabrics(new Integer(vfabricV.size()));
            fabricSummary.setNumOfAbnormalVirtualFabrics(new Integer(this.getAbnormalSize(vfabricV)));
            fabricSummary.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(v));
            m.put(fabricSummary);
            v = new Vector();
            Enumeration enu2 = this.model.enumerate(GraphComputer.TYPE);
            while (enu2.hasMoreElements()) {
                computer = (GraphComputer)enu2.nextElement();
                v.add(computer);
            }
            GraphComputerSummary computerSummary = new GraphComputerSummary("ComputerSummary");
            computerSummary.setDisplayName("Computers");
            computerSummary.setNumOfComputers(new Integer(v.size()));
            computerSummary.setNumOfAbnormalComputers(new Integer(this.getAbnormalSize(v)));
            computerSummary.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(v));
            m.put(computerSummary);
            v = new Vector();
            enu2 = this.model.enumerate(GraphSwitch.TYPE);
            while (enu2.hasMoreElements()) {
                computer = (GraphSwitch)enu2.nextElement();
                v.add(computer);
            }
            GraphSwitchSummary swSummary = new GraphSwitchSummary("SwitchSummary");
            swSummary.setDisplayName("Switches");
            swSummary.setNumOfSwitches(new Integer(v.size()));
            swSummary.setNumOfAbnormalSwitches(new Integer(this.getAbnormalSize(v)));
            swSummary.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(v));
            m.put(swSummary);
            v = new Vector();
            enu2 = this.model.enumerate(GraphSubsystem.TYPE);
            while (enu2.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)enu2.nextElement();
                v.add(subsystem);
            }
            Vector<GraphTapeLibrary> v2 = new Vector<GraphTapeLibrary>();
            enu2 = this.model.enumerate(GraphTapeLibrary.TYPE);
            while (enu2.hasMoreElements()) {
                GraphTapeLibrary tape = (GraphTapeLibrary)enu2.nextElement();
                v2.add(tape);
            }
            GraphStorageSummary storageSummary = new GraphStorageSummary("StorageSummary");
            storageSummary.setDisplayName("Storage");
            storageSummary.setNumOfSubsystems(new Integer(v.size()));
            storageSummary.setNumOfAbnormalSubsystems(new Integer(this.getAbnormalSize(v)));
            storageSummary.setNumOfTapeLibraries(new Integer(v2.size()));
            storageSummary.setNumOfAbnormalTapeLibraries(new Integer(this.getAbnormalSize(v2)));
            storageSummary.setHealthStatus(GraphModelUtilities.aggregateStatus(GraphModelUtilities.aggregateHealthStatus(v), GraphModelUtilities.aggregateHealthStatus(v2)));
            m.put(storageSummary);
            v = new Vector();
            enu2 = this.model.enumerate(GraphOther.TYPE);
            while (enu2.hasMoreElements()) {
                GraphOther other = (GraphOther)enu2.nextElement();
                v.add(other);
            }
            GraphOtherSummary otherSummary = new GraphOtherSummary("Others");
            otherSummary.setDisplayName("Other");
            otherSummary.setNumOfOthers(new Integer(v.size()));
            otherSummary.setNumOfAbnormalOthers(new Integer(this.getAbnormalSize(v)));
            otherSummary.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(v));
            m.put(otherSummary);
            return m;
        }

        private GraphModelFabricL0 generateFabricL0(GraphModelFabricL0.ID modelID) {
            GraphModelFabricL0 m = new GraphModelFabricL0(modelID);
            Enumeration enu = this.model.enumerate(GraphFabric.TYPE);
            while (enu.hasMoreElements()) {
                GraphFabric fabric = (GraphFabric)enu.nextElement();
                fabric = (GraphFabric)fabric.clone();
                m.put(fabric);
            }
            enu = this.model.enumerate(GraphFabric2VirtualFabric.TYPE);
            while (enu.hasMoreElements()) {
                GraphFabric2VirtualFabric fabric2vfabric = (GraphFabric2VirtualFabric)enu.nextElement();
                fabric2vfabric = (GraphFabric2VirtualFabric)fabric2vfabric.clone();
                m.put(fabric2vfabric);
            }
            return m;
        }

        private GraphModelFabricL2 generateFabricL2(GraphModelFabricL2.ID modelID) {
            GraphAssociation u;
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelFabricL2 m = new GraphModelFabricL2(modelID);
            m.setWithZoneData(needZoneData);
            GraphFabric fabric = (GraphFabric)this.model.get(focusEntityID);
            if (fabric == null) {
                return m;
            }
            fabric = (GraphFabric)fabric.clone();
            m.put(fabric);
            if (needZoneData) {
                GraphFabric.ID fabricID = (GraphFabric.ID)fabric.getEntityID();
                this.addZones_L1Fabric(this.model, m, fabricID);
            }
            HashSet<GraphSwitch.ID> swHS = new HashSet<GraphSwitch.ID>();
            Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, focusEntityID);
            while (fabric2swEnu.hasMoreElements()) {
                GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                m.put(fabric2sw);
            }
            Enumeration enu = this.model.associator(GraphFabric2Switch.TYPE, focusEntityID);
            while (enu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)enu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                swHS.add(swID);
            }
            HashSet<GraphComputer.ID> computerHS = new HashSet<GraphComputer.ID>();
            enu = this.model.associator(GraphFabric2Computer.TYPE, focusEntityID);
            while (enu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)enu.nextElement();
                computer = (GraphComputer)computer.clone();
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                m.put(computer);
                computerHS.add(computerID);
            }
            HashSet<GraphSubsystem.ID> subsystemHS = new HashSet<GraphSubsystem.ID>();
            Enumeration enu2 = this.model.associator(GraphFabric2Subsystem.TYPE, focusEntityID);
            while (enu2.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)enu2.nextElement();
                subsystem = (GraphSubsystem)subsystem.clone();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                m.put(subsystem);
                subsystemHS.add(subsystemID);
            }
            HashSet<GraphTapeLibrary.ID> tapeHS = new HashSet<GraphTapeLibrary.ID>();
            Enumeration enu3 = this.model.associator(GraphFabric2TapeLibrary.TYPE, focusEntityID);
            while (enu3.hasMoreElements()) {
                GraphTapeLibrary tape = (GraphTapeLibrary)enu3.nextElement();
                tape = (GraphTapeLibrary)tape.clone();
                GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
                m.put(tape);
                tapeHS.add(tapeID);
            }
            HashSet<GraphOther.ID> otherHS = new HashSet<GraphOther.ID>();
            Enumeration enu4 = this.model.associator(GraphFabric2Other.TYPE, focusEntityID);
            while (enu4.hasMoreElements()) {
                GraphOther other = (GraphOther)enu4.nextElement();
                other = (GraphOther)other.clone();
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                m.put(other);
                otherHS.add(otherID);
            }
            enu4 = this.model.enumerate(GraphSwitch2Switch.TYPE);
            while (enu4.hasMoreElements()) {
                u = (GraphSwitch2Switch)enu4.nextElement();
                if (!swHS.contains(((GraphSwitch2Switch)(u = (GraphSwitch2Switch)((GraphSwitch2Switch)u).clone())).getSwitch1ID()) || !swHS.contains(((GraphSwitch2Switch)u).getSwitch2ID())) continue;
                m.put(u);
            }
            enu4 = this.model.enumerate(GraphSwitch2Computer.TYPE);
            while (enu4.hasMoreElements()) {
                u = (GraphSwitch2Computer)enu4.nextElement();
                if (!swHS.contains(((GraphSwitch2Computer)(u = (GraphSwitch2Computer)((GraphSwitch2Computer)u).clone())).getSwitchID()) || !computerHS.contains(((GraphSwitch2Computer)u).getComputerID())) continue;
                m.put(u);
            }
            enu4 = this.model.enumerate(GraphSwitch2Subsystem.TYPE);
            while (enu4.hasMoreElements()) {
                u = (GraphSwitch2Subsystem)enu4.nextElement();
                if (!swHS.contains(((GraphSwitch2Subsystem)(u = (GraphSwitch2Subsystem)((GraphSwitch2Subsystem)u).clone())).getSwitchID()) || !subsystemHS.contains(((GraphSwitch2Subsystem)u).getSubsystemID())) continue;
                m.put(u);
            }
            enu4 = this.model.enumerate(GraphSwitch2TapeLibrary.TYPE);
            while (enu4.hasMoreElements()) {
                u = (GraphSwitch2TapeLibrary)enu4.nextElement();
                if (!swHS.contains(((GraphSwitch2TapeLibrary)(u = (GraphSwitch2TapeLibrary)((GraphSwitch2TapeLibrary)u).clone())).getSwitchID()) || !tapeHS.contains(((GraphSwitch2TapeLibrary)u).getTapeLibraryID())) continue;
                m.put(u);
            }
            enu4 = this.model.enumerate(GraphSwitch2Other.TYPE);
            while (enu4.hasMoreElements()) {
                u = (GraphSwitch2Other)enu4.nextElement();
                if (!swHS.contains(((GraphSwitch2Other)(u = (GraphSwitch2Other)((GraphSwitch2Other)u).clone())).getSwitchID()) || !otherHS.contains(((GraphSwitch2Other)u).getOtherID())) continue;
                m.put(u);
            }
            return m;
        }

        private GraphModelComputerL0 generateComputerL0(GraphModelComputerL0.ID modelID) {
            GraphModelComputerL0 m = new GraphModelComputerL0(modelID);
            Enumeration enu = this.model.enumerate(GraphComputer.TYPE);
            while (enu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)enu.nextElement();
                computer = (GraphComputer)computer.clone();
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                m.put(computer);
            }
            return m;
        }

        private GraphModelComputerL1 generateComputerL1(GraphModelComputerL1.ID multiEntityModelID) {
            GraphEntity.ID focusEntityID = multiEntityModelID.getFocusEntityID();
            boolean needZoneData = multiEntityModelID.isNeedZoneData();
            Vector childFocusEntityIDV = multiEntityModelID.getChildFocusEntityIDs();
            GraphModelComputerL1 m = new GraphModelComputerL1(multiEntityModelID);
            Vector<GraphComputer.ID> validIDV = new Vector<GraphComputer.ID>();
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphComputer.ID computerID = (GraphComputer.ID)childFocusEntityIDV.elementAt(i);
                GraphComputer computer = (GraphComputer)this.model.get(computerID);
                if (computer == null) continue;
                computer = (GraphComputer)computer.clone();
                m.put(computer);
                validIDV.add(computerID);
            }
            if (validIDV.size() == 0) {
                return m;
            }
            if (needZoneData) {
                this.addZones_L1(this.model, m, validIDV);
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphComputer.ID computerID = (GraphComputer.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2computerEnu = this.model.reference(GraphSwitch2Computer.TYPE, computerID);
                while (sw2computerEnu.hasMoreElements()) {
                    GraphSwitch2Computer sw2computer = (GraphSwitch2Computer)sw2computerEnu.nextElement();
                    sw2computer = (GraphSwitch2Computer)sw2computer.clone();
                    m.put(sw2computer);
                }
                Enumeration swEnu = this.model.associator(GraphSwitch2Computer.TYPE, computerID);
                while (swEnu.hasMoreElements()) {
                    GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                    sw = (GraphSwitch)sw.clone();
                    GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                    m.put(sw);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphComputer.ID computerID = (GraphComputer.ID)childFocusEntityIDV.elementAt(i);
                Enumeration computer2volumeEnu = this.model.reference(GraphComputer2Volume.TYPE, computerID);
                while (computer2volumeEnu.hasMoreElements()) {
                    GraphComputer2Volume computer2volume = (GraphComputer2Volume)computer2volumeEnu.nextElement();
                    computer2volume = (GraphComputer2Volume)computer2volume.clone();
                    m.put(computer2volume);
                }
                Enumeration volumeEnu = this.model.associator(GraphComputer2Volume.TYPE, computerID);
                while (volumeEnu.hasMoreElements()) {
                    GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                    volume = (GraphVolume)volume.clone();
                    m.put(volume);
                }
            }
            Enumeration volumeIDEnu = m.enumerateID(GraphVolume.TYPE);
            while (volumeIDEnu.hasMoreElements()) {
                GraphVolume.ID volumeID = (GraphVolume.ID)volumeIDEnu.nextElement();
                Enumeration subsystem2volumeEnu = this.model.reference(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystem2volumeEnu.hasMoreElements()) {
                    GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
                    subsystem2volume = (GraphSubsystem2Volume)subsystem2volume.clone();
                    m.put(subsystem2volume);
                }
                Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystemEnu.hasMoreElements()) {
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                    subsystem = (GraphSubsystem)subsystem.clone();
                    m.put(subsystem);
                }
            }
            m.setWithZoneData(needZoneData);
            return m;
        }

        private GraphModelComputerL2 generateComputerL2(GraphModelComputerL2.ID modelID) {
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelComputerL2 m = new GraphModelComputerL2(modelID);
            m.setWithZoneData(needZoneData);
            GraphComputer computer = (GraphComputer)this.model.get(focusEntityID);
            if (computer == null) {
                return m;
            }
            computer = (GraphComputer)computer.clone();
            m.put(computer);
            if (needZoneData) {
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                this.addZones_L2(this.model, m, computerID);
            }
            Enumeration computer2fcportEnu = this.model.reference(GraphComputer2FCPort.TYPE, focusEntityID);
            while (computer2fcportEnu.hasMoreElements()) {
                GraphComputer2FCPort computer2fcport = (GraphComputer2FCPort)computer2fcportEnu.nextElement();
                computer2fcport = (GraphComputer2FCPort)computer2fcport.clone();
                m.put(computer2fcport);
            }
            Enumeration fcportEnu = this.model.associator(GraphComputer2FCPort.TYPE, focusEntityID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcport = (GraphFCPort)fcport.clone();
                m.put(fcport);
            }
            Enumeration computer2hbaEnu = this.model.reference(GraphComputer2HBA.TYPE, focusEntityID);
            while (computer2hbaEnu.hasMoreElements()) {
                GraphComputer2HBA computer2hba = (GraphComputer2HBA)computer2hbaEnu.nextElement();
                computer2hba = (GraphComputer2HBA)computer2hba.clone();
                m.put(computer2hba);
            }
            Enumeration hbaEnu = this.model.associator(GraphComputer2HBA.TYPE, focusEntityID);
            while (hbaEnu.hasMoreElements()) {
                GraphHBA hba = (GraphHBA)hbaEnu.nextElement();
                GraphHBA.ID hbaID = (GraphHBA.ID)hba.getEntityID();
                hba = (GraphHBA)hba.clone();
                m.put(hba);
                Enumeration hba2fcportEnu = this.model.reference(GraphHBA2FCPort.TYPE, hbaID);
                while (hba2fcportEnu.hasMoreElements()) {
                    GraphHBA2FCPort hba2fcport = (GraphHBA2FCPort)hba2fcportEnu.nextElement();
                    hba2fcport = (GraphHBA2FCPort)hba2fcport.clone();
                    m.put(hba2fcport);
                }
            }
            HashSet<GraphFCPort> fcportHS = new HashSet<GraphFCPort>();
            HashSet<GraphFCPort.ID> fcportIDHS = new HashSet<GraphFCPort.ID>();
            Enumeration computerfcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
            while (computerfcportIDEnu.hasMoreElements()) {
                GraphFCPort.ID computerfcportID = (GraphFCPort.ID)computerfcportIDEnu.nextElement();
                Enumeration fcport2fcportEnu = this.model.reference(GraphFCPort2FCPort.TYPE, computerfcportID);
                while (fcport2fcportEnu.hasMoreElements()) {
                    GraphFCPort2FCPort fcport2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                    fcport2fcport = (GraphFCPort2FCPort)fcport2fcport.clone();
                    m.put(fcport2fcport);
                }
                Enumeration fcportEnu2 = this.model.associator(GraphFCPort2FCPort.TYPE, computerfcportID);
                while (fcportEnu2.hasMoreElements()) {
                    GraphFCPort fcport = (GraphFCPort)fcportEnu2.nextElement();
                    fcport = (GraphFCPort)fcport.clone();
                    fcportHS.add(fcport);
                }
            }
            for (GraphFCPort fcport : fcportHS) {
                m.put(fcport);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcportIDHS.add(fcportID);
            }
            Enumeration swEnu = this.model.associator(GraphSwitch2Computer.TYPE, focusEntityID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                Enumeration sw2fcportEnu = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (sw2fcportEnu.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu.nextElement();
                    GraphFCPort.ID fcportID = (sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(sw2fcport);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            Enumeration computer2lunEnu = this.model.reference(GraphComputer2Lun.TYPE, focusEntityID);
            while (computer2lunEnu.hasMoreElements()) {
                GraphComputer2Lun computer2lun = (GraphComputer2Lun)computer2lunEnu.nextElement();
                computer2lun = (GraphComputer2Lun)computer2lun.clone();
                m.put(computer2lun);
            }
            Enumeration lunEnu = this.model.associator(GraphComputer2Lun.TYPE, focusEntityID);
            while (lunEnu.hasMoreElements()) {
                GraphLun lun = (GraphLun)lunEnu.nextElement();
                lun = (GraphLun)lun.clone();
                m.put(lun);
            }
            Enumeration lunIDEnu = m.enumerateID(GraphLun.TYPE);
            while (lunIDEnu.hasMoreElements()) {
                GraphLun.ID lunID = (GraphLun.ID)lunIDEnu.nextElement();
                Enumeration volume2lunEnu = this.model.reference(GraphVolume2Lun.TYPE, lunID);
                while (volume2lunEnu.hasMoreElements()) {
                    GraphVolume2Lun volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                    volume2lun = (GraphVolume2Lun)volume2lun.clone();
                    m.put(volume2lun);
                }
                Enumeration volumeEnu = this.model.associator(GraphVolume2Lun.TYPE, lunID);
                while (volumeEnu.hasMoreElements()) {
                    GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                    volume = (GraphVolume)volume.clone();
                    m.put(volume);
                }
            }
            Enumeration volumeIDEnu = m.enumerateID(GraphVolume.TYPE);
            while (volumeIDEnu.hasMoreElements()) {
                GraphVolume.ID volumeID = (GraphVolume.ID)volumeIDEnu.nextElement();
                Enumeration subsystem2volumeEnu = this.model.reference(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystem2volumeEnu.hasMoreElements()) {
                    GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
                    subsystem2volume = (GraphSubsystem2Volume)subsystem2volume.clone();
                    m.put(subsystem2volume);
                }
                Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystemEnu.hasMoreElements()) {
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                    subsystem = (GraphSubsystem)subsystem.clone();
                    m.put(subsystem);
                }
            }
            Enumeration logicalVolumeManagerEnu = this.model.associator(GraphComputer2LogicalVolumeManager.TYPE, focusEntityID);
            while (logicalVolumeManagerEnu.hasMoreElements()) {
                GraphLogicalVolumeManager logicalVolumeManager = (GraphLogicalVolumeManager)logicalVolumeManagerEnu.nextElement();
                GraphLogicalVolumeManager.ID logicalVolumeManagerID = (GraphLogicalVolumeManager.ID)logicalVolumeManager.getEntityID();
                logicalVolumeManager = (GraphLogicalVolumeManager)logicalVolumeManager.clone();
                m.put(logicalVolumeManager);
                Enumeration logicalVolumeManager2LunEnu = this.model.reference(GraphLogicalVolumeManager2Lun.TYPE, logicalVolumeManagerID);
                while (logicalVolumeManager2LunEnu.hasMoreElements()) {
                    GraphLogicalVolumeManager2Lun logicalVolumeManager2lun = (GraphLogicalVolumeManager2Lun)logicalVolumeManager2LunEnu.nextElement();
                    logicalVolumeManager2lun = (GraphLogicalVolumeManager2Lun)logicalVolumeManager2lun.clone();
                    m.put(logicalVolumeManager2lun);
                }
                Enumeration logicalVolumeManager2LogicalVolumeEnu = this.model.reference(GraphLogicalVolumeManager2LogicalVolume.TYPE, logicalVolumeManagerID);
                while (logicalVolumeManager2LogicalVolumeEnu.hasMoreElements()) {
                    GraphLogicalVolumeManager2LogicalVolume logicalVolumeManager2LogicalVolume = (GraphLogicalVolumeManager2LogicalVolume)logicalVolumeManager2LogicalVolumeEnu.nextElement();
                    logicalVolumeManager2LogicalVolume = (GraphLogicalVolumeManager2LogicalVolume)logicalVolumeManager2LogicalVolume.clone();
                    m.put(logicalVolumeManager2LogicalVolume);
                }
                Enumeration logicalVolumeEnu = this.model.associator(GraphLogicalVolumeManager2LogicalVolume.TYPE, logicalVolumeManagerID);
                while (logicalVolumeEnu.hasMoreElements()) {
                    GraphLogicalVolume logicalVolume = (GraphLogicalVolume)logicalVolumeEnu.nextElement();
                    GraphLogicalVolume.ID logicalVolumeID = (GraphLogicalVolume.ID)logicalVolume.getEntityID();
                    logicalVolume = (GraphLogicalVolume)logicalVolume.clone();
                    m.put(logicalVolume);
                    Enumeration logicalVolume2lunEnu = this.model.reference(GraphLogicalVolume2Lun.TYPE, logicalVolumeID);
                    while (logicalVolume2lunEnu.hasMoreElements()) {
                        GraphLogicalVolume2Lun logicalVolume2lun = (GraphLogicalVolume2Lun)logicalVolume2lunEnu.nextElement();
                        logicalVolume2lun = (GraphLogicalVolume2Lun)logicalVolume2lun.clone();
                        m.put(logicalVolume2lun);
                    }
                }
            }
            Enumeration filesystemEnu = this.model.associator(GraphComputer2Filesystem.TYPE, focusEntityID);
            while (filesystemEnu.hasMoreElements()) {
                GraphFilesystem filesystem = (GraphFilesystem)filesystemEnu.nextElement();
                GraphFilesystem.ID filesystemID = (GraphFilesystem.ID)filesystem.getEntityID();
                filesystem = (GraphFilesystem)filesystem.clone();
                m.put(filesystem);
                Enumeration filesystem2lunEnu = this.model.reference(GraphFilesystem2Lun.TYPE, filesystemID);
                while (filesystem2lunEnu.hasMoreElements()) {
                    GraphFilesystem2Lun filesystem2lun = (GraphFilesystem2Lun)filesystem2lunEnu.nextElement();
                    filesystem2lun = (GraphFilesystem2Lun)filesystem2lun.clone();
                    m.put(filesystem2lun);
                }
                Enumeration filesystem2logicalVolumeEnu = this.model.reference(GraphFilesystem2LogicalVolume.TYPE, filesystemID);
                while (filesystem2logicalVolumeEnu.hasMoreElements()) {
                    GraphFilesystem2LogicalVolume filesystem2logicalVolume = (GraphFilesystem2LogicalVolume)filesystem2logicalVolumeEnu.nextElement();
                    filesystem2logicalVolume = (GraphFilesystem2LogicalVolume)filesystem2logicalVolume.clone();
                    m.put(filesystem2logicalVolume);
                }
            }
            Enumeration databaseGroupEnu = this.model.associator(GraphComputer2DatabaseGroup.TYPE, focusEntityID);
            while (databaseGroupEnu.hasMoreElements()) {
                GraphDatabaseGroup databaseGroup = (GraphDatabaseGroup)databaseGroupEnu.nextElement();
                GraphDatabaseGroup.ID databaseGroupID = (GraphDatabaseGroup.ID)databaseGroup.getEntityID();
                databaseGroup = (GraphDatabaseGroup)databaseGroup.clone();
                m.put(databaseGroup);
                Enumeration databaseGroup2databaseEnu = this.model.reference(GraphDatabaseGroup2Database.TYPE, databaseGroupID);
                while (databaseGroup2databaseEnu.hasMoreElements()) {
                    GraphDatabaseGroup2Database databaseGroup2database = (GraphDatabaseGroup2Database)databaseGroup2databaseEnu.nextElement();
                    databaseGroup2database = (GraphDatabaseGroup2Database)databaseGroup2database.clone();
                    m.put(databaseGroup2database);
                }
                Enumeration databaseEnu = this.model.associator(GraphDatabaseGroup2Database.TYPE, databaseGroupID);
                while (databaseEnu.hasMoreElements()) {
                    GraphDatabase database = (GraphDatabase)databaseEnu.nextElement();
                    GraphDatabase.ID databaseID = (GraphDatabase.ID)database.getEntityID();
                    database = (GraphDatabase)database.clone();
                    m.put(database);
                    Enumeration database2tableSpaceEnu = this.model.reference(GraphDatabase2TableSpace.TYPE, databaseID);
                    while (database2tableSpaceEnu.hasMoreElements()) {
                        GraphDatabase2TableSpace database2tableSpace = (GraphDatabase2TableSpace)database2tableSpaceEnu.nextElement();
                        database2tableSpace = (GraphDatabase2TableSpace)database2tableSpace.clone();
                        m.put(database2tableSpace);
                    }
                    Enumeration tableSpaceEnu = this.model.associator(GraphDatabase2TableSpace.TYPE, databaseID);
                    while (tableSpaceEnu.hasMoreElements()) {
                        GraphTableSpace tableSpace = (GraphTableSpace)tableSpaceEnu.nextElement();
                        GraphTableSpace.ID tableSpaceID = (GraphTableSpace.ID)tableSpace.getEntityID();
                        tableSpace = (GraphTableSpace)tableSpace.clone();
                        m.put(tableSpace);
                        Enumeration tableSpace2filesystemEnu = this.model.reference(GraphTableSpace2Filesystem.TYPE, tableSpaceID);
                        while (tableSpace2filesystemEnu.hasMoreElements()) {
                            GraphTableSpace2Filesystem tableSpace2filesystem = (GraphTableSpace2Filesystem)tableSpace2filesystemEnu.nextElement();
                            tableSpace2filesystem = (GraphTableSpace2Filesystem)tableSpace2filesystem.clone();
                            m.put(tableSpace2filesystem);
                        }
                        Enumeration tableSpace2logicalVolumeEnu = this.model.reference(GraphTableSpace2LogicalVolume.TYPE, tableSpaceID);
                        while (tableSpace2logicalVolumeEnu.hasMoreElements()) {
                            GraphTableSpace2LogicalVolume tableSpace2logicalVolume = (GraphTableSpace2LogicalVolume)tableSpace2logicalVolumeEnu.nextElement();
                            tableSpace2logicalVolume = (GraphTableSpace2LogicalVolume)tableSpace2logicalVolume.clone();
                            m.put(tableSpace2logicalVolume);
                        }
                        Enumeration tableSpace2lunEnu = this.model.reference(GraphTableSpace2Lun.TYPE, tableSpaceID);
                        while (tableSpace2lunEnu.hasMoreElements()) {
                            GraphTableSpace2Lun tableSpace2lun = (GraphTableSpace2Lun)tableSpace2lunEnu.nextElement();
                            tableSpace2lun = (GraphTableSpace2Lun)tableSpace2lun.clone();
                            m.put(tableSpace2lun);
                        }
                    }
                }
            }
            return m;
        }

        private GraphModelSwitchL0 generateSwitchL0(GraphModelSwitchL0.ID modelID) {
            GraphModelSwitchL0 m = new GraphModelSwitchL0(modelID);
            Enumeration enu = this.model.enumerate(GraphSwitch.TYPE);
            while (enu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)enu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            return m;
        }

        private GraphModelSwitchL1 generateSwitchL1(GraphModelSwitchL1.ID multiEntityModelID) {
            int i;
            int i2;
            GraphEntity.ID focusEntityID = multiEntityModelID.getFocusEntityID();
            boolean needZoneData = multiEntityModelID.isNeedZoneData();
            Vector childFocusEntityIDV = multiEntityModelID.getChildFocusEntityIDs();
            GraphModelSwitchL1 m = new GraphModelSwitchL1(multiEntityModelID);
            Vector<GraphSwitch.ID> validIDV = new Vector<GraphSwitch.ID>();
            for (int i3 = 0; i3 < childFocusEntityIDV.size(); ++i3) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i3);
                GraphSwitch sw = (GraphSwitch)this.model.get(swID);
                if (sw == null) continue;
                sw = (GraphSwitch)sw.clone();
                m.put(sw);
                validIDV.add(swID);
            }
            if (validIDV.size() == 0) {
                return m;
            }
            if (needZoneData) {
                this.addZones_L1(this.model, m, validIDV);
            }
            for (i2 = 0; i2 < childFocusEntityIDV.size(); ++i2) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i2);
                Enumeration sw2computerEnu = this.model.reference(GraphSwitch2Computer.TYPE, swID);
                while (sw2computerEnu.hasMoreElements()) {
                    GraphSwitch2Computer sw2computer = (GraphSwitch2Computer)sw2computerEnu.nextElement();
                    sw2computer = (GraphSwitch2Computer)sw2computer.clone();
                    m.put(sw2computer);
                }
                Enumeration computerEnu = this.model.associator(GraphSwitch2Computer.TYPE, swID);
                while (computerEnu.hasMoreElements()) {
                    GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                    computer = (GraphComputer)computer.clone();
                    GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                    m.put(computer);
                }
            }
            for (i2 = 0; i2 < childFocusEntityIDV.size(); ++i2) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i2);
                Enumeration sw2swEnu = this.model.reference(GraphSwitch2Switch.TYPE, swID);
                while (sw2swEnu.hasMoreElements()) {
                    GraphSwitch2Switch sw2sw = (GraphSwitch2Switch)sw2swEnu.nextElement();
                    sw2sw = (GraphSwitch2Switch)sw2sw.clone();
                    m.put(sw2sw);
                }
                Enumeration swEnu = this.model.associator(GraphSwitch2Switch.TYPE, swID);
                while (swEnu.hasMoreElements()) {
                    GraphSwitch sw2 = (GraphSwitch)swEnu.nextElement();
                    sw2 = (GraphSwitch)sw2.clone();
                    GraphSwitch.ID sw2ID = (GraphSwitch.ID)sw2.getEntityID();
                    m.put(sw2);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            for (i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2subsystemEnu = this.model.reference(GraphSwitch2Subsystem.TYPE, swID);
                while (sw2subsystemEnu.hasMoreElements()) {
                    GraphSwitch2Subsystem sw2subsystem = (GraphSwitch2Subsystem)sw2subsystemEnu.nextElement();
                    sw2subsystem = (GraphSwitch2Subsystem)sw2subsystem.clone();
                    m.put(sw2subsystem);
                }
                Enumeration subsystemEnu = this.model.associator(GraphSwitch2Subsystem.TYPE, swID);
                while (subsystemEnu.hasMoreElements()) {
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                    subsystem = (GraphSubsystem)subsystem.clone();
                    GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                    m.put(subsystem);
                }
            }
            for (i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2tapeEnu = this.model.reference(GraphSwitch2TapeLibrary.TYPE, swID);
                while (sw2tapeEnu.hasMoreElements()) {
                    GraphSwitch2TapeLibrary sw2tape = (GraphSwitch2TapeLibrary)sw2tapeEnu.nextElement();
                    sw2tape = (GraphSwitch2TapeLibrary)sw2tape.clone();
                    m.put(sw2tape);
                }
                Enumeration tapeEnu = this.model.associator(GraphSwitch2TapeLibrary.TYPE, swID);
                while (tapeEnu.hasMoreElements()) {
                    GraphTapeLibrary tape = (GraphTapeLibrary)tapeEnu.nextElement();
                    tape = (GraphTapeLibrary)tape.clone();
                    GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
                    m.put(tape);
                }
            }
            for (i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphSwitch.ID swID = (GraphSwitch.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2otherEnu = this.model.reference(GraphSwitch2Other.TYPE, swID);
                while (sw2otherEnu.hasMoreElements()) {
                    GraphSwitch2Other sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                    sw2other = (GraphSwitch2Other)sw2other.clone();
                    m.put(sw2other);
                }
                Enumeration otherEnu = this.model.associator(GraphSwitch2Other.TYPE, swID);
                while (otherEnu.hasMoreElements()) {
                    GraphOther other = (GraphOther)otherEnu.nextElement();
                    other = (GraphOther)other.clone();
                    GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                    m.put(other);
                }
            }
            m.setWithZoneData(needZoneData);
            return m;
        }

        private GraphModelSwitchL2 generateSwitchL2(GraphModelSwitchL2.ID modelID) {
            GraphFCPort.ID fcportID;
            GraphFCPort.ID fcportID2;
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needPerfData = modelID.isNeedPerfData();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelSwitchL2 m = new GraphModelSwitchL2(modelID);
            m.setWithZoneData(needZoneData);
            GraphSwitch sw = (GraphSwitch)this.model.get(focusEntityID);
            if (sw == null) {
                return m;
            }
            sw = (GraphSwitch)sw.clone();
            m.put(sw);
            if (needZoneData) {
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                this.addZones_L2(this.model, m, swID);
            }
            if (needPerfData) {
                Enumeration sw2swperfEnu = this.model.reference(GraphSwitch2SwitchPerf.TYPE, focusEntityID);
                while (sw2swperfEnu.hasMoreElements()) {
                    GraphSwitch2SwitchPerf sw2swperf = (GraphSwitch2SwitchPerf)sw2swperfEnu.nextElement();
                    sw2swperf = (GraphSwitch2SwitchPerf)sw2swperf.clone();
                    m.put(sw2swperf);
                }
                Enumeration swperfEnu = this.model.associator(GraphSwitch2SwitchPerf.TYPE, focusEntityID);
                while (swperfEnu.hasMoreElements()) {
                    GraphSwitchPerf swperf = (GraphSwitchPerf)swperfEnu.nextElement();
                    swperf = (GraphSwitchPerf)swperf.clone();
                    m.put(swperf);
                }
            }
            Enumeration sw2fcportEnu = this.model.reference(GraphSwitch2FCPort.TYPE, focusEntityID);
            while (sw2fcportEnu.hasMoreElements()) {
                GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu.nextElement();
                sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone();
                m.put(sw2fcport);
            }
            Enumeration fcportEnu = this.model.associator(GraphSwitch2FCPort.TYPE, focusEntityID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport = (GraphFCPort)fcport.clone();
                fcportID2 = (GraphFCPort.ID)fcport.getEntityID();
                m.put(fcport);
            }
            if (needPerfData) {
                Enumeration fcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
                while (fcportIDEnu.hasMoreElements()) {
                    GraphFCPort.ID fcportID3 = (GraphFCPort.ID)fcportIDEnu.nextElement();
                    Enumeration fcport2fcportperfEnu = this.model.reference(GraphFCPort2SwitchFCPortPerf.TYPE, fcportID3);
                    while (fcport2fcportperfEnu.hasMoreElements()) {
                        GraphFCPort2SwitchFCPortPerf fcport2fcportperf = (GraphFCPort2SwitchFCPortPerf)fcport2fcportperfEnu.nextElement();
                        fcport2fcportperf = (GraphFCPort2SwitchFCPortPerf)fcport2fcportperf.clone();
                        m.put(fcport2fcportperf);
                    }
                    Enumeration fcportperfEnu = this.model.associator(GraphFCPort2SwitchFCPortPerf.TYPE, fcportID3);
                    while (fcportperfEnu.hasMoreElements()) {
                        GraphSwitchFCPortPerf fcportperf = (GraphSwitchFCPortPerf)fcportperfEnu.nextElement();
                        fcportperf = (GraphSwitchFCPortPerf)fcportperf.clone();
                        m.put(fcportperf);
                    }
                }
            }
            HashSet<GraphFCPort> fcportHS = new HashSet<GraphFCPort>();
            HashSet<GraphFCPort.ID> fcportIDHS = new HashSet<GraphFCPort.ID>();
            Enumeration fcportEnu2 = m.enumerateID(GraphFCPort.TYPE);
            while (fcportEnu2.hasMoreElements()) {
                fcportID2 = (GraphFCPort.ID)fcportEnu2.nextElement();
                Enumeration fcport2fcportEnu = this.model.reference(GraphFCPort2FCPort.TYPE, fcportID2);
                while (fcport2fcportEnu.hasMoreElements()) {
                    GraphFCPort2FCPort fcport2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                    fcport2fcport = (GraphFCPort2FCPort)fcport2fcport.clone();
                    m.put(fcport2fcport);
                }
                Enumeration targetfcportEnu = this.model.associator(GraphFCPort2FCPort.TYPE, fcportID2);
                while (targetfcportEnu.hasMoreElements()) {
                    GraphFCPort targetfcport = (GraphFCPort)targetfcportEnu.nextElement();
                    targetfcport = (GraphFCPort)targetfcport.clone();
                    fcportHS.add(targetfcport);
                }
            }
            for (GraphFCPort targetfcport : fcportHS) {
                m.put(targetfcport);
                GraphFCPort.ID targetfcportID = (GraphFCPort.ID)targetfcport.getEntityID();
                fcportIDHS.add(targetfcportID);
            }
            Enumeration computerEnu = this.model.associator(GraphSwitch2Computer.TYPE, focusEntityID);
            while (computerEnu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                computer = (GraphComputer)computer.clone();
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                m.put(computer);
                Enumeration computerfcpEnu = this.model.reference(GraphComputer2FCPort.TYPE, computerID);
                while (computerfcpEnu.hasMoreElements()) {
                    GraphComputer2FCPort computer2fcp = (GraphComputer2FCPort)computerfcpEnu.nextElement();
                    fcportID = (computer2fcp = (GraphComputer2FCPort)computer2fcp.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(computer2fcp);
                }
            }
            Enumeration swEnu = this.model.associator(GraphSwitch2Switch.TYPE, focusEntityID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw2 = (GraphSwitch)swEnu.nextElement();
                sw2 = (GraphSwitch)sw2.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw2.getEntityID();
                m.put(sw2);
                Enumeration sw2fcportEnu2 = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (sw2fcportEnu2.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu2.nextElement();
                    fcportID = (sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(sw2fcport);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            Enumeration subsystemEnu = this.model.associator(GraphSwitch2Subsystem.TYPE, focusEntityID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                subsystem = (GraphSubsystem)subsystem.clone();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                m.put(subsystem);
                Enumeration subsystemfcpEnu = this.model.reference(GraphSubsystem2FCPort.TYPE, subsystemID);
                while (subsystemfcpEnu.hasMoreElements()) {
                    GraphSubsystem2FCPort subsystem2fcp = (GraphSubsystem2FCPort)subsystemfcpEnu.nextElement();
                    fcportID = (subsystem2fcp = (GraphSubsystem2FCPort)subsystem2fcp.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(subsystem2fcp);
                }
            }
            Enumeration tapeEnu = this.model.associator(GraphSwitch2TapeLibrary.TYPE, focusEntityID);
            while (tapeEnu.hasMoreElements()) {
                GraphTapeLibrary tape = (GraphTapeLibrary)tapeEnu.nextElement();
                tape = (GraphTapeLibrary)tape.clone();
                GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
                m.put(tape);
                Enumeration tapefcpEnu = this.model.reference(GraphTapeLibrary2FCPort.TYPE, tapeID);
                while (tapefcpEnu.hasMoreElements()) {
                    GraphTapeLibrary2FCPort tape2fcp = (GraphTapeLibrary2FCPort)tapefcpEnu.nextElement();
                    fcportID = (tape2fcp = (GraphTapeLibrary2FCPort)tape2fcp.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(tape2fcp);
                }
            }
            Enumeration otherEnu = this.model.associator(GraphSwitch2Other.TYPE, focusEntityID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                other = (GraphOther)other.clone();
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                m.put(other);
                Enumeration otherfcpEnu = this.model.reference(GraphOther2FCPort.TYPE, otherID);
                while (otherfcpEnu.hasMoreElements()) {
                    GraphOther2FCPort other2fcp = (GraphOther2FCPort)otherfcpEnu.nextElement();
                    fcportID = (other2fcp = (GraphOther2FCPort)other2fcp.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(other2fcp);
                }
            }
            m.setWithPerfData(needPerfData);
            return m;
        }

        private GraphModelStorageL0 generateStorageL0(GraphModelStorageL0.ID modelID) {
            GraphModelStorageL0 m = new GraphModelStorageL0(modelID);
            Enumeration enu = this.model.enumerate(GraphSubsystem.TYPE);
            while (enu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)enu.nextElement();
                subsystem = (GraphSubsystem)subsystem.clone();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                m.put(subsystem);
            }
            enu = this.model.enumerate(GraphTapeLibrary.TYPE);
            while (enu.hasMoreElements()) {
                GraphTapeLibrary tape = (GraphTapeLibrary)enu.nextElement();
                tape = (GraphTapeLibrary)tape.clone();
                GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
                m.put(tape);
            }
            return m;
        }

        private GraphModelSubsystemL1 generateSubsystemL1(GraphModelSubsystemL1.ID multiEntityModelID) {
            boolean needZoneData = multiEntityModelID.isNeedZoneData();
            Vector childFocusEntityIDV = multiEntityModelID.getChildFocusEntityIDs();
            GraphModelSubsystemL1 m = new GraphModelSubsystemL1(multiEntityModelID);
            Vector<GraphSubsystem.ID> validIDV = new Vector<GraphSubsystem.ID>();
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)childFocusEntityIDV.elementAt(i);
                GraphSubsystem subsystem = (GraphSubsystem)this.model.get(subsystemID);
                if (subsystem == null) continue;
                subsystem = (GraphSubsystem)subsystem.clone();
                m.put(subsystem);
                validIDV.add(subsystemID);
            }
            if (validIDV.size() == 0) {
                return m;
            }
            if (needZoneData) {
                this.addZones_L1(this.model, m, validIDV);
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2subsystemEnu = this.model.reference(GraphSwitch2Subsystem.TYPE, subsystemID);
                while (sw2subsystemEnu.hasMoreElements()) {
                    GraphSwitch2Subsystem sw2subsystem = (GraphSwitch2Subsystem)sw2subsystemEnu.nextElement();
                    sw2subsystem = (GraphSwitch2Subsystem)sw2subsystem.clone();
                    m.put(sw2subsystem);
                }
                Enumeration swEnu = this.model.associator(GraphSwitch2Subsystem.TYPE, subsystemID);
                while (swEnu.hasMoreElements()) {
                    GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                    sw = (GraphSwitch)sw.clone();
                    GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                    m.put(sw);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            m.setWithZoneData(needZoneData);
            return m;
        }

        private GraphModelSubsystemL2 generateSubsystemL2(GraphModelSubsystemL2.ID modelID) {
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needPerfData = modelID.isNeedPerfData();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelSubsystemL2 m = new GraphModelSubsystemL2(modelID);
            m.setWithPerfData(needPerfData);
            m.setWithZoneData(needZoneData);
            GraphSubsystem subsystem = (GraphSubsystem)this.model.get(focusEntityID);
            if (subsystem == null) {
                return m;
            }
            subsystem = (GraphSubsystem)subsystem.clone();
            m.put(subsystem);
            if (needZoneData) {
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                this.addZones_L2(this.model, m, subsystemID);
            }
            if (needPerfData) {
                Enumeration subsystem2subsystemperfEnu = this.model.reference(GraphSubsystem2SubsystemPerf.TYPE, focusEntityID);
                while (subsystem2subsystemperfEnu.hasMoreElements()) {
                    GraphSubsystem2SubsystemPerf subsystem2subsystemperf = (GraphSubsystem2SubsystemPerf)subsystem2subsystemperfEnu.nextElement();
                    subsystem2subsystemperf = (GraphSubsystem2SubsystemPerf)subsystem2subsystemperf.clone();
                    m.put(subsystem2subsystemperf);
                }
                Enumeration subsystemperfEnu = this.model.associator(GraphSubsystem2SubsystemPerf.TYPE, focusEntityID);
                while (subsystemperfEnu.hasMoreElements()) {
                    GraphSubsystemPerf subsystemperf = (GraphSubsystemPerf)subsystemperfEnu.nextElement();
                    subsystemperf = (GraphSubsystemPerf)subsystemperf.clone();
                    m.put(subsystemperf);
                }
            }
            Enumeration subsystem2fcportEnu = this.model.reference(GraphSubsystem2FCPort.TYPE, focusEntityID);
            while (subsystem2fcportEnu.hasMoreElements()) {
                GraphSubsystem2FCPort subsystem2fcport = (GraphSubsystem2FCPort)subsystem2fcportEnu.nextElement();
                subsystem2fcport = (GraphSubsystem2FCPort)subsystem2fcport.clone();
                m.put(subsystem2fcport);
            }
            Enumeration fcportEnu = this.model.associator(GraphSubsystem2FCPort.TYPE, focusEntityID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport = (GraphFCPort)fcport.clone();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                m.put(fcport);
            }
            if (needPerfData) {
                Enumeration fcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
                while (fcportIDEnu.hasMoreElements()) {
                    GraphFCPort.ID fcportID = (GraphFCPort.ID)fcportIDEnu.nextElement();
                    Enumeration fcport2fcportperfEnu = this.model.reference(GraphFCPort2SubsystemFCPortPerf.TYPE, fcportID);
                    while (fcport2fcportperfEnu.hasMoreElements()) {
                        GraphFCPort2SubsystemFCPortPerf fcport2fcportperf = (GraphFCPort2SubsystemFCPortPerf)fcport2fcportperfEnu.nextElement();
                        fcport2fcportperf = (GraphFCPort2SubsystemFCPortPerf)fcport2fcportperf.clone();
                        m.put(fcport2fcportperf);
                    }
                    Enumeration fcportperfEnu = this.model.associator(GraphFCPort2SubsystemFCPortPerf.TYPE, fcportID);
                    while (fcportperfEnu.hasMoreElements()) {
                        GraphSubsystemFCPortPerf fcportperf = (GraphSubsystemFCPortPerf)fcportperfEnu.nextElement();
                        fcportperf = (GraphSubsystemFCPortPerf)fcportperf.clone();
                        m.put(fcportperf);
                    }
                }
            }
            HashSet<GraphFCPort> fcportHS = new HashSet<GraphFCPort>();
            HashSet<GraphFCPort.ID> fcportIDHS = new HashSet<GraphFCPort.ID>();
            Enumeration subsystemfcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
            while (subsystemfcportIDEnu.hasMoreElements()) {
                GraphFCPort.ID subsystemfcportID = (GraphFCPort.ID)subsystemfcportIDEnu.nextElement();
                Enumeration fcport2fcportEnu = this.model.reference(GraphFCPort2FCPort.TYPE, subsystemfcportID);
                while (fcport2fcportEnu.hasMoreElements()) {
                    GraphFCPort2FCPort fcport2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                    fcport2fcport = (GraphFCPort2FCPort)fcport2fcport.clone();
                    m.put(fcport2fcport);
                }
                Enumeration fcportEnu2 = this.model.associator(GraphFCPort2FCPort.TYPE, subsystemfcportID);
                while (fcportEnu2.hasMoreElements()) {
                    GraphFCPort fcport = (GraphFCPort)fcportEnu2.nextElement();
                    fcport = (GraphFCPort)fcport.clone();
                    fcportHS.add(fcport);
                }
            }
            for (GraphFCPort fcport : fcportHS) {
                m.put(fcport);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcportIDHS.add(fcportID);
            }
            Enumeration swEnu = this.model.associator(GraphSwitch2Subsystem.TYPE, focusEntityID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                Enumeration sw2fcportEnu = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (sw2fcportEnu.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu.nextElement();
                    GraphFCPort.ID fcportID = (sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(sw2fcport);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            Enumeration diskEnu = this.model.associator(GraphSubsystem2Disk.TYPE, focusEntityID);
            while (diskEnu.hasMoreElements()) {
                GraphDisk disk = (GraphDisk)diskEnu.nextElement();
                disk = (GraphDisk)disk.clone();
                GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
                m.put(disk);
                if (needPerfData) {
                    Enumeration disk2diskperfEnu = this.model.reference(GraphDisk2DiskPerf.TYPE, diskID);
                    while (disk2diskperfEnu.hasMoreElements()) {
                        GraphDisk2DiskPerf disk2diskperf = (GraphDisk2DiskPerf)disk2diskperfEnu.nextElement();
                        disk2diskperf = (GraphDisk2DiskPerf)disk2diskperf.clone();
                        m.put(disk2diskperf);
                    }
                    Enumeration diskperfEnu = this.model.associator(GraphDisk2DiskPerf.TYPE, diskID);
                    while (diskperfEnu.hasMoreElements()) {
                        GraphDiskPerf diskperf = (GraphDiskPerf)diskperfEnu.nextElement();
                        diskperf = (GraphDiskPerf)diskperf.clone();
                        m.put(diskperf);
                    }
                }
                Enumeration volume2diskEnu = this.model.reference(GraphVolume2Disk.TYPE, diskID);
                while (volume2diskEnu.hasMoreElements()) {
                    GraphVolume2Disk volume2disk = (GraphVolume2Disk)volume2diskEnu.nextElement();
                    volume2disk = (GraphVolume2Disk)volume2disk.clone();
                    m.put(volume2disk);
                }
                Enumeration volumeEnu = this.model.associator(GraphVolume2Disk.TYPE, diskID);
                while (volumeEnu.hasMoreElements()) {
                    GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                    GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                    volume = (GraphVolume)volume.clone();
                    m.put(volume);
                    Enumeration subsystem2volumeEnu = this.model.reference(GraphSubsystem2Volume.TYPE, volumeID);
                    while (subsystem2volumeEnu.hasMoreElements()) {
                        GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
                        subsystem2volume = (GraphSubsystem2Volume)subsystem2volume.clone();
                        m.put(subsystem2volume);
                    }
                    Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Volume.TYPE, volumeID);
                    while (subsystemEnu.hasMoreElements()) {
                        GraphSubsystem subsystem2 = (GraphSubsystem)subsystemEnu.nextElement();
                        subsystem2 = (GraphSubsystem)subsystem2.clone();
                        m.put(subsystem2);
                    }
                }
            }
            Enumeration poolEnu = this.model.associator(GraphSubsystem2Pool.TYPE, focusEntityID);
            while (poolEnu.hasMoreElements()) {
                GraphPool pool = (GraphPool)poolEnu.nextElement();
                pool = (GraphPool)pool.clone();
                GraphPool.ID poolID = (GraphPool.ID)pool.getEntityID();
                m.put(pool);
                Enumeration pool2diskEnu = this.model.reference(GraphPool2Disk.TYPE, poolID);
                while (pool2diskEnu.hasMoreElements()) {
                    GraphPool2Disk pool2disk = (GraphPool2Disk)pool2diskEnu.nextElement();
                    pool2disk = (GraphPool2Disk)pool2disk.clone();
                    m.put(pool2disk);
                }
                Enumeration pool2volumeEnu = this.model.reference(GraphPool2Volume.TYPE, poolID);
                while (pool2volumeEnu.hasMoreElements()) {
                    GraphPool2Volume pool2volume = (GraphPool2Volume)pool2volumeEnu.nextElement();
                    pool2volume = (GraphPool2Volume)pool2volume.clone();
                    m.put(pool2volume);
                }
                if (!needPerfData) continue;
                Enumeration pool2poolperfEnu = this.model.reference(GraphPool2PoolPerf.TYPE, poolID);
                while (pool2poolperfEnu.hasMoreElements()) {
                    GraphPool2PoolPerf pool2poolperf = (GraphPool2PoolPerf)pool2poolperfEnu.nextElement();
                    pool2poolperf = (GraphPool2PoolPerf)pool2poolperf.clone();
                    m.put(pool2poolperf);
                }
                Enumeration poolperfEnu = this.model.associator(GraphPool2PoolPerf.TYPE, poolID);
                while (poolperfEnu.hasMoreElements()) {
                    GraphPoolPerf poolperf = (GraphPoolPerf)poolperfEnu.nextElement();
                    poolperf = (GraphPoolPerf)poolperf.clone();
                    m.put(poolperf);
                }
            }
            Enumeration volumeEnu = this.model.associator(GraphSubsystem2Volume.TYPE, focusEntityID);
            while (volumeEnu.hasMoreElements()) {
                GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                volume = (GraphVolume)volume.clone();
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                m.put(volume);
                if (needPerfData) {
                    Enumeration volume2volumeperfEnu = this.model.reference(GraphVolume2VolumePerf.TYPE, volumeID);
                    while (volume2volumeperfEnu.hasMoreElements()) {
                        GraphVolume2VolumePerf volume2volumeperf = (GraphVolume2VolumePerf)volume2volumeperfEnu.nextElement();
                        volume2volumeperf = (GraphVolume2VolumePerf)volume2volumeperf.clone();
                        m.put(volume2volumeperf);
                    }
                    Enumeration volumeperfEnu = this.model.associator(GraphVolume2VolumePerf.TYPE, volumeID);
                    while (volumeperfEnu.hasMoreElements()) {
                        GraphVolumePerf volumeperf = (GraphVolumePerf)volumeperfEnu.nextElement();
                        volumeperf = (GraphVolumePerf)volumeperf.clone();
                        m.put(volumeperf);
                    }
                }
                Enumeration volume2volumeEnu = this.model.reference(GraphVolume2Volume.TYPE, volumeID);
                while (volume2volumeEnu.hasMoreElements()) {
                    GraphVolume2Volume volume2volume = (GraphVolume2Volume)volume2volumeEnu.nextElement();
                    volume2volume = (GraphVolume2Volume)volume2volume.clone();
                    m.put(volume2volume);
                }
                Enumeration volume2diskEnu = this.model.reference(GraphVolume2Disk.TYPE, volumeID);
                while (volume2diskEnu.hasMoreElements()) {
                    GraphVolume2Disk volume2disk = (GraphVolume2Disk)volume2diskEnu.nextElement();
                    volume2disk = (GraphVolume2Disk)volume2disk.clone();
                    m.put(volume2disk);
                }
                Enumeration diskEnu2 = this.model.associator(GraphVolume2Disk.TYPE, volumeID);
                while (diskEnu2.hasMoreElements()) {
                    GraphDisk disk = (GraphDisk)diskEnu2.nextElement();
                    GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
                    disk = (GraphDisk)disk.clone();
                    m.put(disk);
                    Enumeration subsystem2diskEnu = this.model.reference(GraphSubsystem2Disk.TYPE, diskID);
                    while (subsystem2diskEnu.hasMoreElements()) {
                        GraphSubsystem2Disk subsystem2disk = (GraphSubsystem2Disk)subsystem2diskEnu.nextElement();
                        subsystem2disk = (GraphSubsystem2Disk)subsystem2disk.clone();
                        m.put(subsystem2disk);
                    }
                    Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Disk.TYPE, diskID);
                    while (subsystemEnu.hasMoreElements()) {
                        GraphSubsystem subsystem3 = (GraphSubsystem)subsystemEnu.nextElement();
                        subsystem3 = (GraphSubsystem)subsystem3.clone();
                        m.put(subsystem3);
                    }
                }
                Enumeration volume2lunEnu = this.model.reference(GraphVolume2Lun.TYPE, volumeID);
                while (volume2lunEnu.hasMoreElements()) {
                    GraphVolume2Lun volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                    volume2lun = (GraphVolume2Lun)volume2lun.clone();
                    m.put(volume2lun);
                }
                Enumeration lunEnu = this.model.associator(GraphVolume2Lun.TYPE, volumeID);
                while (lunEnu.hasMoreElements()) {
                    GraphLun lun = (GraphLun)lunEnu.nextElement();
                    lun = (GraphLun)lun.clone();
                    GraphLun.ID lunID = (GraphLun.ID)lun.getEntityID();
                    m.put(lun);
                    Enumeration computer2lunEnu = this.model.reference(GraphComputer2Lun.TYPE, lunID);
                    while (computer2lunEnu.hasMoreElements()) {
                        GraphComputer2Lun computer2lun = (GraphComputer2Lun)computer2lunEnu.nextElement();
                        computer2lun = (GraphComputer2Lun)computer2lun.clone();
                        m.put(computer2lun);
                    }
                    Enumeration computerEnu = this.model.associator(GraphComputer2Lun.TYPE, lunID);
                    while (computerEnu.hasMoreElements()) {
                        GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                        computer = (GraphComputer)computer.clone();
                        GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                        m.put(computer);
                    }
                    Enumeration other2lunEnu = this.model.reference(GraphOther2Lun.TYPE, lunID);
                    while (other2lunEnu.hasMoreElements()) {
                        GraphOther2Lun other2lun = (GraphOther2Lun)other2lunEnu.nextElement();
                        other2lun = (GraphOther2Lun)other2lun.clone();
                        m.put(other2lun);
                    }
                    Enumeration otherEnu = this.model.associator(GraphOther2Lun.TYPE, lunID);
                    while (otherEnu.hasMoreElements()) {
                        GraphOther other = (GraphOther)otherEnu.nextElement();
                        other = (GraphOther)other.clone();
                        GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                        m.put(other);
                    }
                }
            }
            return m;
        }

        private GraphModelTapeLibraryL1 generateTapeLibraryL1(GraphModelTapeLibraryL1.ID multiEntityModelID) {
            boolean needZoneData = multiEntityModelID.isNeedZoneData();
            Vector childFocusEntityIDV = multiEntityModelID.getChildFocusEntityIDs();
            GraphModelTapeLibraryL1 m = new GraphModelTapeLibraryL1(multiEntityModelID);
            Vector<GraphTapeLibrary.ID> validIDV = new Vector<GraphTapeLibrary.ID>();
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)childFocusEntityIDV.elementAt(i);
                GraphTapeLibrary tape = (GraphTapeLibrary)this.model.get(tapeID);
                if (tape == null) continue;
                tape = (GraphTapeLibrary)tape.clone();
                m.put(tape);
                validIDV.add(tapeID);
            }
            if (validIDV.size() == 0) {
                return m;
            }
            if (needZoneData) {
                this.addZones_L1(this.model, m, validIDV);
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2tapeEnu = this.model.reference(GraphSwitch2TapeLibrary.TYPE, tapeID);
                while (sw2tapeEnu.hasMoreElements()) {
                    GraphSwitch2TapeLibrary sw2tape = (GraphSwitch2TapeLibrary)sw2tapeEnu.nextElement();
                    sw2tape = (GraphSwitch2TapeLibrary)sw2tape.clone();
                    m.put(sw2tape);
                }
                Enumeration swEnu = this.model.associator(GraphSwitch2TapeLibrary.TYPE, tapeID);
                while (swEnu.hasMoreElements()) {
                    GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                    sw = (GraphSwitch)sw.clone();
                    GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                    m.put(sw);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            m.setWithZoneData(needZoneData);
            return m;
        }

        private GraphModelTapeLibraryL2 generateTapeLibraryL2(GraphModelTapeLibraryL2.ID modelID) {
            GraphFCPort.ID fcportID;
            GraphTapeLibrary2FCPort tapeLibrary2fcport;
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelTapeLibraryL2 m = new GraphModelTapeLibraryL2(modelID);
            m.setWithZoneData(needZoneData);
            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)this.model.get(focusEntityID);
            if (tapeLibrary == null) {
                return m;
            }
            tapeLibrary = (GraphTapeLibrary)tapeLibrary.clone();
            m.put(tapeLibrary);
            if (needZoneData) {
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                this.addZones_L2(this.model, m, tapeLibraryID);
            }
            Enumeration tapeLibrary2fcportEnu = this.model.reference(GraphTapeLibrary2FCPort.TYPE, focusEntityID);
            while (tapeLibrary2fcportEnu.hasMoreElements()) {
                tapeLibrary2fcport = (GraphTapeLibrary2FCPort)tapeLibrary2fcportEnu.nextElement();
                tapeLibrary2fcport = (GraphTapeLibrary2FCPort)tapeLibrary2fcport.clone();
                m.put(tapeLibrary2fcport);
            }
            Enumeration fcportEnu = this.model.associator(GraphTapeLibrary2FCPort.TYPE, focusEntityID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID2 = (GraphFCPort.ID)fcport.getEntityID();
                fcport = (GraphFCPort)fcport.clone();
                m.put(fcport);
            }
            Enumeration tapeLibrary2tapeDriveEnu = this.model.reference(GraphTapeLibrary2TapeDrive.TYPE, focusEntityID);
            while (tapeLibrary2tapeDriveEnu.hasMoreElements()) {
                GraphTapeLibrary2TapeDrive tapeLibrary2tapeDrive = (GraphTapeLibrary2TapeDrive)tapeLibrary2tapeDriveEnu.nextElement();
                tapeLibrary2tapeDrive = (GraphTapeLibrary2TapeDrive)tapeLibrary2tapeDrive.clone();
                m.put(tapeLibrary2tapeDrive);
            }
            Enumeration tapeDriveEnu = this.model.associator(GraphTapeLibrary2TapeDrive.TYPE, focusEntityID);
            while (tapeDriveEnu.hasMoreElements()) {
                GraphTapeDrive tapeDrive = (GraphTapeDrive)tapeDriveEnu.nextElement();
                tapeDrive = (GraphTapeDrive)tapeDrive.clone();
                m.put(tapeDrive);
            }
            Enumeration tapeDriveIDEnu = m.enumerateID(GraphTapeDrive.TYPE);
            while (tapeDriveIDEnu.hasMoreElements()) {
                GraphTapeDrive.ID tapeDriveID = (GraphTapeDrive.ID)tapeDriveIDEnu.nextElement();
                Enumeration tapeDrive2fcportEnu = this.model.reference(GraphTapeDrive2FCPort.TYPE, tapeDriveID);
                while (tapeDrive2fcportEnu.hasMoreElements()) {
                    GraphTapeDrive2FCPort drive2fcport = (GraphTapeDrive2FCPort)tapeDrive2fcportEnu.nextElement();
                    drive2fcport = (GraphTapeDrive2FCPort)drive2fcport.clone();
                    m.put(drive2fcport);
                }
                Enumeration tapeDriveEnu2 = this.model.associator(GraphTapeDrive2FCPort.TYPE, tapeDriveID);
                while (tapeDriveEnu2.hasMoreElements()) {
                    GraphFCPort fcport = (GraphFCPort)tapeDriveEnu2.nextElement();
                    fcport = (GraphFCPort)fcport.clone();
                    fcportID = (GraphFCPort.ID)fcport.getEntityID();
                    m.put(fcport);
                }
            }
            tapeLibrary2fcportEnu = this.model.reference(GraphTapeLibrary2FCPort.TYPE, focusEntityID);
            while (tapeLibrary2fcportEnu.hasMoreElements()) {
                tapeLibrary2fcport = (GraphTapeLibrary2FCPort)tapeLibrary2fcportEnu.nextElement();
                tapeLibrary2fcport = (GraphTapeLibrary2FCPort)tapeLibrary2fcport.clone();
                m.put(tapeLibrary2fcport);
            }
            HashSet<GraphFCPort> fcportHS = new HashSet<GraphFCPort>();
            HashSet<GraphFCPort.ID> fcportIDHS = new HashSet<GraphFCPort.ID>();
            Enumeration tapefcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
            while (tapefcportIDEnu.hasMoreElements()) {
                GraphFCPort.ID tapefcportID = (GraphFCPort.ID)tapefcportIDEnu.nextElement();
                Enumeration fcport2fcportEnu = this.model.reference(GraphFCPort2FCPort.TYPE, tapefcportID);
                while (fcport2fcportEnu.hasMoreElements()) {
                    GraphFCPort2FCPort fcport2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                    fcport2fcport = (GraphFCPort2FCPort)fcport2fcport.clone();
                    m.put(fcport2fcport);
                }
                Enumeration fcportEnu2 = this.model.associator(GraphFCPort2FCPort.TYPE, tapefcportID);
                while (fcportEnu2.hasMoreElements()) {
                    GraphFCPort fcport = (GraphFCPort)fcportEnu2.nextElement();
                    fcport = (GraphFCPort)fcport.clone();
                    fcportHS.add(fcport);
                }
            }
            for (GraphFCPort fcport : fcportHS) {
                m.put(fcport);
                fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcportIDHS.add(fcportID);
            }
            Enumeration swEnu = this.model.associator(GraphSwitch2TapeLibrary.TYPE, focusEntityID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                Enumeration sw2fcportEnu = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (sw2fcportEnu.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu.nextElement();
                    GraphFCPort.ID fcportID3 = (sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID3)) continue;
                    m.put(sw2fcport);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            Enumeration tape2mediaChangerEnu = this.model.reference(GraphTapeLibrary2MediaChanger.TYPE, focusEntityID);
            while (tape2mediaChangerEnu.hasMoreElements()) {
                GraphTapeLibrary2MediaChanger tapeLibrary2mediaChanger = (GraphTapeLibrary2MediaChanger)tape2mediaChangerEnu.nextElement();
                tapeLibrary2mediaChanger = (GraphTapeLibrary2MediaChanger)tapeLibrary2mediaChanger.clone();
                m.put(tapeLibrary2mediaChanger);
            }
            Enumeration mediaChangerEnu = this.model.associator(GraphTapeLibrary2MediaChanger.TYPE, focusEntityID);
            while (mediaChangerEnu.hasMoreElements()) {
                GraphMediaChanger mediaChanger = (GraphMediaChanger)mediaChangerEnu.nextElement();
                mediaChanger = (GraphMediaChanger)mediaChanger.clone();
                m.put(mediaChanger);
            }
            return m;
        }

        private GraphModelOtherL0 generateOtherL0(GraphModelOtherL0.ID modelID) {
            GraphModelOtherL0 m = new GraphModelOtherL0(modelID);
            Enumeration enu = this.model.enumerate(GraphOther.TYPE);
            while (enu.hasMoreElements()) {
                GraphOther other = (GraphOther)enu.nextElement();
                other = (GraphOther)other.clone();
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                m.put(other);
            }
            return m;
        }

        private GraphModelOtherL1 generateOtherL1(GraphModelOtherL1.ID multiEntityModelID) {
            boolean needZoneData = multiEntityModelID.isNeedZoneData();
            Vector childFocusEntityIDV = multiEntityModelID.getChildFocusEntityIDs();
            GraphModelOtherL1 m = new GraphModelOtherL1(multiEntityModelID);
            Vector<GraphOther.ID> validIDV = new Vector<GraphOther.ID>();
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphOther.ID otherID = (GraphOther.ID)childFocusEntityIDV.elementAt(i);
                GraphOther other = (GraphOther)this.model.get(otherID);
                if (other == null) continue;
                other = (GraphOther)other.clone();
                m.put(other);
                validIDV.add(otherID);
            }
            if (validIDV.size() == 0) {
                return m;
            }
            if (needZoneData) {
                this.addZones_L1(this.model, m, validIDV);
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphOther.ID otherID = (GraphOther.ID)childFocusEntityIDV.elementAt(i);
                Enumeration sw2otherEnu = this.model.reference(GraphSwitch2Other.TYPE, otherID);
                while (sw2otherEnu.hasMoreElements()) {
                    GraphSwitch2Other sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                    sw2other = (GraphSwitch2Other)sw2other.clone();
                    m.put(sw2other);
                }
                Enumeration swEnu = this.model.associator(GraphSwitch2Other.TYPE, otherID);
                while (swEnu.hasMoreElements()) {
                    GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                    sw = (GraphSwitch)sw.clone();
                    GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                    m.put(sw);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphOther.ID otherID = (GraphOther.ID)childFocusEntityIDV.elementAt(i);
                Enumeration other2volumeEnu = this.model.reference(GraphOther2Volume.TYPE, otherID);
                while (other2volumeEnu.hasMoreElements()) {
                    GraphOther2Volume other2volume = (GraphOther2Volume)other2volumeEnu.nextElement();
                    other2volume = (GraphOther2Volume)other2volume.clone();
                    m.put(other2volume);
                }
                Enumeration volumeEnu = this.model.associator(GraphOther2Volume.TYPE, otherID);
                while (volumeEnu.hasMoreElements()) {
                    GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                    volume = (GraphVolume)volume.clone();
                    m.put(volume);
                }
            }
            Enumeration volumeIDEnu = m.enumerateID(GraphVolume.TYPE);
            while (volumeIDEnu.hasMoreElements()) {
                GraphVolume.ID volumeID = (GraphVolume.ID)volumeIDEnu.nextElement();
                Enumeration subsystem2volumeEnu = this.model.reference(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystem2volumeEnu.hasMoreElements()) {
                    GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
                    subsystem2volume = (GraphSubsystem2Volume)subsystem2volume.clone();
                    m.put(subsystem2volume);
                }
                Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystemEnu.hasMoreElements()) {
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                    subsystem = (GraphSubsystem)subsystem.clone();
                    m.put(subsystem);
                }
            }
            m.setWithZoneData(needZoneData);
            return m;
        }

        private GraphModelOtherL2 generateOtherL2(GraphModelOtherL2.ID modelID) {
            GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
            boolean needZoneData = modelID.isNeedZoneData();
            GraphModelOtherL2 m = new GraphModelOtherL2(modelID);
            m.setWithZoneData(needZoneData);
            GraphOther other = (GraphOther)this.model.get(focusEntityID);
            if (other == null) {
                return m;
            }
            other = (GraphOther)other.clone();
            m.put(other);
            if (needZoneData) {
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                this.addZones_L2(this.model, m, otherID);
            }
            Enumeration other2fcportEnu = this.model.reference(GraphOther2FCPort.TYPE, focusEntityID);
            while (other2fcportEnu.hasMoreElements()) {
                GraphOther2FCPort other2fcport = (GraphOther2FCPort)other2fcportEnu.nextElement();
                other2fcport = (GraphOther2FCPort)other2fcport.clone();
                m.put(other2fcport);
            }
            Enumeration fcportEnu = this.model.associator(GraphOther2FCPort.TYPE, focusEntityID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport = (GraphFCPort)fcport.clone();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                m.put(fcport);
            }
            HashSet<GraphFCPort> fcportHS = new HashSet<GraphFCPort>();
            HashSet<GraphFCPort.ID> fcportIDHS = new HashSet<GraphFCPort.ID>();
            Enumeration otherfcportIDEnu = m.enumerateID(GraphFCPort.TYPE);
            while (otherfcportIDEnu.hasMoreElements()) {
                GraphFCPort.ID otherfcportID = (GraphFCPort.ID)otherfcportIDEnu.nextElement();
                Enumeration fcport2fcportEnu = this.model.reference(GraphFCPort2FCPort.TYPE, otherfcportID);
                while (fcport2fcportEnu.hasMoreElements()) {
                    GraphFCPort2FCPort fcport2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                    fcport2fcport = (GraphFCPort2FCPort)fcport2fcport.clone();
                    m.put(fcport2fcport);
                }
                Enumeration fcportEnu2 = this.model.associator(GraphFCPort2FCPort.TYPE, otherfcportID);
                while (fcportEnu2.hasMoreElements()) {
                    GraphFCPort fcport = (GraphFCPort)fcportEnu2.nextElement();
                    fcport = (GraphFCPort)fcport.clone();
                    fcportHS.add(fcport);
                }
            }
            for (GraphFCPort fcport : fcportHS) {
                m.put(fcport);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcportIDHS.add(fcportID);
            }
            Enumeration swEnu = this.model.associator(GraphSwitch2Other.TYPE, focusEntityID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                sw = (GraphSwitch)sw.clone();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                m.put(sw);
                Enumeration sw2fcportEnu = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (sw2fcportEnu.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)sw2fcportEnu.nextElement();
                    GraphFCPort.ID fcportID = (sw2fcport = (GraphSwitch2FCPort)sw2fcport.clone()).getFCPortID();
                    if (!fcportIDHS.contains(fcportID)) continue;
                    m.put(sw2fcport);
                }
            }
            Enumeration swIDEnu = m.enumerateID(GraphSwitch.TYPE);
            while (swIDEnu.hasMoreElements()) {
                GraphSwitch.ID swID = (GraphSwitch.ID)swIDEnu.nextElement();
                Enumeration fabric2swEnu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (fabric2swEnu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)fabric2swEnu.nextElement();
                    fabric2sw = (GraphFabric2Switch)fabric2sw.clone();
                    m.put(fabric2sw);
                }
                Enumeration fabricEnu = this.model.associator(GraphFabric2Switch.TYPE, swID);
                while (fabricEnu.hasMoreElements()) {
                    GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                    fabric = (GraphFabric)fabric.clone();
                    m.put(fabric);
                }
            }
            Enumeration other2lunEnu = this.model.reference(GraphOther2Lun.TYPE, focusEntityID);
            while (other2lunEnu.hasMoreElements()) {
                GraphOther2Lun other2lun = (GraphOther2Lun)other2lunEnu.nextElement();
                other2lun = (GraphOther2Lun)other2lun.clone();
                m.put(other2lun);
            }
            Enumeration lunEnu = this.model.associator(GraphOther2Lun.TYPE, focusEntityID);
            while (lunEnu.hasMoreElements()) {
                GraphLun lun = (GraphLun)lunEnu.nextElement();
                lun = (GraphLun)lun.clone();
                m.put(lun);
            }
            Enumeration lunIDEnu = m.enumerateID(GraphLun.TYPE);
            while (lunIDEnu.hasMoreElements()) {
                GraphLun.ID lunID = (GraphLun.ID)lunIDEnu.nextElement();
                Enumeration volume2lunEnu = this.model.reference(GraphVolume2Lun.TYPE, lunID);
                while (volume2lunEnu.hasMoreElements()) {
                    GraphVolume2Lun volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                    volume2lun = (GraphVolume2Lun)volume2lun.clone();
                    m.put(volume2lun);
                }
                Enumeration volumeEnu = this.model.associator(GraphVolume2Lun.TYPE, lunID);
                while (volumeEnu.hasMoreElements()) {
                    GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                    volume = (GraphVolume)volume.clone();
                    m.put(volume);
                }
            }
            Enumeration volumeIDEnu = m.enumerateID(GraphVolume.TYPE);
            while (volumeIDEnu.hasMoreElements()) {
                GraphVolume.ID volumeID = (GraphVolume.ID)volumeIDEnu.nextElement();
                Enumeration subsystem2volumeEnu = this.model.reference(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystem2volumeEnu.hasMoreElements()) {
                    GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
                    subsystem2volume = (GraphSubsystem2Volume)subsystem2volume.clone();
                    m.put(subsystem2volume);
                }
                Enumeration subsystemEnu = this.model.associator(GraphSubsystem2Volume.TYPE, volumeID);
                while (subsystemEnu.hasMoreElements()) {
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                    subsystem = (GraphSubsystem)subsystem.clone();
                    m.put(subsystem);
                }
            }
            return m;
        }

        private void addZones_L2(GraphModel model, GraphModel m, GraphEntity.ID nodeID) {
            GraphZone.ID zoneID;
            Enumeration zmemEnu = model.enumerate(GraphZoneMember.TYPE);
            while (zmemEnu.hasMoreElements()) {
                GraphZoneMember zmem = (GraphZoneMember)zmemEnu.nextElement();
                if (!zmem.getParentID().equals(nodeID)) continue;
                GraphZoneMember.ID zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                Enumeration zoneEnu = model.associator(GraphZone2ZoneMember.TYPE, zmemID);
                while (zoneEnu.hasMoreElements()) {
                    GraphZone zone = (GraphZone)zoneEnu.nextElement();
                    zone = (GraphZone)zone.clone();
                    m.put(zone);
                }
            }
            Enumeration zoneIDEnu = m.enumerateID(GraphZone.TYPE);
            while (zoneIDEnu.hasMoreElements()) {
                zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
                Enumeration zfabric2zoneEnu = model.reference(GraphZoneFabric2Zone.TYPE, zoneID);
                while (zfabric2zoneEnu.hasMoreElements()) {
                    GraphZoneFabric2Zone zfabric2zone = (GraphZoneFabric2Zone)zfabric2zoneEnu.nextElement();
                    zfabric2zone = (GraphZoneFabric2Zone)zfabric2zone.clone();
                    m.put(zfabric2zone);
                    GraphZoneFabric.ID zfabricID = zfabric2zone.getZoneFabricID();
                    GraphZoneFabric zfabric = (GraphZoneFabric)model.get(zfabricID);
                    zfabric = (GraphZoneFabric)zfabric.clone();
                    m.put(zfabric);
                }
                Enumeration zset2zoneEnu = model.reference(GraphZoneSet2Zone.TYPE, zoneID);
                while (zset2zoneEnu.hasMoreElements()) {
                    GraphZoneSet2Zone zset2zone = (GraphZoneSet2Zone)zset2zoneEnu.nextElement();
                    zset2zone = (GraphZoneSet2Zone)zset2zone.clone();
                    m.put(zset2zone);
                    GraphZoneSet.ID zsetID = zset2zone.getZoneSetID();
                    GraphZoneSet zset = (GraphZoneSet)model.get(zsetID);
                    zset = (GraphZoneSet)zset.clone();
                    m.put(zset);
                    Enumeration zfabric2zsetEnu = model.reference(GraphZoneFabric2ZoneSet.TYPE, zsetID);
                    while (zfabric2zsetEnu.hasMoreElements()) {
                        GraphZoneFabric2ZoneSet zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zsetEnu.nextElement();
                        zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zset.clone();
                        m.put(zfabric2zset);
                        GraphZoneFabric.ID zfabricID = zfabric2zset.getZoneFabricID();
                        GraphZoneFabric zfabric = (GraphZoneFabric)model.get(zfabricID);
                        zfabric = (GraphZoneFabric)zfabric.clone();
                        m.put(zfabric);
                    }
                }
            }
            zoneIDEnu = m.enumerateID(GraphZone.TYPE);
            while (zoneIDEnu.hasMoreElements()) {
                zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
                Enumeration zone2zmemEnu = model.reference(GraphZone2ZoneMember.TYPE, zoneID);
                while (zone2zmemEnu.hasMoreElements()) {
                    GraphZone2ZoneMember zone2zmem = (GraphZone2ZoneMember)zone2zmemEnu.nextElement();
                    zone2zmem = (GraphZone2ZoneMember)zone2zmem.clone();
                    m.put(zone2zmem);
                    GraphZoneMember.ID zmemID = zone2zmem.getZoneMemberID();
                    GraphZoneMember zmem = (GraphZoneMember)model.get(zmemID);
                    zmem = (GraphZoneMember)zmem.clone();
                    m.put(zmem);
                }
            }
        }

        private void addZones_L1(GraphModel model, GraphModel m, Vector validIDV) {
            GraphZone.ID zoneID;
            Enumeration zmemEnu = model.enumerate(GraphZoneMember.TYPE);
            while (zmemEnu.hasMoreElements()) {
                GraphZoneMember zmem = (GraphZoneMember)zmemEnu.nextElement();
                GraphEntity.ID nodeID = zmem.getParentID();
                if (!validIDV.contains(nodeID)) continue;
                GraphZoneMember.ID zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                Enumeration zoneEnu = model.associator(GraphZone2ZoneMember.TYPE, zmemID);
                while (zoneEnu.hasMoreElements()) {
                    GraphZone zone = (GraphZone)zoneEnu.nextElement();
                    zone = (GraphZone)zone.clone();
                    m.put(zone);
                }
            }
            Enumeration zoneIDEnu = m.enumerateID(GraphZone.TYPE);
            while (zoneIDEnu.hasMoreElements()) {
                zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
                Enumeration zfabric2zoneEnu = model.reference(GraphZoneFabric2Zone.TYPE, zoneID);
                while (zfabric2zoneEnu.hasMoreElements()) {
                    GraphZoneFabric2Zone zfabric2zone = (GraphZoneFabric2Zone)zfabric2zoneEnu.nextElement();
                    zfabric2zone = (GraphZoneFabric2Zone)zfabric2zone.clone();
                    m.put(zfabric2zone);
                    GraphZoneFabric.ID zfabricID = zfabric2zone.getZoneFabricID();
                    GraphZoneFabric zfabric = (GraphZoneFabric)model.get(zfabricID);
                    zfabric = (GraphZoneFabric)zfabric.clone();
                    m.put(zfabric);
                }
                Enumeration zset2zoneEnu = model.reference(GraphZoneSet2Zone.TYPE, zoneID);
                while (zset2zoneEnu.hasMoreElements()) {
                    GraphZoneSet2Zone zset2zone = (GraphZoneSet2Zone)zset2zoneEnu.nextElement();
                    zset2zone = (GraphZoneSet2Zone)zset2zone.clone();
                    m.put(zset2zone);
                    GraphZoneSet.ID zsetID = zset2zone.getZoneSetID();
                    GraphZoneSet zset = (GraphZoneSet)model.get(zsetID);
                    zset = (GraphZoneSet)zset.clone();
                    m.put(zset);
                    Enumeration zfabric2zsetEnu = model.reference(GraphZoneFabric2ZoneSet.TYPE, zsetID);
                    while (zfabric2zsetEnu.hasMoreElements()) {
                        GraphZoneFabric2ZoneSet zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zsetEnu.nextElement();
                        zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zset.clone();
                        m.put(zfabric2zset);
                        GraphZoneFabric.ID zfabricID = zfabric2zset.getZoneFabricID();
                        GraphZoneFabric zfabric = (GraphZoneFabric)model.get(zfabricID);
                        zfabric = (GraphZoneFabric)zfabric.clone();
                        m.put(zfabric);
                    }
                }
            }
            zoneIDEnu = m.enumerateID(GraphZone.TYPE);
            while (zoneIDEnu.hasMoreElements()) {
                zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
                HashSet<GraphEntity.ID> hs = new HashSet<GraphEntity.ID>();
                zmemEnu = model.associator(GraphZone2ZoneMember.TYPE, zoneID);
                while (zmemEnu.hasMoreElements()) {
                    GraphZoneMember zmem = (GraphZoneMember)zmemEnu.nextElement();
                    GraphEntity.ID parentID = zmem.getParentID();
                    hs.add(parentID);
                }
                for (GraphEntity.ID parentID : hs) {
                    GraphEntity parent = model.get(parentID);
                    String parentLabel = parent.getDisplayName();
                    GraphZoneMember zmem = new GraphZoneMember(parentID.getID().toString());
                    GraphZoneMember.ID zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                    zmem.setParentID(parentID);
                    zmem.setParentLabel(parentLabel);
                    m.put(zmem);
                    GraphZone2ZoneMember zone2zmem = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID.getID());
                    zone2zmem.setZoneID(zoneID);
                    zone2zmem.setZoneMemberID(zmemID);
                    m.put(zone2zmem);
                }
            }
        }

        private void addZones_L1Fabric(GraphModel model, GraphModel m, GraphFabric.ID fabricID) {
            Enumeration zfabricEnu = model.enumerate(GraphZoneFabric.TYPE);
            while (zfabricEnu.hasMoreElements()) {
                GraphZoneFabric zfabric = (GraphZoneFabric)zfabricEnu.nextElement();
                if (!zfabric.getFabricID().equals(fabricID)) continue;
                GraphZoneFabric.ID zfabricID = (GraphZoneFabric.ID)zfabric.getEntityID();
                zfabric = (GraphZoneFabric)zfabric.clone();
                m.put(zfabric);
                Enumeration zfabric2zoneEnu = model.reference(GraphZoneFabric2Zone.TYPE, zfabricID);
                while (zfabric2zoneEnu.hasMoreElements()) {
                    GraphZoneFabric2Zone zfabric2zone = (GraphZoneFabric2Zone)zfabric2zoneEnu.nextElement();
                    zfabric2zone = (GraphZoneFabric2Zone)zfabric2zone.clone();
                    m.put(zfabric2zone);
                    GraphZone.ID zoneID = zfabric2zone.getZoneID();
                    GraphZone zone = (GraphZone)model.get(zoneID);
                    zone = (GraphZone)zone.clone();
                    m.put(zone);
                }
                Enumeration zfabric2zsetEnu = model.reference(GraphZoneFabric2ZoneSet.TYPE, zfabricID);
                while (zfabric2zsetEnu.hasMoreElements()) {
                    GraphZoneFabric2ZoneSet zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zsetEnu.nextElement();
                    zfabric2zset = (GraphZoneFabric2ZoneSet)zfabric2zset.clone();
                    m.put(zfabric2zset);
                    GraphZoneSet.ID zsetID = zfabric2zset.getZoneSetID();
                    GraphZoneSet zset = (GraphZoneSet)model.get(zsetID);
                    zset = (GraphZoneSet)zset.clone();
                    m.put(zset);
                    Enumeration zset2zoneEnu = model.reference(GraphZoneSet2Zone.TYPE, zsetID);
                    while (zset2zoneEnu.hasMoreElements()) {
                        GraphZoneSet2Zone zset2zone = (GraphZoneSet2Zone)zset2zoneEnu.nextElement();
                        zset2zone = (GraphZoneSet2Zone)zset2zone.clone();
                        m.put(zset2zone);
                    }
                }
            }
            Enumeration zoneIDEnu = m.enumerateID(GraphZone.TYPE);
            while (zoneIDEnu.hasMoreElements()) {
                GraphZone.ID zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
                HashSet<GraphEntity.ID> hs = new HashSet<GraphEntity.ID>();
                Enumeration zmemEnu = model.associator(GraphZone2ZoneMember.TYPE, zoneID);
                while (zmemEnu.hasMoreElements()) {
                    GraphZoneMember zmem = (GraphZoneMember)zmemEnu.nextElement();
                    GraphEntity.ID parentID = zmem.getParentID();
                    hs.add(parentID);
                }
                for (GraphEntity.ID parentID : hs) {
                    GraphEntity parent = model.get(parentID);
                    String parentLabel = parent.getDisplayName();
                    GraphZoneMember zmem = new GraphZoneMember(parentID.getID().toString());
                    GraphZoneMember.ID zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                    zmem.setParentID(parentID);
                    zmem.setParentLabel(parentLabel);
                    m.put(zmem);
                    GraphZone2ZoneMember zone2zmem = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID.getID());
                    zone2zmem.setZoneID(zoneID);
                    zone2zmem.setZoneMemberID(zmemID);
                    m.put(zone2zmem);
                }
            }
        }

        private GraphModelPinList generatePinList(GraphModelPinList.ID pinListModelID) {
            GraphModelPinList m = new GraphModelPinList(pinListModelID);
            Vector childFocusEntityIDV = pinListModelID.getChildFocusEntityIDs();
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                GraphOther other;
                GraphFabric fabric;
                Enumeration enu;
                GraphEntity.ID nodeID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
                if (nodeID instanceof GraphComputer.ID) {
                    GraphComputer computer = (GraphComputer)this.model.get(nodeID);
                    if (computer == null) continue;
                    computer = (GraphComputer)computer.clone();
                    m.put(computer);
                    enu = this.model.reference(GraphFabric2Computer.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphFabric2Computer fabric2computer = (GraphFabric2Computer)enu.nextElement();
                        m.put(fabric2computer);
                    }
                    enu = this.model.associator(GraphFabric2Computer.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        fabric = (GraphFabric)enu.nextElement();
                        m.put(fabric);
                    }
                    continue;
                }
                if (nodeID instanceof GraphSwitch.ID) {
                    GraphSwitch sw = (GraphSwitch)this.model.get(nodeID);
                    if (sw == null) continue;
                    sw = (GraphSwitch)sw.clone();
                    m.put(sw);
                    enu = this.model.reference(GraphFabric2Switch.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphFabric2Switch fabric2sw = (GraphFabric2Switch)enu.nextElement();
                        m.put(fabric2sw);
                    }
                    enu = this.model.associator(GraphFabric2Switch.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        fabric = (GraphFabric)enu.nextElement();
                        m.put(fabric);
                    }
                    enu = this.model.reference(GraphSwitch2SwitchPerf.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphSwitch2SwitchPerf sw2swperf = (GraphSwitch2SwitchPerf)enu.nextElement();
                        m.put(sw2swperf);
                    }
                    enu = this.model.associator(GraphSwitch2SwitchPerf.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphSwitchPerf swperf = (GraphSwitchPerf)enu.nextElement();
                        m.put(swperf);
                    }
                    continue;
                }
                if (nodeID instanceof GraphSubsystem.ID) {
                    GraphSubsystem subsystem = (GraphSubsystem)this.model.get(nodeID);
                    if (subsystem == null) continue;
                    subsystem = (GraphSubsystem)subsystem.clone();
                    m.put(subsystem);
                    enu = this.model.reference(GraphFabric2Subsystem.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphFabric2Subsystem fabric2subsystem = (GraphFabric2Subsystem)enu.nextElement();
                        m.put(fabric2subsystem);
                    }
                    enu = this.model.associator(GraphFabric2Subsystem.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        fabric = (GraphFabric)enu.nextElement();
                        m.put(fabric);
                    }
                    continue;
                }
                if (nodeID instanceof GraphTapeLibrary.ID) {
                    GraphTapeLibrary tape = (GraphTapeLibrary)this.model.get(nodeID);
                    if (tape == null) continue;
                    tape = (GraphTapeLibrary)tape.clone();
                    m.put(tape);
                    enu = this.model.reference(GraphFabric2TapeLibrary.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        GraphFabric2TapeLibrary fabric2tape = (GraphFabric2TapeLibrary)enu.nextElement();
                        m.put(fabric2tape);
                    }
                    enu = this.model.associator(GraphFabric2TapeLibrary.TYPE, nodeID);
                    while (enu.hasMoreElements()) {
                        fabric = (GraphFabric)enu.nextElement();
                        m.put(fabric);
                    }
                    continue;
                }
                if (!(nodeID instanceof GraphOther.ID) || (other = (GraphOther)this.model.get(nodeID)) == null) continue;
                other = (GraphOther)other.clone();
                m.put(other);
                enu = this.model.reference(GraphFabric2Other.TYPE, nodeID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Other fabric2other = (GraphFabric2Other)enu.nextElement();
                    m.put(fabric2other);
                }
                enu = this.model.associator(GraphFabric2Other.TYPE, nodeID);
                while (enu.hasMoreElements()) {
                    fabric = (GraphFabric)enu.nextElement();
                    m.put(fabric);
                }
            }
            return m;
        }

        public void simulateDataChange_SubsystemStatus(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                GraphSubsystem.ID subsystemID = new GraphSubsystem.ID(id);
                GraphSubsystem subsystem = (GraphSubsystem)this.model.get(subsystemID);
                subsystem.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            }
        }

        public void simulateDataChange_ComputerStatus(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                GraphComputer.ID computerID = new GraphComputer.ID(id);
                GraphComputer computer = (GraphComputer)this.model.get(computerID);
                computer.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            }
        }

        public void simulateDataChange_InvalidFabric(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                GraphFabric.ID fabricID = new GraphFabric.ID(id);
                this.model.remove(fabricID);
                Enumeration enu = this.model.reference(GraphFabric2Switch.TYPE, fabricID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)enu.nextElement();
                    GraphFabric2Switch.ID fabric2swID = (GraphFabric2Switch.ID)fabric2sw.getEntityID();
                    this.model.remove(fabric2swID);
                    GraphSwitch.ID swID = fabric2sw.getSwitchID();
                    Enumeration enu2 = this.model.referenceID(GraphSwitch2Switch.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2Switch.ID sw2swID = (GraphSwitch2Switch.ID)enu2.nextElement();
                        this.model.remove(sw2swID);
                    }
                    enu2 = this.model.referenceID(GraphSwitch2Computer.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2Computer.ID sw2computerID = (GraphSwitch2Computer.ID)enu2.nextElement();
                        this.model.remove(sw2computerID);
                    }
                    enu2 = this.model.referenceID(GraphSwitch2Subsystem.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2Subsystem.ID sw2subsystemID = (GraphSwitch2Subsystem.ID)enu2.nextElement();
                        this.model.remove(sw2subsystemID);
                    }
                    enu2 = this.model.referenceID(GraphSwitch2TapeLibrary.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2TapeLibrary.ID sw2tapeID = (GraphSwitch2TapeLibrary.ID)enu2.nextElement();
                        this.model.remove(sw2tapeID);
                    }
                    enu2 = this.model.referenceID(GraphSwitch2Other.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2Other.ID sw2otherID = (GraphSwitch2Other.ID)enu2.nextElement();
                        this.model.remove(sw2otherID);
                    }
                    enu2 = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                    while (enu2.hasMoreElements()) {
                        GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)enu2.nextElement();
                        GraphSwitch2FCPort.ID sw2fcportID = (GraphSwitch2FCPort.ID)sw2fcport.getEntityID();
                        this.model.remove(sw2fcportID);
                        GraphFCPort.ID fcportID = sw2fcport.getFCPortID();
                        this.model.remove(fcportID);
                        Enumeration enu3 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                        while (enu3.hasMoreElements()) {
                            GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu3.nextElement();
                            this.model.remove(fcport2fcportID);
                        }
                    }
                }
                enu = this.model.referenceID(GraphFabric2Computer.TYPE, fabricID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Computer.ID fabric2computerID = (GraphFabric2Computer.ID)enu.nextElement();
                    this.model.remove(fabric2computerID);
                }
                enu = this.model.referenceID(GraphFabric2Subsystem.TYPE, fabricID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Subsystem.ID fabric2subsystemID = (GraphFabric2Subsystem.ID)enu.nextElement();
                    this.model.remove(fabric2subsystemID);
                }
                enu = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, fabricID);
                while (enu.hasMoreElements()) {
                    GraphFabric2TapeLibrary.ID fabric2tapeID = (GraphFabric2TapeLibrary.ID)enu.nextElement();
                    this.model.remove(fabric2tapeID);
                }
                enu = this.model.referenceID(GraphFabric2Other.TYPE, fabricID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Other.ID fabric2otherID = (GraphFabric2Other.ID)enu.nextElement();
                    this.model.remove(fabric2otherID);
                }
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidSwitch(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                GraphSwitch.ID sID;
                Enumeration enu2;
                String id = ids[i];
                GraphSwitch.ID swID = new GraphSwitch.ID(id);
                this.model.remove(swID);
                HashSet hs = new HashSet();
                Enumeration enu = this.model.reference(GraphFabric2Switch.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)enu.nextElement();
                    GraphFabric2Switch.ID fabric2swID = (GraphFabric2Switch.ID)fabric2sw.getEntityID();
                    this.model.remove(fabric2swID);
                    GraphFabric.ID fabricID = fabric2sw.getFabricID();
                    Enumeration enu22 = this.model.associatorID(GraphFabric2Switch.TYPE, fabricID);
                    while (enu22.hasMoreElements()) {
                        hs.add(enu22.nextElement());
                    }
                }
                enu = this.model.referenceID(GraphSwitch2Switch.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Switch.ID sw2swID = (GraphSwitch2Switch.ID)enu.nextElement();
                    this.model.remove(sw2swID);
                }
                enu = this.model.reference(GraphSwitch2Computer.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Computer sw2computer = (GraphSwitch2Computer)enu.nextElement();
                    GraphSwitch2Computer.ID sw2computerID = (GraphSwitch2Computer.ID)sw2computer.getEntityID();
                    this.model.remove(sw2computerID);
                    GraphComputer.ID computerID = sw2computer.getComputerID();
                    boolean found = false;
                    enu2 = this.model.associatorID(GraphSwitch2Computer.TYPE, computerID);
                    while (enu2.hasMoreElements()) {
                        sID = (GraphSwitch.ID)enu2.nextElement();
                        if (!hs.contains(sID)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    enu2 = this.model.referenceID(GraphFabric2Computer.TYPE, computerID);
                    while (enu2.hasMoreElements()) {
                        GraphFabric2Computer.ID fabric2computerID = (GraphFabric2Computer.ID)enu2.nextElement();
                        this.model.remove(fabric2computerID);
                    }
                }
                enu = this.model.reference(GraphSwitch2Subsystem.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Subsystem sw2subsystem = (GraphSwitch2Subsystem)enu.nextElement();
                    GraphSwitch2Subsystem.ID sw2subsystemID = (GraphSwitch2Subsystem.ID)sw2subsystem.getEntityID();
                    this.model.remove(sw2subsystemID);
                    GraphSubsystem.ID subsystemID = sw2subsystem.getSubsystemID();
                    boolean found = false;
                    enu2 = this.model.associatorID(GraphSwitch2Subsystem.TYPE, subsystemID);
                    while (enu2.hasMoreElements()) {
                        sID = (GraphSwitch.ID)enu2.nextElement();
                        if (!hs.contains(sID)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    enu2 = this.model.referenceID(GraphFabric2Subsystem.TYPE, subsystemID);
                    while (enu2.hasMoreElements()) {
                        GraphFabric2Subsystem.ID fabric2subsystemID = (GraphFabric2Subsystem.ID)enu2.nextElement();
                        this.model.remove(fabric2subsystemID);
                    }
                }
                enu = this.model.reference(GraphSwitch2TapeLibrary.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2TapeLibrary sw2tape = (GraphSwitch2TapeLibrary)enu.nextElement();
                    GraphSwitch2TapeLibrary.ID sw2tapeID = (GraphSwitch2TapeLibrary.ID)sw2tape.getEntityID();
                    this.model.remove(sw2tapeID);
                    GraphTapeLibrary.ID tapeID = sw2tape.getTapeLibraryID();
                    boolean found = false;
                    enu2 = this.model.associatorID(GraphSwitch2TapeLibrary.TYPE, tapeID);
                    while (enu2.hasMoreElements()) {
                        sID = (GraphSwitch.ID)enu2.nextElement();
                        if (!hs.contains(sID)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    enu2 = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, tapeID);
                    while (enu2.hasMoreElements()) {
                        GraphFabric2TapeLibrary.ID fabric2tapeID = (GraphFabric2TapeLibrary.ID)enu2.nextElement();
                        this.model.remove(fabric2tapeID);
                    }
                }
                enu = this.model.reference(GraphSwitch2Other.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Other sw2other = (GraphSwitch2Other)enu.nextElement();
                    GraphSwitch2Other.ID sw2otherID = (GraphSwitch2Other.ID)sw2other.getEntityID();
                    this.model.remove(sw2otherID);
                    GraphOther.ID otherID = sw2other.getOtherID();
                    boolean found = false;
                    enu2 = this.model.associatorID(GraphSwitch2Other.TYPE, otherID);
                    while (enu2.hasMoreElements()) {
                        sID = (GraphSwitch.ID)enu2.nextElement();
                        if (!hs.contains(sID)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    enu2 = this.model.referenceID(GraphFabric2Other.TYPE, otherID);
                    while (enu2.hasMoreElements()) {
                        GraphFabric2Other.ID fabric2otherID = (GraphFabric2Other.ID)enu2.nextElement();
                        this.model.remove(fabric2otherID);
                    }
                }
                enu = this.model.reference(GraphSwitch2FCPort.TYPE, swID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2FCPort sw2fcport = (GraphSwitch2FCPort)enu.nextElement();
                    GraphSwitch2FCPort.ID sw2fcportID = (GraphSwitch2FCPort.ID)sw2fcport.getEntityID();
                    this.model.remove(sw2fcportID);
                    GraphFCPort.ID fcportID = sw2fcport.getFCPortID();
                    this.model.remove(fcportID);
                    Enumeration enu23 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                    while (enu23.hasMoreElements()) {
                        GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu23.nextElement();
                        this.model.remove(fcport2fcportID);
                    }
                }
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidComputer(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                Enumeration enu2;
                String id = ids[i];
                GraphComputer.ID computerID = new GraphComputer.ID(id);
                this.model.remove(computerID);
                Enumeration enu = this.model.referenceID(GraphFabric2Computer.TYPE, computerID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Computer.ID fabric2computerID = (GraphFabric2Computer.ID)enu.nextElement();
                    this.model.remove(fabric2computerID);
                }
                enu = this.model.referenceID(GraphSwitch2Computer.TYPE, computerID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Computer.ID sw2computerID = (GraphSwitch2Computer.ID)enu.nextElement();
                    this.model.remove(sw2computerID);
                }
                enu = this.model.reference(GraphComputer2FCPort.TYPE, computerID);
                while (enu.hasMoreElements()) {
                    GraphComputer2FCPort computer2fcport = (GraphComputer2FCPort)enu.nextElement();
                    GraphComputer2FCPort.ID computer2fcportID = (GraphComputer2FCPort.ID)computer2fcport.getEntityID();
                    this.model.remove(computer2fcportID);
                    GraphFCPort.ID fcportID = computer2fcport.getFCPortID();
                    this.model.remove(fcportID);
                    enu2 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                    while (enu2.hasMoreElements()) {
                        GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu2.nextElement();
                        this.model.remove(fcport2fcportID);
                    }
                }
                enu = this.model.reference(GraphComputer2HBA.TYPE, computerID);
                while (enu.hasMoreElements()) {
                    GraphComputer2HBA computer2hba = (GraphComputer2HBA)enu.nextElement();
                    GraphComputer2HBA.ID computer2hbaID = (GraphComputer2HBA.ID)computer2hba.getEntityID();
                    this.model.remove(computer2hbaID);
                    GraphHBA.ID hbaID = computer2hba.getHBAID();
                    this.model.remove(hbaID);
                    enu2 = this.model.referenceID(GraphHBA2FCPort.TYPE, hbaID);
                    while (enu2.hasMoreElements()) {
                        GraphHBA2FCPort.ID hba2fcportID = (GraphHBA2FCPort.ID)enu2.nextElement();
                        this.model.remove(hba2fcportID);
                    }
                }
                enu = this.model.reference(GraphComputer2Lun.TYPE, computerID);
                while (enu.hasMoreElements()) {
                    GraphComputer2Lun computer2lun = (GraphComputer2Lun)enu.nextElement();
                    GraphComputer2Lun.ID computer2lunID = (GraphComputer2Lun.ID)computer2lun.getEntityID();
                    this.model.remove(computer2lunID);
                    GraphLun.ID lunID = computer2lun.getLunID();
                    this.model.remove(lunID);
                    enu2 = this.model.referenceID(GraphVolume2Lun.TYPE, lunID);
                    while (enu2.hasMoreElements()) {
                        GraphVolume2Lun.ID volume2lunID = (GraphVolume2Lun.ID)enu2.nextElement();
                        this.model.remove(volume2lunID);
                    }
                }
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidSubsystem(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                Enumeration enu2;
                String id = ids[i];
                GraphSubsystem.ID subsystemID = new GraphSubsystem.ID(id);
                this.model.remove(subsystemID);
                Enumeration enu = this.model.referenceID(GraphFabric2Subsystem.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Subsystem.ID fabric2computerID = (GraphFabric2Subsystem.ID)enu.nextElement();
                    this.model.remove(fabric2computerID);
                }
                enu = this.model.referenceID(GraphSwitch2Subsystem.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Subsystem.ID sw2computerID = (GraphSwitch2Subsystem.ID)enu.nextElement();
                    this.model.remove(sw2computerID);
                }
                enu = this.model.reference(GraphSubsystem2FCPort.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphSubsystem2FCPort computer2fcport = (GraphSubsystem2FCPort)enu.nextElement();
                    GraphSubsystem2FCPort.ID computer2fcportID = (GraphSubsystem2FCPort.ID)computer2fcport.getEntityID();
                    this.model.remove(computer2fcportID);
                    GraphFCPort.ID fcportID = computer2fcport.getFCPortID();
                    this.model.remove(fcportID);
                    enu2 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                    while (enu2.hasMoreElements()) {
                        GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu2.nextElement();
                        this.model.remove(fcport2fcportID);
                    }
                }
                enu = this.model.reference(GraphSubsystem2Disk.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphSubsystem2Disk computer2disk = (GraphSubsystem2Disk)enu.nextElement();
                    GraphSubsystem2Disk.ID computer2diskID = (GraphSubsystem2Disk.ID)computer2disk.getEntityID();
                    this.model.remove(computer2diskID);
                    GraphDisk.ID diskID = computer2disk.getDiskID();
                    this.model.remove(diskID);
                }
                enu = this.model.reference(GraphSubsystem2Pool.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphSubsystem2Pool computer2pool = (GraphSubsystem2Pool)enu.nextElement();
                    GraphSubsystem2Pool.ID computer2poolID = (GraphSubsystem2Pool.ID)computer2pool.getEntityID();
                    this.model.remove(computer2poolID);
                    GraphPool.ID poolID = computer2pool.getPoolID();
                    this.model.remove(poolID);
                    enu2 = this.model.referenceID(GraphPool2Disk.TYPE, poolID);
                    while (enu2.hasMoreElements()) {
                        GraphPool2Disk.ID pool2diskID = (GraphPool2Disk.ID)enu2.nextElement();
                        this.model.remove(pool2diskID);
                    }
                    enu2 = this.model.referenceID(GraphPool2Volume.TYPE, poolID);
                    while (enu2.hasMoreElements()) {
                        GraphPool2Volume.ID pool2volumeID = (GraphPool2Volume.ID)enu2.nextElement();
                        this.model.remove(pool2volumeID);
                    }
                }
                enu = this.model.reference(GraphSubsystem2Volume.TYPE, subsystemID);
                while (enu.hasMoreElements()) {
                    GraphSubsystem2Volume computer2volume = (GraphSubsystem2Volume)enu.nextElement();
                    GraphSubsystem2Volume.ID computer2volumeID = (GraphSubsystem2Volume.ID)computer2volume.getEntityID();
                    this.model.remove(computer2volumeID);
                    GraphVolume.ID volumeID = computer2volume.getVolumeID();
                    this.model.remove(volumeID);
                    enu2 = this.model.referenceID(GraphVolume2Lun.TYPE, volumeID);
                    while (enu2.hasMoreElements()) {
                        GraphVolume2Lun.ID volume2lunID = (GraphVolume2Lun.ID)enu2.nextElement();
                        this.model.remove(volume2lunID);
                    }
                }
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidTapeLibrary(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                Enumeration enu2;
                String id = ids[i];
                GraphTapeLibrary.ID tapeLibraryID = new GraphTapeLibrary.ID(id);
                this.model.remove(tapeLibraryID);
                Enumeration enu = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, tapeLibraryID);
                while (enu.hasMoreElements()) {
                    GraphFabric2TapeLibrary.ID fabric2tapeID = (GraphFabric2TapeLibrary.ID)enu.nextElement();
                    this.model.remove(fabric2tapeID);
                }
                enu = this.model.referenceID(GraphSwitch2TapeLibrary.TYPE, tapeLibraryID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2TapeLibrary.ID sw2tapeID = (GraphSwitch2TapeLibrary.ID)enu.nextElement();
                    this.model.remove(sw2tapeID);
                }
                enu = this.model.reference(GraphTapeLibrary2FCPort.TYPE, tapeLibraryID);
                while (enu.hasMoreElements()) {
                    GraphTapeLibrary2FCPort tape2fcport = (GraphTapeLibrary2FCPort)enu.nextElement();
                    GraphTapeLibrary2FCPort.ID tape2fcportID = (GraphTapeLibrary2FCPort.ID)tape2fcport.getEntityID();
                    this.model.remove(tape2fcportID);
                    GraphFCPort.ID fcportID = tape2fcport.getFCPortID();
                    this.model.remove(fcportID);
                    enu2 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                    while (enu2.hasMoreElements()) {
                        GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu2.nextElement();
                        this.model.remove(fcport2fcportID);
                    }
                }
                enu = this.model.reference(GraphTapeLibrary2TapeDrive.TYPE, tapeLibraryID);
                while (enu.hasMoreElements()) {
                    GraphTapeLibrary2TapeDrive tapeLibrary2tapeDrive = (GraphTapeLibrary2TapeDrive)enu.nextElement();
                    GraphTapeLibrary2TapeDrive.ID tapeLibrary2tapeDriveID = (GraphTapeLibrary2TapeDrive.ID)tapeLibrary2tapeDrive.getEntityID();
                    this.model.remove(tapeLibrary2tapeDriveID);
                    GraphTapeDrive.ID tapeDriveID = tapeLibrary2tapeDrive.getTapeDriveID();
                    this.model.remove(tapeDriveID);
                    enu2 = this.model.referenceID(GraphTapeDrive2FCPort.TYPE, tapeDriveID);
                    while (enu2.hasMoreElements()) {
                        GraphTapeDrive2FCPort.ID drive2fcportID = (GraphTapeDrive2FCPort.ID)enu2.nextElement();
                        this.model.remove(drive2fcportID);
                    }
                }
                enu = this.model.reference(GraphTapeLibrary2MediaChanger.TYPE, tapeLibraryID);
                while (enu.hasMoreElements()) {
                    GraphTapeLibrary2MediaChanger tapeLibrary2mediaChanger = (GraphTapeLibrary2MediaChanger)enu.nextElement();
                    GraphTapeLibrary2MediaChanger.ID tapeLibrary2mediaChangerID = (GraphTapeLibrary2MediaChanger.ID)tapeLibrary2mediaChanger.getEntityID();
                    this.model.remove(tapeLibrary2mediaChangerID);
                    GraphMediaChanger.ID mediaChangerID = tapeLibrary2mediaChanger.getMediaChangerID();
                    this.model.remove(mediaChangerID);
                }
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidOther(String[] ids) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                GraphOther.ID otherID = new GraphOther.ID(id);
                this.model.remove(otherID);
                Enumeration enu = this.model.referenceID(GraphFabric2Other.TYPE, otherID);
                while (enu.hasMoreElements()) {
                    GraphFabric2Other.ID fabric2otherID = (GraphFabric2Other.ID)enu.nextElement();
                    this.model.remove(fabric2otherID);
                }
                enu = this.model.referenceID(GraphSwitch2Other.TYPE, otherID);
                while (enu.hasMoreElements()) {
                    GraphSwitch2Other.ID sw2otherID = (GraphSwitch2Other.ID)enu.nextElement();
                    this.model.remove(sw2otherID);
                }
                enu = this.model.reference(GraphOther2FCPort.TYPE, otherID);
                while (enu.hasMoreElements()) {
                    GraphOther2FCPort other2fcport = (GraphOther2FCPort)enu.nextElement();
                    GraphOther2FCPort.ID other2fcportID = (GraphOther2FCPort.ID)other2fcport.getEntityID();
                    this.model.remove(other2fcportID);
                    GraphFCPort.ID fcportID = other2fcport.getFCPortID();
                    this.model.remove(fcportID);
                    Enumeration enu2 = this.model.referenceID(GraphFCPort2FCPort.TYPE, fcportID);
                    while (enu2.hasMoreElements()) {
                        GraphFCPort2FCPort.ID fcport2fcportID = (GraphFCPort2FCPort.ID)enu2.nextElement();
                        this.model.remove(fcport2fcportID);
                    }
                }
            }
            this.model.calculateFabricMeta();
        }
    }

    private class BackendMgr
    extends Thread {
        private int id;

        public BackendMgr(int id) {
            this.id = id;
            this.setName("BackendMgr-" + id);
        }

        public void run() {
            while (true) {
                Hashtable req = (Hashtable)SampleTopoDataManager.this.getJob();
                this.requestHandler(req);
            }
        }

        private void requestHandler(Hashtable req) {
            String cmd = (String)req.get("cmd");
            if (cmd.equals("refresh")) {
                GraphModel.ID modelID = (GraphModel.ID)req.get("modelID");
                String focusLevel = modelID.getFocusLevel();
                SampleTopoDataManager.this.controllerApp.startRefreshView(modelID);
                int rtnCode = 0;
                GraphModel m = null;
                if (focusLevel.equals("Overview")) {
                    m = SampleTopoDataManager.this.data.generateOverview((GraphModelOverview.ID)modelID);
                } else if (focusLevel.equals("FabricL0")) {
                    m = SampleTopoDataManager.this.data.generateFabricL0((GraphModelFabricL0.ID)modelID);
                } else if (focusLevel.equals("FabricL2")) {
                    m = SampleTopoDataManager.this.data.generateFabricL2((GraphModelFabricL2.ID)modelID);
                } else if (focusLevel.equals("ComputerL0")) {
                    m = SampleTopoDataManager.this.data.generateComputerL0((GraphModelComputerL0.ID)modelID);
                } else if (focusLevel.equals("ComputerL1")) {
                    m = SampleTopoDataManager.this.data.generateComputerL1((GraphModelComputerL1.ID)modelID);
                } else if (focusLevel.equals("ComputerL2")) {
                    m = SampleTopoDataManager.this.data.generateComputerL2((GraphModelComputerL2.ID)modelID);
                } else if (focusLevel.equals("SwitchL0")) {
                    m = SampleTopoDataManager.this.data.generateSwitchL0((GraphModelSwitchL0.ID)modelID);
                } else if (focusLevel.equals("SwitchL1")) {
                    m = SampleTopoDataManager.this.data.generateSwitchL1((GraphModelSwitchL1.ID)modelID);
                } else if (focusLevel.equals("SwitchL2")) {
                    m = SampleTopoDataManager.this.data.generateSwitchL2((GraphModelSwitchL2.ID)modelID);
                } else if (focusLevel.equals("StorageL0")) {
                    m = SampleTopoDataManager.this.data.generateStorageL0((GraphModelStorageL0.ID)modelID);
                } else if (focusLevel.equals("SubsystemL1")) {
                    m = SampleTopoDataManager.this.data.generateSubsystemL1((GraphModelSubsystemL1.ID)modelID);
                } else if (focusLevel.equals("SubsystemL2")) {
                    m = SampleTopoDataManager.this.data.generateSubsystemL2((GraphModelSubsystemL2.ID)modelID);
                } else if (focusLevel.equals("TapeLibraryL1")) {
                    m = SampleTopoDataManager.this.data.generateTapeLibraryL1((GraphModelTapeLibraryL1.ID)modelID);
                } else if (focusLevel.equals("TapeLibraryL2")) {
                    m = SampleTopoDataManager.this.data.generateTapeLibraryL2((GraphModelTapeLibraryL2.ID)modelID);
                } else if (focusLevel.equals("OtherL0")) {
                    m = SampleTopoDataManager.this.data.generateOtherL0((GraphModelOtherL0.ID)modelID);
                } else if (focusLevel.equals("OtherL1")) {
                    m = SampleTopoDataManager.this.data.generateOtherL1((GraphModelOtherL1.ID)modelID);
                } else if (focusLevel.equals("OtherL2")) {
                    m = SampleTopoDataManager.this.data.generateOtherL2((GraphModelOtherL2.ID)modelID);
                } else if (focusLevel.equals("PinList")) {
                    m = SampleTopoDataManager.this.data.generatePinList((GraphModelPinList.ID)modelID);
                } else {
                    GraphDebug.error("Warning: SampleTopoDataManager, requestHandler(), invalid modelID=" + modelID);
                }
                SampleTopoDataManager.this.controllerApp.updateView(rtnCode, m);
                SampleTopoDataManager.this.controllerApp.finishRefreshView(modelID);
            } else {
                GraphDebug.error("SampleDataManager, requestHandler, cmd is invalid, cmd=" + cmd);
            }
        }
    }
}

