/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPin;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPinContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummary;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoBox
extends AbstractJTopoGroup
implements ITopoPinContainerWidget {
    protected JLabel labelMinusPlus;
    protected TitlePanel titlePanel;
    protected SummaryPanel summaryPanel;
    protected PinPanel pinPanel;
    protected ContainerPanel containerPanel;
    protected ML_MinusPlus ml_minusPlus;

    protected AbstractJTopoBox() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoBox(ITopoGroupModel groupModel, boolean isWidgetModelListener) {
        super(groupModel, isWidgetModelListener);
        groupModel = (ITopoGroupModel)this.widgetModel;
        this.labelMinusPlus = new JLabel();
        this.add((Component)this.labelMinusPlus, 0);
        this.ml_minusPlus = new ML_MinusPlus();
        this.labelMinusPlus.addMouseListener(this.ml_minusPlus);
        this.labelMinusPlus.addMouseListener(this.mlDrag);
        this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
        this.titlePanel = new TitlePanel(groupModel);
        this.summaryPanel = new SummaryPanel(groupModel);
        this.pinPanel = new PinPanel(groupModel);
        this.containerPanel = this.createContainerPanel(groupModel);
        this.initState();
    }

    private void initState() {
        this.setExpansible(false);
        this.titlePanel.setLogicalParent(this);
        this.summaryPanel.setLogicalParent(this);
        this.pinPanel.setLogicalParent(this);
        this.containerPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.summaryPanel);
        this.add(this.pinPanel);
        this.add(this.containerPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.summaryPanel.resetState();
        this.pinPanel.resetState();
        this.containerPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        super.setSessionModel(canvas, scope);
        this.titlePanel.setSessionModel(canvas, scope);
        this.summaryPanel.setSessionModel(canvas, scope);
        this.pinPanel.setSessionModel(canvas, scope);
        this.containerPanel.setSessionModel(canvas, scope);
    }

    public void setDataModel(GraphEntity focusEntity) {
        super.setDataModel(focusEntity);
        this.titlePanel.setDataModel(focusEntity);
        this.summaryPanel.setDataModel(focusEntity);
        this.containerPanel.setDataModel(focusEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public SummaryPanel getSummaryPanel() {
        return this.summaryPanel;
    }

    public PinPanel getPinPanel() {
        return this.pinPanel;
    }

    public ContainerPanel getContainerPanel() {
        return this.containerPanel;
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.summaryPanel.modelChanged();
        this.pinPanel.modelChanged();
        this.containerPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.summaryPanel.selectionChanged();
        this.pinPanel.selectionChanged();
        this.containerPanel.selectionChanged();
        this.revalidate();
        this.repaint();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.summaryPanel.highlightChanged();
        this.pinPanel.highlightChanged();
        this.containerPanel.highlightChanged();
    }

    public void pinChanged() {
        this.titlePanel.pinChanged();
        this.summaryPanel.pinChanged();
        this.pinPanel.pinChanged();
        this.containerPanel.pinChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder border = null;
        border = entityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(border);
    }

    public void setExpansible(boolean b) {
        super.setExpansible(b);
        if (this.isExpansible) {
            this.setExpanded(this.isExpanded);
        } else {
            this.labelMinusPlus.setVisible(false);
            this.titlePanel.setIconRecursiveEnabled(false);
            this.titlePanel.setStrCounterEnabled(false);
            this.summaryPanel.setVisible(true);
            this.pinPanel.setVisible(true);
            this.containerPanel.setVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    public void setExpanded(boolean b) {
        super.setExpanded(b);
        if (this.isExpanded) {
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.labelMinusPlus.setVisible(true);
            this.titlePanel.setIconRecursiveEnabled(true);
            this.titlePanel.setStrCounterEnabled(true);
            this.summaryPanel.setVisible(false);
            this.pinPanel.setVisible(false);
            this.containerPanel.setVisible(true);
        } else {
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_PLUS);
            this.labelMinusPlus.setVisible(true);
            this.titlePanel.setIconRecursiveEnabled(true);
            this.titlePanel.setStrCounterEnabled(false);
            this.summaryPanel.setVisible(true);
            this.pinPanel.setVisible(true);
            this.containerPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    protected Point getConnectingPoint() {
        Point p2 = this.titlePanel.getConnectingPoint();
        Point p = new Point(this.getX() + p2.x, this.getY() + p2.y);
        return p;
    }

    public Vector getLogicalChilds() {
        return this.containerPanel.getEntities();
    }

    public boolean isContainLogicalChild(AbstractJTopoEntity entity) {
        return this.containerPanel.isContainEntity(entity);
    }

    public void addLogicalChild(AbstractJTopoEntity entity) {
        AbstractJTopoBox oldLogicalParent = (AbstractJTopoBox)entity.getLogicalParent();
        if (oldLogicalParent != null) {
            oldLogicalParent.removeLogicalChild(entity);
        }
        entity.setLogicalParent(this);
        this.containerPanel.addEntity(entity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeLogicalChild(AbstractJTopoEntity entity) {
        if (entity.getLogicalParent() == this) {
            entity.setLogicalParent(null);
        }
        this.containerPanel.removeEntity(entity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeAllLogicalChilds() {
        Vector v = this.containerPanel.getEntities();
        for (int i = 0; i < v.size(); ++i) {
            AbstractJTopoEntity entity = (AbstractJTopoEntity)v.elementAt(i);
            if (entity.getLogicalParent() != this) continue;
            entity.setLogicalParent(null);
        }
        this.containerPanel.removeAllEntities();
        this.setExpansible(false);
    }

    public Vector getPinWidgets() {
        return this.pinPanel.getEntities();
    }

    public AbstractJTopoPin getPinWidget(GraphEntity.ID entityID) {
        AbstractJTopoPin pin = null;
        Vector v = this.pinPanel.getEntities();
        for (int i = 0; i < v.size(); ++i) {
            AbstractJTopoPin widget = (AbstractJTopoPin)v.elementAt(i);
            GraphEntity.ID id = widget.getFocusEntityID();
            if (!id.equals(entityID)) continue;
            pin = widget;
            break;
        }
        return pin;
    }

    public void addPinWidget(AbstractJTopoPin pin) {
        GraphEntity.ID entityID = pin.getFocusEntityID();
        AbstractJTopoPin widget = this.getPinWidget(entityID);
        if (widget == null) {
            this.pinPanel.addEntity(pin);
        }
    }

    public void removePinWidget(AbstractJTopoPin pin) {
        GraphEntity.ID entityID = pin.getFocusEntityID();
        AbstractJTopoPin widget = this.getPinWidget(entityID);
        if (widget != null) {
            this.pinPanel.removeEntity(pin);
        }
    }

    public void updatePinPanel() {
        this.pinPanel.setArrange(null);
        this.pinPanel.updateContainer();
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.titlePanel.setOverlayHealthEnabled(b);
        this.summaryPanel.setOverlayHealthEnabled(b);
        this.pinPanel.setOverlayHealthEnabled(b);
        this.containerPanel.setOverlayHealthEnabled(b);
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.titlePanel.setOverlayPerfEnabled(b);
        this.summaryPanel.setOverlayPerfEnabled(b);
        this.pinPanel.setOverlayPerfEnabled(b);
        this.containerPanel.setOverlayPerfEnabled(b);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        this.titlePanel.setArrange(r);
        this.summaryPanel.setArrange(r);
        this.pinPanel.setArrange(r);
        this.containerPanel.setArrange(r);
    }

    protected void handleMinusPlusMouseClick(MouseEvent e) {
        if (!e.isMetaDown()) {
            if (!this.isExpanded && e.isAltDown()) {
                Hashtable h = this.canvas.getWidgetTable(this);
                Enumeration enu = h.elements();
                while (enu.hasMoreElements()) {
                    AbstractJTopoGroup g = (AbstractJTopoGroup)enu.nextElement();
                    if (g.equals(this) || !g.isExpanded()) continue;
                    g.setExpanded(false);
                    g.revalidate();
                    g.repaint();
                }
            }
            this.setExpanded(!this.isExpanded);
        } else {
            this.handleMouseClick(e);
        }
    }

    protected ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel(groupModel);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        private int spacingForMinusPlus = 10;

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            int w = 0;
            int h = 0;
            Dimension d = AbstractJTopoBox.this.titlePanel.getPreferredSize();
            w += d.width;
            if (AbstractJTopoBox.this.labelMinusPlus.isVisible()) {
                w += this.spacingForMinusPlus;
            }
            h += d.height;
            if (AbstractJTopoBox.this.summaryPanel.isVisible()) {
                d = AbstractJTopoBox.this.summaryPanel.getPreferredSize();
                w = d.width > w ? d.width : w;
                h += d.height;
            }
            if (AbstractJTopoBox.this.pinPanel.isVisible()) {
                d = AbstractJTopoBox.this.pinPanel.getPreferredSize();
                w = d.width > w ? d.width : w;
                h += d.height;
            }
            if (AbstractJTopoBox.this.containerPanel.isVisible()) {
                d = AbstractJTopoBox.this.containerPanel.getPreferredSize();
                w = d.width > w ? d.width : w;
                h += d.height;
            }
            dim.width += w;
            dim.height += h;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int nextX = insets.left;
            int nextY = insets.top;
            Dimension d = AbstractJTopoBox.this.titlePanel.getPreferredSize();
            Rectangle r = new Rectangle();
            r.x = nextX;
            r.y = nextY;
            r.width = parent.getWidth() - insets.left - insets.right;
            r.height = d.height;
            AbstractJTopoBox.this.titlePanel.setBounds(r);
            nextY += AbstractJTopoBox.this.titlePanel.getHeight();
            if (AbstractJTopoBox.this.labelMinusPlus.isVisible()) {
                d = AbstractJTopoBox.this.labelMinusPlus.getPreferredSize();
                r = new Rectangle();
                r.x = parent.getWidth() - insets.right - d.width / 2 - 1;
                r.y = insets.top - d.height / 2;
                r.width = d.width;
                r.height = d.height;
                AbstractJTopoBox.this.labelMinusPlus.setBounds(r);
            } else {
                AbstractJTopoBox.this.labelMinusPlus.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.summaryPanel.isVisible()) {
                d = AbstractJTopoBox.this.summaryPanel.getPreferredSize();
                r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = AbstractJTopoBox.this.titlePanel.getWidth();
                r.height = d.height;
                AbstractJTopoBox.this.summaryPanel.setBounds(r);
                nextY += AbstractJTopoBox.this.summaryPanel.getHeight();
            } else {
                AbstractJTopoBox.this.summaryPanel.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.pinPanel.isVisible()) {
                d = AbstractJTopoBox.this.pinPanel.getPreferredSize();
                r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = AbstractJTopoBox.this.titlePanel.getWidth();
                r.height = d.height;
                AbstractJTopoBox.this.pinPanel.setBounds(r);
                nextY += AbstractJTopoBox.this.pinPanel.getHeight();
            } else {
                AbstractJTopoBox.this.pinPanel.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.containerPanel.isVisible()) {
                d = AbstractJTopoBox.this.containerPanel.getPreferredSize();
                r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = AbstractJTopoBox.this.titlePanel.getWidth();
                r.height = d.height;
                AbstractJTopoBox.this.containerPanel.setBounds(r);
            } else {
                AbstractJTopoBox.this.containerPanel.setBounds(0, 0, 0, 0);
            }
        }
    }

    protected class ContainerPanel
    extends AbstractJTopoContainer {
        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class PinPanel
    extends AbstractJTopoPinContainer {
        public PinPanel(ITopoUnitModel unitModel) {
            super(unitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class SummaryPanel
    extends AbstractJTopoSummary {
        public SummaryPanel(ITopoGroupModel groupModel) {
            super(groupModel, false);
        }

        protected void reattach() {
        }
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel nodeModel) {
            super(nodeModel, false);
        }

        protected void reattach() {
        }
    }

    protected class ML_MinusPlus
    extends MouseAdapter {
        protected ML_MinusPlus() {
        }

        public void mouseClicked(MouseEvent e) {
            e.setSource(new TopoEventSource(e));
            AbstractJTopoBox.this.handleMinusPlusMouseClick(e);
        }
    }
}

