/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoContainerWithTitle
extends AbstractJTopoNode {
    protected TitlePanel titlePanel;
    protected ContainerPanel containerPanel;

    protected AbstractJTopoContainerWithTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoContainerWithTitle(ITopoNodeModel nodeModel, boolean isWidgetModelListener) {
        super(nodeModel, isWidgetModelListener);
        nodeModel = (ITopoNodeModel)this.widgetModel;
        this.titlePanel = new TitlePanel(nodeModel);
        this.containerPanel = this.createContainerPanel(nodeModel);
        this.initState();
    }

    private void initState() {
        this.titlePanel.setLogicalParent(this);
        this.containerPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.containerPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.containerPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        super.setSessionModel(canvas, scope);
        this.titlePanel.setSessionModel(canvas, scope);
        this.containerPanel.setSessionModel(canvas, scope);
    }

    public void setDataModel(GraphEntity focusEntity) {
        super.setDataModel(focusEntity);
        this.titlePanel.setDataModel(focusEntity);
        this.containerPanel.setDataModel(focusEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public ContainerPanel getContainerPanel() {
        return this.containerPanel;
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.containerPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.containerPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.containerPanel.highlightChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder border = null;
        border = entityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(border);
    }

    protected Point getConnectingPoint() {
        Point p2 = this.titlePanel.getConnectingPoint();
        Point p = new Point(this.getX() + p2.x, this.getY() + p2.y);
        return p;
    }

    public Vector getEntities() {
        return this.containerPanel.getEntities();
    }

    public boolean isContainEntity(AbstractJTopoEntity entity) {
        return this.containerPanel.isContainEntity(entity);
    }

    public void addEntity(AbstractJTopoEntity entity) {
        this.containerPanel.addEntity(entity);
    }

    public void removeEntity(AbstractJTopoEntity entity) {
        this.containerPanel.removeEntity(entity);
    }

    public void removeAllEntities() {
        this.containerPanel.removeAllEntities();
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.titlePanel.setOverlayHealthEnabled(b);
        this.containerPanel.setOverlayHealthEnabled(b);
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.titlePanel.setOverlayPerfEnabled(b);
        this.containerPanel.setOverlayPerfEnabled(b);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        this.titlePanel.setArrange(r);
        this.containerPanel.setArrange(r);
    }

    protected ContainerPanel createContainerPanel(ITopoUnitModel unitModel) {
        return new ContainerPanel(unitModel);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            int w = 0;
            int h = 0;
            Dimension d = AbstractJTopoContainerWithTitle.this.titlePanel.getPreferredSize();
            h += d.height;
            d = AbstractJTopoContainerWithTitle.this.containerPanel.getPreferredSize();
            w = d.width > (w += d.width) ? d.width : w;
            dim.width += w;
            dim.height += (h += d.height);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int nextX = insets.left;
            int nextY = insets.top;
            Dimension d = AbstractJTopoContainerWithTitle.this.titlePanel.getPreferredSize();
            Rectangle r = new Rectangle();
            r.x = nextX;
            r.y = nextY;
            r.width = parent.getWidth() - insets.left - insets.right;
            r.height = d.height;
            AbstractJTopoContainerWithTitle.this.titlePanel.setBounds(r);
            d = AbstractJTopoContainerWithTitle.this.containerPanel.getPreferredSize();
            r = new Rectangle();
            r.x = nextX;
            r.y = nextY += AbstractJTopoContainerWithTitle.this.titlePanel.getHeight();
            r.width = AbstractJTopoContainerWithTitle.this.titlePanel.getWidth();
            r.height = d.height;
            AbstractJTopoContainerWithTitle.this.containerPanel.setBounds(r);
        }
    }

    protected class ContainerPanel
    extends AbstractJTopoContainer {
        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel nodeModel) {
            super(nodeModel, false);
        }

        protected void reattach() {
        }
    }
}

