/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoAssociation;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoLine
extends AbstractJTopoAssociation {
    protected static final int DOT_HALF_SIZE = 2;
    protected Color color;
    protected Vector lineV;
    protected Rectangle2D.Float dot1;
    protected Rectangle2D.Float dot2;
    protected boolean firstPassOfLayout;

    protected AbstractJTopoLine() {
        this((ITopoAssociationModel)null, true);
    }

    protected AbstractJTopoLine(ITopoAssociationModel associationModel, boolean isWidgetModelListener) {
        super(associationModel, isWidgetModelListener);
        this.setOpaque(false);
        this.lineV = new Vector();
        this.dot1 = new Rectangle2D.Float();
        this.dot2 = new Rectangle2D.Float();
        this.removeMouseListener(this.mlClick);
        this.removeMouseListener(this.mlDrag);
        this.removeMouseMotionListener(this.mlDrag);
        this.mlClick = null;
        this.mlDrag = null;
        this.initState();
    }

    private void initState() {
        this.color = null;
        this.lineV.clear();
        this.dot1.setRect(0.0f, 0.0f, 0.0f, 0.0f);
        this.dot2.setRect(0.0f, 0.0f, 0.0f, 0.0f);
        this.firstPassOfLayout = false;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setHealth();
    }

    protected void modelChanged_setHealth() {
        ITopoAssociationModel associationModel = (ITopoAssociationModel)this.widgetModel;
        Integer health = associationModel.getHealth();
        this.color = GraphModelConstant.STATUS_UNKNOWN.equals(health) ? TopoResource.COLOR_LINE_UNKNOWN : (GraphModelConstant.STATUS_NORMAL.equals(health) ? TopoResource.COLOR_LINE_NORMAL : (GraphModelConstant.STATUS_WARNING.equals(health) ? TopoResource.COLOR_LINE_WARNING : (GraphModelConstant.STATUS_CRITICAL.equals(health) ? TopoResource.COLOR_LINE_CRITICAL : (GraphModelConstant.STATUS_MISSING.equals(health) ? TopoResource.COLOR_LINE_MISSING : TopoResource.COLOR_LINE_NA))));
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void setOverlayHealthEnabled(boolean b) {
    }

    public void setOverlayPerfEnabled(boolean b) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
    }

    public boolean isFirstPassOfLayout() {
        return this.firstPassOfLayout;
    }

    public void setFirstPassOfLayout(boolean b) {
        this.firstPassOfLayout = b;
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.lineV.size() == 0) {
            return;
        }
        ITopoAssociationModel associationModel = (ITopoAssociationModel)this.widgetModel;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (associationModel.isThick()) {
            g2D.setStroke(new BasicStroke(3.0f));
        } else {
            g2D.setStroke(new BasicStroke(1.0f));
        }
        g2D.setPaint(this.color);
        for (int i = 0; i < this.lineV.size(); ++i) {
            Line2D.Float line = (Line2D.Float)this.lineV.elementAt(i);
            g2D.draw(line);
        }
        if (this.dot1 != null) {
            g2D.fill(this.dot1);
        }
        if (this.dot2 != null) {
            g2D.fill(this.dot2);
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 20;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            if (AbstractJTopoLine.this.firstPassOfLayout) {
                AbstractJTopoLine.this.setBounds(0, 0, 1, 1);
                return;
            }
            try {
                ITopoAssociationModel associationModel = (ITopoAssociationModel)AbstractJTopoLine.this.widgetModel;
                if (associationModel == null) {
                    return;
                }
                AbstractJTopoUnit from = associationModel.getFromWidget().getLastVisibleUnit();
                AbstractJTopoUnit to = associationModel.getToWidget().getLastVisibleUnit();
                AbstractJTopoCanvas.CanvasPanel canvasPanel = AbstractJTopoLine.this.canvas.getCanvasPanel();
                if (from != to) {
                    Point fromP = null;
                    Point toP = null;
                    fromP = from.getConnectingPoint();
                    toP = to.getConnectingPoint();
                    fromP = SwingUtilities.convertPoint(from.getParent(), fromP, canvasPanel);
                    toP = SwingUtilities.convertPoint(to.getParent(), toP, canvasPanel);
                    this.setStraintLine(fromP, toP);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }

        protected void setStraintLine(Point p1, Point p2) {
            try {
                Rectangle r1 = new Rectangle(p1.x - 2, p1.y - 2, 4, 4);
                Rectangle r2 = new Rectangle(p2.x - 2, p2.y - 2, 4, 4);
                Rectangle r = r1.union(r2);
                AbstractJTopoLine.this.setBounds(r);
                AbstractJTopoLine.this.lineV.removeAllElements();
                AbstractJTopoLine.this.lineV.add(new Line2D.Float(p1.x - r.x, p1.y - r.y, p2.x - r.x, p2.y - r.y));
                AbstractJTopoLine.this.dot1.setRect(r1.x - r.x, r1.y - r.y, r1.width, r1.height);
                AbstractJTopoLine.this.dot2.setRect(r2.x - r.x, r2.y - r.y, r2.width, r2.height);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

