/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPosterTab;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBorderTop;
import org.eclipse.aperi.gui.topo.widget.TopoConstant;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoPoster
extends AbstractJTopoBox {
    protected AbstractJTopoPoster() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoPoster(ITopoGroupModel groupModel, boolean isWidgetModelListener) {
        super(groupModel, isWidgetModelListener);
    }

    public Vector getTabs() {
        return this.getLogicalChilds();
    }

    public boolean isContainTab(AbstractJTopoPosterTab tab) {
        return this.isContainLogicalChild(tab);
    }

    public void addTab(AbstractJTopoPosterTab tab) {
        this.addLogicalChild(tab);
    }

    public void removeTab(AbstractJTopoPosterTab tab) {
        this.removeLogicalChild(tab);
    }

    public void removeAllTabs() {
        this.removeAllLogicalChilds();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel indexPanel;
        protected JPanel bodyPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.indexPanel = new IndexPanel();
            this.bodyPanel = new BodyPanel();
            this.initState();
        }

        private void initState() {
            this.indexPanel.removeAll();
            this.bodyPanel.removeAll();
            this.add(this.indexPanel);
            this.add(this.bodyPanel);
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            AbstractJTopoPosterTab tab = (AbstractJTopoPosterTab)entity;
            this.indexPanel.add(tab);
            this.indexPanel.setVisible(true);
            this.bodyPanel.add(tab.getBodyPanel());
            this.bodyPanel.setVisible(true);
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            AbstractJTopoPosterTab tab = (AbstractJTopoPosterTab)entity;
            this.indexPanel.remove(tab);
            this.indexPanel.setVisible(this.indexPanel.getComponentCount() > 0);
            this.bodyPanel.remove(tab.getBodyPanel());
            this.bodyPanel.setVisible(this.bodyPanel.getComponentCount() > 0);
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.indexPanel.removeAll();
            this.indexPanel.setVisible(false);
            this.bodyPanel.removeAll();
            this.bodyPanel.setVisible(false);
        }

        public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
            Integer prop = r.getProp();
            boolean asc = r.isAsc();
            if (TopoConstant.ARRANGE_DISPLAYNAME.equals(prop)) {
                Collections.sort(this.entityV, new AbstractJTopoContainer.Arrange_ByDisplayName(asc));
            } else if (TopoConstant.ARRANGE_STATUS.equals(prop)) {
                Collections.sort(this.entityV, new AbstractJTopoContainer.Arrange_ByStatus(asc));
            } else {
                return;
            }
            this.indexPanel.removeAll();
            this.bodyPanel.removeAll();
            for (int i = 0; i < this.entityV.size(); ++i) {
                AbstractJTopoPosterTab tab = (AbstractJTopoPosterTab)this.entityV.elementAt(i);
                this.indexPanel.add(tab);
                this.bodyPanel.add(tab.getBodyPanel());
            }
            this.indexPanel.setVisible(this.indexPanel.getComponentCount() > 0);
            this.bodyPanel.setVisible(this.bodyPanel.getComponentCount() > 0);
            this.revalidate();
            this.repaint();
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
        }

        protected class BodyPanel
        extends JPanel {
            public BodyPanel() {
                this.setBackground(TopoResource.COLOR_BACKGROUND);
                this.setBorder(new JTopoBorderTop(2, 5));
                this.setLayout(this.createDefaultLayout());
            }

            protected LayoutManager createDefaultLayout() {
                return new DefaultLayout();
            }

            protected class DefaultLayout
            extends TopoLayoutUtilities.VerticalLayout {
            }
        }

        protected class IndexPanel
        extends JPanel {
            public IndexPanel() {
                this.setBackground(TopoResource.COLOR_BACKGROUND);
                this.setLayout(this.createDefaultLayout());
            }

            protected LayoutManager createDefaultLayout() {
                return new DefaultLayout();
            }

            protected class DefaultLayout
            extends TopoLayoutUtilities.VerticalGridLayout {
                public DefaultLayout() {
                    super(8);
                }
            }
        }
    }
}

