/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.JTopoTableComputer;
import org.eclipse.aperi.gui.topo.widget.JTopoTableOther;
import org.eclipse.aperi.gui.topo.widget.JTopoTableSubsystem;
import org.eclipse.aperi.gui.topo.widget.JTopoTableSwitch;
import org.eclipse.aperi.gui.topo.widget.JTopoTableTapeLibrary;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoTable
extends AbstractJTopoBase {
    protected AbstractJTopoTabular tabular;
    protected GraphModel dataModel;
    protected JCustomRendererTable table;
    protected DefaultTopoTableColumnModel tableColumnModel;
    protected DefaultTopoTableModel tableModel;
    protected DefaultListSelectionModel tableSelectionModel;
    protected ML_Table ml_table;
    protected KL_Table kl_table;
    protected LSL_Table lsl_table;
    protected ArrangeRecord arrangeRecordGroup;
    protected ArrangeRecord arrangeRecord;
    protected boolean isUpdatingTableRowSelection;

    protected AbstractJTopoTable() {
        this.setLayout(new BorderLayout());
        this.ml_table = new ML_Table();
        this.lsl_table = new LSL_Table();
        this.table = new JCustomRendererTable();
        this.table.setAutoResizeMode(0);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.addMouseListener(this.ml_table);
        this.tableSelectionModel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(this.lsl_table);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ColumnHeaderListener());
        this.table.setAutoCreateColumnsFromModel(false);
    }

    private void initState() {
        this.tabular = null;
        this.dataModel = null;
        this.arrangeRecordGroup = null;
        this.arrangeRecord = null;
    }

    public void resetState() {
        this.initState();
    }

    public AbstractJTopoTabular getTabular() {
        return this.tabular;
    }

    public void setSessionModel(AbstractJTopoTabular tabular) {
        this.tabular = tabular;
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel dataModel) {
        if (dataModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoTable.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = dataModel;
        this.updateContainer();
    }

    public JCustomRendererTable getTable() {
        return this.table;
    }

    public DefaultTopoTableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    public DefaultTopoTableModel getTableModel() {
        return this.tableModel;
    }

    public DefaultListSelectionModel getTableSelectionModel() {
        return this.tableSelectionModel;
    }

    protected void handleMouseClick(MouseEvent e) {
        int rowIndex = this.table.rowAtPoint(e.getPoint());
        if (rowIndex == -1) {
            return;
        }
        DefaultTopoTableModel.MemberNode member = this.tableModel.findMemberNode(rowIndex);
        boolean isMinusPlus = false;
        if (member instanceof DefaultTopoTableModel.GroupNode) {
            DefaultTopoTableModel.GroupNode group = (DefaultTopoTableModel.GroupNode)member;
            int columnIndex = this.tableColumnModel.getColumnIndexAtX(e.getX());
            if (columnIndex == -1) {
                return;
            }
            TableColumn column = this.tableColumnModel.getColumn(columnIndex);
            String identifier = (String)column.getIdentifier();
            if (identifier.equals("TOPO_LABEL_ATTR_COMMON_GROUP")) {
                int modelIndex = column.getModelIndex();
                JCustomRendererTable.GroupLabelCell cell = (JCustomRendererTable.GroupLabelCell)member.getData(modelIndex);
                int iconPosStart = cell.getIconPosStart();
                int iconPosEnd = cell.getIconPosEnd();
                Rectangle r = this.table.getCellRect(rowIndex, columnIndex, true);
                int clickX = e.getX() - r.x;
                if (clickX > iconPosStart && clickX < iconPosEnd) {
                    group.setCollapse(!group.isCollapsed());
                    this.tableModel.resetRowIndex();
                    this.tableModel.fireTableDataChanged();
                    this.updateTableRowSelection();
                    isMinusPlus = true;
                }
            }
        }
    }

    protected void handleTableSelection() {
        if (this.isUpdatingTableRowSelection) {
            return;
        }
        ControllerView controllerView = this.tabular.getControllerView();
        ControllerView.SelectionDelta delta = new ControllerView.SelectionDelta(controllerView.getSelection());
        delta.setFromCanvas(false);
        delta.removeAll();
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            DefaultTopoTableModel.MemberNode member = this.tableModel.findMemberNode(selectedRow);
            GraphEntity.ID nodeID = member.getRef();
            delta.add(nodeID);
            delta.setClickedEntityID(nodeID);
        }
        delta.setClickedWidget(this);
        controllerView.updateSelection(delta);
    }

    public boolean applySelection(ControllerView.SelectionDelta delta) {
        boolean foundClicking;
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            GraphEntity.ID nodeID = (GraphEntity.ID)it.next();
            DefaultTopoTableModel.MemberNode member = this.tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            member.setSelected(false);
        }
        boolean isAutoExpand = delta.isAltDown();
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            GraphEntity.ID nodeID = (GraphEntity.ID)it.next();
            DefaultTopoTableModel.MemberNode member = this.tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            member.setSelected(true);
        }
        GraphEntity.ID clickedNodeID = delta.getClickedEntityID();
        DefaultTopoTableModel.MemberNode clickedMember = this.tableModel.findMemberNode(clickedNodeID);
        boolean bl = foundClicking = clickedMember != null;
        if (delta.isFromCanvas() && foundClicking) {
            int rowIndex;
            Rectangle cellRect;
            boolean change = clickedMember.expand();
            if (change) {
                this.tableModel.resetRowIndex();
                this.tableModel.fireTableDataChanged();
            }
            if ((cellRect = this.table.getCellRect(rowIndex = clickedMember.getRowIndex(), 0, true)) != null) {
                this.table.scrollRectToVisible(cellRect);
            }
        }
        this.updateTableRowSelection();
        return foundClicking;
    }

    protected void updateTableRowSelection() {
        this.isUpdatingTableRowSelection = true;
        this.tableSelectionModel.setValueIsAdjusting(true);
        this.updateTableRowSelection_helper(this.tableModel.getRootNode());
        this.tableSelectionModel.setValueIsAdjusting(false);
        this.isUpdatingTableRowSelection = false;
    }

    protected void updateTableRowSelection_helper(DefaultTopoTableModel.GroupNode group) {
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            int rowIndex = member.getRowIndex();
            if (rowIndex != -1) {
                if (member.isSelected() && !this.table.isRowSelected(rowIndex)) {
                    this.tableSelectionModel.addSelectionInterval(rowIndex, rowIndex);
                } else if (!member.isSelected() && this.table.isRowSelected(rowIndex)) {
                    this.tableSelectionModel.removeSelectionInterval(rowIndex, rowIndex);
                }
            }
            if (!(member instanceof DefaultTopoTableModel.GroupNode)) continue;
            DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
            this.updateTableRowSelection_helper(g);
        }
    }

    public boolean locate(ControllerView.LocateDelta delta, String pattern) {
        DefaultTopoTableModel.RootNode root = this.tableModel.getRootNode();
        return this.locate_helper(delta, root, pattern);
    }

    protected boolean locate_helper(ControllerView.LocateDelta delta, DefaultTopoTableModel.GroupNode group, String pattern) {
        boolean groupFound = false;
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            if (member instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
                groupFound |= this.locate_helper(delta, g, pattern);
                continue;
            }
            Vector<JCustomRendererTable.CustomCell> cellV = new Vector<JCustomRendererTable.CustomCell>();
            Vector dataV = member.getDataVector();
            for (int j = 0; j < dataV.size(); ++j) {
                String s;
                JCustomRendererTable.CustomCell cell = (JCustomRendererTable.CustomCell)member.getData(j);
                if (cell == null || (s = cell.toString()).toLowerCase().indexOf(pattern) == -1) continue;
                cellV.add(cell);
            }
            GraphEntity.ID nodeID = member.getRef();
            if (cellV.size() > 0) {
                groupFound |= true;
                if (delta.isInSrc(nodeID)) {
                    delta.change(nodeID);
                } else {
                    delta.add(nodeID);
                }
                delta.putCells(member, cellV);
                continue;
            }
            delta.remove(nodeID);
            delta.removeCells(member);
        }
        return groupFound;
    }

    public void applyLocate(ControllerView.LocateDelta delta) {
        JCustomRendererTable.CustomCell cell;
        Vector dataV;
        JCustomRendererTable.CustomCell matchedCell;
        DefaultTopoTableModel.MemberNode member;
        GraphEntity.ID nodeID;
        int columnIndexMatch = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int modelIndexMatch = this.tableColumnModel.getColumn(columnIndexMatch).getModelIndex();
        DefaultTopoTableModel.RootNode root = this.tableModel.getRootNode();
        boolean isUpdatedFlag = false;
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            nodeID = (GraphEntity.ID)it.next();
            member = this.tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            isUpdatedFlag = true;
            matchedCell = (JCustomRendererTable.CustomCell)member.getData(modelIndexMatch);
            matchedCell.setValue(null);
            matchedCell.setSorting(null);
            matchedCell.setIcon(null);
            matchedCell.setAux(null);
            dataV = member.getDataVector();
            for (int j = 0; j < dataV.size(); ++j) {
                cell = (JCustomRendererTable.CustomCell)member.getData(j);
                cell.setHighlighted(false);
            }
        }
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            nodeID = (GraphEntity.ID)it.next();
            member = this.tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            isUpdatedFlag = true;
            matchedCell = (JCustomRendererTable.CustomCell)member.getData(modelIndexMatch);
            matchedCell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
            matchedCell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
            matchedCell.setIcon(TopoResource.ICON_LOCATE_MATCH);
            matchedCell.setAux(Boolean.TRUE);
            Vector cellV = delta.getCells(member);
            if (cellV == null) continue;
            for (int i = 0; i < cellV.size(); ++i) {
                cell = (JCustomRendererTable.CustomCell)cellV.elementAt(i);
                cell.setHighlighted(true);
            }
        }
        it = delta.iteratorChange();
        while (it.hasNext()) {
            nodeID = (GraphEntity.ID)it.next();
            member = this.tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            isUpdatedFlag = true;
            matchedCell = (JCustomRendererTable.CustomCell)member.getData(modelIndexMatch);
            matchedCell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
            matchedCell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
            matchedCell.setIcon(TopoResource.ICON_LOCATE_MATCH);
            matchedCell.setAux(Boolean.TRUE);
            dataV = member.getDataVector();
            for (int j = 0; j < dataV.size(); ++j) {
                JCustomRendererTable.CustomCell cell2 = (JCustomRendererTable.CustomCell)member.getData(j);
                cell2.setHighlighted(false);
            }
            Vector cellV = delta.getCells(member);
            if (cellV == null) continue;
            for (int i = 0; i < cellV.size(); ++i) {
                JCustomRendererTable.CustomCell cell3 = (JCustomRendererTable.CustomCell)cellV.elementAt(i);
                cell3.setHighlighted(true);
            }
        }
        if (isUpdatedFlag) {
            this.applyLocate_propagate(root);
            this.tableModel.fireTableDataChanged();
            this.applyLocate_scroll(root);
        }
    }

    public boolean applyLocate_propagate(DefaultTopoTableModel.GroupNode group) {
        int columnIndexMatch = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int modelIndexMatch = this.tableColumnModel.getColumn(columnIndexMatch).getModelIndex();
        boolean groupFound = false;
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            if (member instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
                groupFound |= this.applyLocate_propagate(g);
                continue;
            }
            JCustomRendererTable.CustomCell matchedCell = (JCustomRendererTable.CustomCell)member.getData(modelIndexMatch);
            Boolean b = (Boolean)matchedCell.getAux();
            groupFound |= b != null ? b : false;
        }
        JCustomRendererTable.CustomCell matchedCell = (JCustomRendererTable.CustomCell)group.getData(modelIndexMatch);
        if (matchedCell != null) {
            if (groupFound) {
                matchedCell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
                matchedCell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
                matchedCell.setIcon(TopoResource.ICON_LOCATE_MATCH);
                matchedCell.setAux(Boolean.TRUE);
            } else {
                matchedCell.setValue(null);
                matchedCell.setSorting(null);
                matchedCell.setIcon(null);
                matchedCell.setAux(null);
            }
        }
        return groupFound;
    }

    public boolean applyLocate_scroll(DefaultTopoTableModel.GroupNode group) {
        int columnIndexMatch = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int modelIndexMatch = this.tableColumnModel.getColumn(columnIndexMatch).getModelIndex();
        boolean found = false;
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            if (member instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
                found = this.applyLocate_scroll(g);
            } else {
                JCustomRendererTable.CustomCell matchedCell = (JCustomRendererTable.CustomCell)member.getData(modelIndexMatch);
                Boolean b = (Boolean)matchedCell.getAux();
                if (b != null && b.booleanValue()) {
                    Vector dataV = member.getDataVector();
                    for (int j = 0; j < dataV.size(); ++j) {
                        int columnIndex;
                        int rowIndex;
                        Rectangle cellRect;
                        JCustomRendererTable.CustomCell cell = (JCustomRendererTable.CustomCell)member.getData(j);
                        if (!cell.isHighlighted()) continue;
                        boolean change = member.expand();
                        if (change) {
                            this.tableModel.resetRowIndex();
                            this.tableModel.fireTableDataChanged();
                            this.updateTableRowSelection();
                        }
                        if ((cellRect = this.table.getCellRect(rowIndex = member.getRowIndex(), columnIndex = this.table.convertColumnIndexToView(j), true)) != null) {
                            this.table.scrollRectToVisible(cellRect);
                        }
                        found = true;
                        break;
                    }
                }
            }
            if (found) break;
        }
        return found;
    }

    public void expandAll() {
        this.tableModel.collapseAll(false);
        this.updateTableRowSelection();
    }

    public void collapseAll() {
        this.tableModel.collapseAll(true);
        this.updateTableRowSelection();
    }

    public void arrange() {
        if (this.arrangeRecordGroup != null) {
            this.sort(this.arrangeRecordGroup.getIdentifier(), this.arrangeRecordGroup.isAsc());
        }
        if (this.arrangeRecord != null) {
            this.sort(this.arrangeRecord.getIdentifier(), this.arrangeRecord.isAsc());
        }
    }

    public void sort(Object identifier, boolean isAsc) {
        if (identifier == null) {
            return;
        }
        int columnIndex = -1;
        for (int i = 0; i < this.tableColumnModel.getColumnCount(); ++i) {
            TableColumn column = this.tableColumnModel.getColumn(i);
            JCustomRendererTable.CustomHeader header = (JCustomRendererTable.CustomHeader)column.getHeaderValue();
            if (identifier.equals(column.getIdentifier())) {
                ImageIcon icon = isAsc ? TopoResource.ICON_SORT_ASC : TopoResource.ICON_SORT_DSC;
                header.setIcon(icon);
                columnIndex = i;
                continue;
            }
            header.setIcon(null);
        }
        if (columnIndex != -1) {
            int modelIndex = this.tableColumnModel.getColumn(columnIndex).getModelIndex();
            this.tableModel.sort(modelIndex, isAsc);
            this.tableModel.resetRowIndex();
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        }
    }

    public void setShowConnectionEnabled(boolean b) {
    }

    public void setShowZoneEnabled(boolean b) {
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.tableColumnModel.setOverlayHealthEnabled(b);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.tableColumnModel.setOverlayPerfEnabled(b);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setFilteringLevel(int filteringLevel) {
        this.updateContainer();
    }

    public void setPinnedList(PinList pinnedList) {
        if (this instanceof JTopoTableSubsystem || this instanceof JTopoTableComputer || this instanceof JTopoTableSwitch || this instanceof JTopoTableTapeLibrary || this instanceof JTopoTableOther) {
            DefaultTopoTableModel.RootNode root = this.tableModel.getRootNode();
            Vector pinnedNodeIDV = pinnedList.getPins();
            int columnIndexPinned = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_PINNED");
            int modelIndexPinned = this.tableColumnModel.getColumn(columnIndexPinned).getModelIndex();
            this.setPinnedList_helper(root, pinnedNodeIDV, modelIndexPinned);
            this.tableModel.fireTableDataChanged();
        }
    }

    protected boolean setPinnedList_helper(DefaultTopoTableModel.GroupNode group, Vector pinnedNodeIDV, int modelIndexPinned) {
        Vector memberV = group.getMemberVector();
        boolean groupFlag = false;
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            boolean memberFlag = false;
            if (member instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
                boolean found = this.setPinnedList_helper(g, pinnedNodeIDV, modelIndexPinned);
                memberFlag = memberFlag || found;
                groupFlag = groupFlag || found;
            } else {
                for (int j = 0; j < pinnedNodeIDV.size(); ++j) {
                    GraphEntity.ID pinnedNodeID = (GraphEntity.ID)pinnedNodeIDV.elementAt(j);
                    if (!member.getRef().equals(pinnedNodeID)) continue;
                    memberFlag = true;
                    groupFlag = true;
                    break;
                }
            }
            JCustomRendererTable.CustomCell cell = (JCustomRendererTable.CustomCell)member.getData(modelIndexPinned);
            if (cell == null) continue;
            if (memberFlag) {
                cell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED"));
                cell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_PINNED"));
                cell.setIcon(TopoResource.ICON_PIN_ON);
                cell.setAux(Boolean.TRUE);
                continue;
            }
            cell.setValue(null);
            cell.setSorting(null);
            cell.setIcon(null);
            cell.setAux(null);
        }
        JCustomRendererTable.CustomCell cell = (JCustomRendererTable.CustomCell)group.getData(modelIndexPinned);
        if (cell != null) {
            if (groupFlag) {
                cell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED"));
                cell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_PINNED"));
                cell.setIcon(TopoResource.ICON_PIN_ON);
                cell.setAux(Boolean.TRUE);
            } else {
                cell.setValue(null);
                cell.setSorting(null);
                cell.setIcon(null);
                cell.setAux(null);
            }
        }
        return groupFlag;
    }

    protected class ColumnHeaderListener
    extends MouseAdapter {
        protected ColumnHeaderListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int columnIndex = AbstractJTopoTable.this.tableColumnModel.getColumnIndexAtX(e.getX());
            if (columnIndex == -1) {
                return;
            }
            TableColumn column = AbstractJTopoTable.this.tableColumnModel.getColumn(columnIndex);
            Object identifier = column.getIdentifier();
            if (AbstractJTopoTable.this.arrangeRecordGroup != null && identifier.equals(AbstractJTopoTable.this.arrangeRecordGroup.getIdentifier())) {
                AbstractJTopoTable.this.arrangeRecordGroup.setAsc(!AbstractJTopoTable.this.arrangeRecordGroup.isAsc());
            } else if (AbstractJTopoTable.this.arrangeRecord != null) {
                if (identifier.equals(AbstractJTopoTable.this.arrangeRecord.getIdentifier())) {
                    AbstractJTopoTable.this.arrangeRecord.setAsc(!AbstractJTopoTable.this.arrangeRecord.isAsc());
                } else {
                    AbstractJTopoTable.this.arrangeRecord.setIdentifier(identifier);
                }
            }
            AbstractJTopoTable.this.arrange();
        }
    }

    protected class ArrangeRecord {
        private Object identifier;
        private boolean isAsc;

        public ArrangeRecord() {
        }

        public ArrangeRecord(Object identifier, boolean isAsc) {
            this.identifier = identifier;
            this.isAsc = isAsc;
        }

        public boolean isAsc() {
            return this.isAsc;
        }

        public void setAsc(boolean isAsc) {
            this.isAsc = isAsc;
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Object identifier) {
            this.identifier = identifier;
        }
    }

    protected class KL_Table
    extends KeyAdapter {
        protected KL_Table() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    protected class LSL_Table
    implements ListSelectionListener {
        protected LSL_Table() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AbstractJTopoTable.this.handleTableSelection();
            }
        }
    }

    protected class ML_Table
    extends MouseAdapter {
        protected ML_Table() {
        }

        public void mouseReleased(MouseEvent e) {
            AbstractJTopoTable.this.handleMouseClick(e);
        }
    }
}

