/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.JTopoViewGroup;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class ControllerView {
    protected ControllerApp controllerApp;
    protected GraphModel.ID modelID;
    protected GraphModel dataModel;
    protected JTopoView topoView;
    protected HashSet selectionHS;
    protected HashSet highlightHS;
    protected HashSet locateHS;
    protected String locatePattern;

    public ControllerView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, constructor");
        }
        this.selectionHS = new HashSet();
        this.highlightHS = new HashSet();
        this.locateHS = new HashSet();
        WidgetPool widgetPool = WidgetPool.getInstance();
        this.topoView = (JTopoView)widgetPool.getWidget(JTopoView.class);
    }

    public void destruct() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, destruct, modelID=" + this.modelID);
        }
        if (this.topoView != null) {
            if (this.controllerApp != null) {
                JTopoViewGroup topoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
                if (topoViewGroup.getSelectedComponent() == this.topoView) {
                    this.controllerApp.getTopoApp().getMiniMapFrame().getContentPane().removeAll();
                }
                topoViewGroup.removeTopoView(this.topoView);
            }
            WidgetPool widgetPool = WidgetPool.getInstance();
            widgetPool.recycleWidget(this.topoView);
        }
        this.controllerApp = null;
        this.modelID = null;
        this.topoView = null;
        this.dataModel = null;
        this.selectionHS = null;
        this.highlightHS = null;
        this.locateHS = null;
        this.locatePattern = null;
    }

    public ControllerApp getControllerApp() {
        return this.controllerApp;
    }

    public GraphModel.ID getModelID() {
        return this.modelID;
    }

    public void setSessionModel(ControllerApp controllerApp, GraphModel.ID modelID) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setSessionModel(), modelID=" + modelID + ", controllerApp=" + controllerApp);
        }
        this.modelID = modelID;
        this.controllerApp = controllerApp;
        this.selectionHS.clear();
        this.highlightHS.clear();
        this.locateHS.clear();
        this.locatePattern = null;
        this.topoView.setSessionModel(this);
        JTopoViewGroup topoViewGroup = controllerApp.getTopoApp().getTopoViewGroup();
        topoViewGroup.addTopoView(this.topoView);
        this.dataModel = new GraphModel(modelID);
        this.setDataModel(this.dataModel);
        this.refreshView();
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel dataModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setDataModel(), modelID=" + this.modelID);
        }
        this.dataModel = dataModel;
        this.updateView();
    }

    public JTopoView getTopoView() {
        return this.topoView;
    }

    public void focus() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, focus(), modelID=" + this.modelID);
        }
        JTopoViewGroup topoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        topoViewGroup.setFocusedTopoView(this.topoView);
    }

    public void updateView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateView(), modelID=" + this.modelID + ", withPerfData=" + this.dataModel.isWithPerfData() + ", withZoneData=" + this.dataModel.isWithZoneData());
        }
        TopoSetting setting = this.controllerApp.getTopoSetting();
        PinList pinList = this.controllerApp.getPinList();
        long start = System.currentTimeMillis();
        this.dataModel.applyCollationKey();
        this.dataModel.applyScope();
        this.dataModel.applyPerfStatus();
        Hashtable groupBySet = setting.getSettingPerViewType(this.modelID.getFocusLevel()).getGroupBySet();
        this.dataModel.applyGrouping(groupBySet);
        this.dataModel.applyFiltering(setting.getFilteringLevel());
        long end = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 1) all pre-processing steps, cost=" + (end - start) + " ms, " + new Date(end));
        }
        start = System.currentTimeMillis();
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.highlight("ControllerView, updateView(), --------------- " + this.modelID.getFocusLevel() + " ---------------");
            GraphDebug.highlight(this.dataModel.toString());
        }
        this.topoView.setDataModel(this.dataModel);
        end = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 2) set data model, cost=" + (end - start) + " ms, " + new Date(end));
        }
        start = System.currentTimeMillis();
        this.setShowConnectionEnabled(setting.isShowConnectionEnabled());
        this.setShowZoneEnabled(setting.isShowZoneEnabled());
        this.setPinList(pinList);
        this.setLocate(this.locatePattern);
        end = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 3) all post-processing, cost=" + (end - start) + " ms, " + new Date(end));
        }
    }

    public void invalidateView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, invalidateView(), modelID=" + this.modelID);
        }
        this.topoView.setEnabled(false);
    }

    public void print() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, print(), modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.printCanvas();
    }

    public void refreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, refreshView(), modelID=" + this.modelID);
        }
        this.controllerApp.refreshView(this.modelID);
    }

    public void startRefreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, startRefreshView(), modelID=" + this.modelID);
        }
        this.topoView.setRefreshInProgress(true);
        JTopoViewGroup topoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        topoViewGroup.revalidate();
        topoViewGroup.repaint();
        try {
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerView, startRefreshView(), thread sleeps");
            }
            Thread.sleep(250L);
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerView, startRefreshView(), thread wakes up");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishRefreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, finishRefreshView(), modelID=" + this.modelID);
        }
        this.topoView.setRefreshInProgress(false);
        JTopoViewGroup topoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        topoViewGroup.revalidate();
        topoViewGroup.repaint();
    }

    public void cancelAllRefresh() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, cancelAllRefresh(), modelID=" + this.modelID);
        }
    }

    public void setOverlayHealthEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setOverlayHealthEnabled(), b=" + b + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setOverlayHealthEnabled(b);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setOverlayHealthEnabled(b);
    }

    public void setOverlayPerfEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setOverlayPerfEnabled(), b=" + b + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setOverlayPerfEnabled(b);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setOverlayPerfEnabled(b);
        this.modelID.setNeedPerfData(b);
        if (b && !this.dataModel.isWithPerfData()) {
            String focusLevel = this.modelID.getFocusLevel();
            boolean needRefresh = false;
            if (focusLevel.equals("SwitchL2") || focusLevel.equals("SubsystemL2")) {
                needRefresh = true;
            }
            if (needRefresh) {
                this.controllerApp.refreshView(this.modelID);
            }
        }
    }

    public void setFilteringLevel(int filteringLevel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setFilteringLevel(), filteringLevel=" + filteringLevel + ", modelID=" + this.modelID);
        }
        this.dataModel.applyFiltering(this.controllerApp.getTopoSetting().getFilteringLevel());
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setFilteringLevel(filteringLevel);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setFilteringLevel(filteringLevel);
    }

    public void setShowConnectionEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setShowConnectionEnabled(), b=" + b + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setShowConnectionEnabled(b);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setShowConnectionEnabled(b);
    }

    public void setShowZoneEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setShowZoneEnabled(), b=" + b + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setShowZoneEnabled(b);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setShowZoneEnabled(b);
        this.modelID.setNeedZoneData(b);
        if (b && !this.dataModel.isWithZoneData()) {
            String focusLevel = this.modelID.getFocusLevel();
            boolean needRefresh = true;
            if (focusLevel.equals("Overview") || focusLevel.equals("FabricL0") || focusLevel.equals("ComputerL0") || focusLevel.equals("SwitchL0") || focusLevel.equals("StorageL0") || focusLevel.equals("OtherL0")) {
                needRefresh = false;
            }
            if (needRefresh) {
                this.controllerApp.refreshView(this.modelID);
            }
        }
    }

    public void setPinList(PinList pinnedList) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setPinList(), modelID=" + this.modelID);
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.setPinList(pinnedList);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.setPinList(pinnedList);
    }

    public void setLocate(String pattern) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setLocate(), pattern=" + pattern + ", modelID=" + this.modelID);
        }
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.locate(pattern);
    }

    protected void canvasLayoutChanged() {
        JTopoMiniMap miniMap = this.topoView.getMiniMap();
        miniMap.canvasLayoutChanged();
    }

    protected void viewportPositionChanged() {
        JTopoMiniMap miniMap = this.topoView.getMiniMap();
        miniMap.viewportPositionChanged();
    }

    public HashSet getSelection() {
        return this.selectionHS;
    }

    public void updateSelection(SelectionDelta delta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateSelection(), delta=" + delta + ", modelID=" + this.modelID);
        }
        if (!delta.isEmpty()) {
            Iterator it = delta.iteratorRemove();
            while (it.hasNext()) {
                this.selectionHS.remove(it.next());
            }
            it = delta.iteratorAdd();
            while (it.hasNext()) {
                this.selectionHS.add(it.next());
            }
            AbstractJTopoCanvas canvas = this.topoView.getCanvas();
            canvas.applySelection(delta);
            AbstractJTopoTabular tabular = this.topoView.getTabular();
            tabular.applySelection(delta);
        }
    }

    public HashSet getHighlight() {
        return this.highlightHS;
    }

    public void updateHighlight(HighlightDelta delta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateHighlight(), delta=" + delta + ", modelID=" + this.modelID);
        }
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            this.highlightHS.remove(it.next());
        }
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            this.highlightHS.add(it.next());
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.applyHighlight(delta);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.applyHighlight(delta);
    }

    public String getLocatePattern() {
        return this.locatePattern;
    }

    public HashSet getLocate() {
        return this.locateHS;
    }

    public void updateLocate(LocateDelta delta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateLocate(), delta=" + delta + ", modelID=" + this.modelID);
        }
        this.locatePattern = delta.getPattern();
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            this.locateHS.remove(it.next());
        }
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            this.locateHS.add(it.next());
        }
        AbstractJTopoCanvas canvas = this.topoView.getCanvas();
        canvas.applyLocate(delta);
        AbstractJTopoTabular tabular = this.topoView.getTabular();
        tabular.applyLocate(delta);
    }

    public static class LocateDelta {
        protected String pattern;
        protected HashSet srcHS;
        protected GraphEntity.ID clickedEntityID;
        protected HashSet addHS;
        protected HashSet removeHS;
        protected HashSet changeHS;
        protected Hashtable cellH;

        public LocateDelta(String pattern, HashSet hs) {
            this.pattern = pattern;
            this.srcHS = new HashSet();
            Iterator it = hs.iterator();
            while (it.hasNext()) {
                this.srcHS.add(it.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
            this.changeHS = new HashSet();
            this.cellH = new Hashtable();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("LocateDelta: clickedEntityID=" + this.clickedEntityID);
            sb.append("\r\n  pattern=" + this.pattern);
            sb.append("\r\n  srcHS=" + this.srcHS);
            sb.append("\r\n  addHS=" + this.addHS);
            sb.append("\r\n  removeHS=" + this.removeHS);
            sb.append("\r\n  changeHS=" + this.changeHS);
            sb.append("\r\n  cellH=" + this.cellH);
            return sb.toString();
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID clickedEntityID) {
            this.clickedEntityID = clickedEntityID;
        }

        public boolean isInSrc(GraphEntity.ID nodeID) {
            return this.srcHS.contains(nodeID);
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public Iterator iteratorChange() {
            return this.changeHS.iterator();
        }

        public void add(GraphEntity.ID nodeID) {
            if (this.removeHS.contains(nodeID)) {
                this.removeHS.remove(nodeID);
            } else if (!this.srcHS.contains(nodeID)) {
                this.addHS.add(nodeID);
            }
        }

        public void remove(GraphEntity.ID nodeID) {
            if (this.addHS.contains(nodeID)) {
                this.addHS.remove(nodeID);
            } else if (this.srcHS.contains(nodeID)) {
                this.removeHS.add(nodeID);
            }
        }

        public void removeAll() {
            this.changeHS.clear();
            this.cellH.clear();
            Iterator it = this.srcHS.iterator();
            while (it.hasNext()) {
                this.removeHS.add(it.next());
            }
        }

        public void change(GraphEntity.ID nodeID) {
            this.changeHS.add(nodeID);
        }

        public Vector getCells(DefaultTopoTableModel.MemberNode memberNode) {
            return (Vector)this.cellH.get(memberNode);
        }

        public void putCells(DefaultTopoTableModel.MemberNode memberNode, Vector cellV) {
            this.cellH.put(memberNode, cellV);
        }

        public void removeCells(DefaultTopoTableModel.MemberNode memberNode) {
            this.cellH.remove(memberNode);
        }
    }

    public static class HighlightDelta {
        protected HashSet srcHS = new HashSet();
        protected GraphEntity.ID clickedEntityID;
        protected HashSet addHS;
        protected HashSet removeHS;

        public HighlightDelta(HashSet hs) {
            Iterator it = hs.iterator();
            while (it.hasNext()) {
                this.srcHS.add(it.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("HighlightDelta: clickedEntityID=" + this.clickedEntityID);
            sb.append("\r\n  srcHS=" + this.srcHS);
            sb.append("\r\n  addHS=" + this.addHS);
            sb.append("\r\n  removeHS=" + this.removeHS);
            return sb.toString();
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID clickedEntityID) {
            this.clickedEntityID = clickedEntityID;
        }

        public boolean isInSrc(GraphEntity.ID nodeID) {
            return this.srcHS.contains(nodeID);
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public void add(GraphEntity.ID nodeID) {
            if (this.removeHS.contains(nodeID)) {
                this.removeHS.remove(nodeID);
            } else if (!this.srcHS.contains(nodeID)) {
                this.addHS.add(nodeID);
            }
        }

        public void remove(GraphEntity.ID nodeID) {
            if (this.addHS.contains(nodeID)) {
                this.addHS.remove(nodeID);
            } else if (this.srcHS.contains(nodeID)) {
                this.removeHS.add(nodeID);
            }
        }

        public void removeAll() {
            Iterator it = this.srcHS.iterator();
            while (it.hasNext()) {
                this.removeHS.add(it.next());
            }
        }
    }

    public static class SelectionDelta {
        protected HashSet srcHS = new HashSet();
        protected boolean isAltDown;
        protected boolean isFromCanvas;
        protected GraphEntity.ID clickedEntityID;
        protected Object clickedWidget;
        protected HashSet addHS;
        protected HashSet removeHS;

        public SelectionDelta(HashSet hs) {
            Iterator it = hs.iterator();
            while (it.hasNext()) {
                this.srcHS.add(it.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SelectionDelta: isAltDown=" + this.isAltDown + ", isFromCanvas=" + this.isFromCanvas + ", clickedEntityID=" + this.clickedEntityID + ", clickedWidget=" + this.clickedWidget);
            sb.append("\r\n  srcHS=" + this.srcHS);
            sb.append("\r\n  addHS=" + this.addHS);
            sb.append("\r\n  removeHS=" + this.removeHS);
            return sb.toString();
        }

        public boolean isEmpty() {
            return this.addHS.isEmpty() && this.removeHS.isEmpty();
        }

        public boolean isAltDown() {
            return this.isAltDown;
        }

        public void setAltDown(boolean b) {
            this.isAltDown = b;
        }

        public boolean isFromCanvas() {
            return this.isFromCanvas;
        }

        public void setFromCanvas(boolean b) {
            this.isFromCanvas = b;
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID clickedEntityID) {
            this.clickedEntityID = clickedEntityID;
        }

        public Object getClickedWidget() {
            return this.clickedWidget;
        }

        public void setClickedWidget(Object clickedWidget) {
            this.clickedWidget = clickedWidget;
        }

        public boolean isInSrc(GraphEntity.ID nodeID) {
            return this.srcHS.contains(nodeID);
        }

        public Iterator iteratorSrc() {
            return this.srcHS.iterator();
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public void add(GraphEntity.ID nodeID) {
            if (this.removeHS.contains(nodeID)) {
                this.removeHS.remove(nodeID);
            } else if (!this.srcHS.contains(nodeID)) {
                this.addHS.add(nodeID);
            }
        }

        public void remove(GraphEntity.ID nodeID) {
            if (this.addHS.contains(nodeID)) {
                this.addHS.remove(nodeID);
            } else if (this.srcHS.contains(nodeID)) {
                this.removeHS.add(nodeID);
            }
        }

        public void removeAll() {
            this.addHS.clear();
            Iterator it = this.srcHS.iterator();
            while (it.hasNext()) {
                this.removeHS.add(it.next());
            }
        }
    }
}

