/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.CollationKey;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.plaf.basic.BasicCustomRendererTableUI;

public class JCustomRendererTable
extends JTable {
    protected CustomTableCellRenderer cellRenderer;
    protected CustomTableCellEditor cellEditor;
    protected CustomTableHeaderRenderer headerRenderer;

    public JCustomRendererTable() {
        JTableHeader header = this.getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.setReorderingAllowed(true);
        this.headerRenderer = new CustomTableHeaderRenderer();
        this.cellRenderer = new CustomTableCellRenderer();
        this.cellEditor = new CustomTableCellEditor();
        BasicCustomRendererTableUI ui = new BasicCustomRendererTableUI();
        this.setUI(ui);
    }

    protected JTableHeader createDefaultTableHeader() {
        CustomJTableHeader header = new CustomJTableHeader(this.getColumnModel());
        return header;
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn column = cm.getColumn(i);
            column.setCellRenderer(this.cellRenderer);
            column.setCellEditor(this.cellEditor);
            column.setHeaderRenderer(this.headerRenderer);
            CustomHeader customHeader = new CustomHeader(column.getHeaderValue());
            if (column instanceof DefaultTopoTableColumnStatus) {
                customHeader.setIcon(((DefaultTopoTableColumnStatus)column).getIcon());
            }
            column.setHeaderValue(customHeader);
        }
    }

    protected static class CustomHeader {
        private Object value;
        private ImageIcon icon;

        public CustomHeader(Object value) {
            this.value = value;
            this.icon = null;
        }

        public String toString() {
            return this.value == null ? "" : this.value.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }
    }

    protected class CustomTableHeaderRenderer
    extends DefaultTableCellRenderer {
        public CustomTableHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (value instanceof CustomHeader) {
                CustomHeader h = (CustomHeader)value;
                this.setText(h.toString());
                this.setIcon(h.getIcon());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    protected class CustomJTableHeader
    extends JTableHeader {
        public CustomJTableHeader(TableColumnModel columnModel) {
            super(columnModel);
        }

        public String getToolTipText(MouseEvent me) {
            Point p = me.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            String t = null;
            if (index != -1) {
                t = this.columnModel.getColumn(index).getHeaderValue().toString();
            }
            return t;
        }
    }

    protected class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        public CustomTableCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public void setValue(Object value) {
            if (value instanceof CustomCell) {
                CustomCell cell = (CustomCell)value;
                this.setIcon(cell.getIcon());
                super.setValue(cell.toString());
                if (cell.isHighlighted()) {
                    this.setBorder(TopoResource.BORDER_TABLECELL_HIGHLIGHTED);
                } else {
                    this.setBorder(null);
                }
                if (cell instanceof GroupLabelCell) {
                    this.setFont(TopoResource.FONT_BOLD);
                } else {
                    this.setFont(TopoResource.FONT_PLAIN);
                }
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }
    }

    protected class CustomTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTextField textField = new JTextField();
        protected Object value;

        public CustomTableCellEditor() {
            this.textField.setEditable(false);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            if (value instanceof CustomCell) {
                CustomCell cell = (CustomCell)value;
                this.textField.setText(cell.toString());
                if (cell.isHighlighted()) {
                    JCustomRendererTable.this.setBorder(TopoResource.BORDER_TABLECELL_HIGHLIGHTED);
                } else {
                    JCustomRendererTable.this.setBorder(null);
                }
                if (cell instanceof GroupLabelCell) {
                    JCustomRendererTable.this.setFont(TopoResource.FONT_BOLD);
                } else {
                    JCustomRendererTable.this.setFont(TopoResource.FONT_PLAIN);
                }
            } else {
                this.textField.setText(value == null ? null : value.toString());
            }
            return this.textField;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= 2;
            }
            return true;
        }
    }

    protected static class MemberGroupLabelCell
    extends ComparableCell {
        protected DefaultTopoTableModel.GroupNode group;

        public MemberGroupLabelCell(String s, DefaultTopoTableModel.GroupNode group) {
            super((Comparable)((Object)s));
            this.group = group;
            this.adjustIcon();
        }

        public DefaultTopoTableModel.GroupNode getGroupNode() {
            return this.group;
        }

        protected void adjustIcon() {
            ImageIcon adjustedEmptyIcon;
            int level = this.group.getLevel();
            ImageIcon empty = TopoResource.ICON_BOX_EMPTY;
            int w = empty.getIconWidth();
            int h = empty.getIconHeight();
            BufferedImage bimage = new BufferedImage(w * level, h, 2);
            Graphics2D g2D = bimage.createGraphics();
            g2D.drawImage(empty.getImage(), w * (level - 1), 0, null);
            g2D.dispose();
            this.icon = adjustedEmptyIcon = new ImageIcon(bimage);
        }

        public int compareTo(Object o) {
            return 0;
        }
    }

    protected static class GroupLabelCell
    extends CollatorCell {
        protected DefaultTopoTableModel.GroupNode group;
        protected ImageIcon adjustedMinusIcon;
        protected ImageIcon adjustedPlusIcon;
        protected int iconPosStart;
        protected int iconPosEnd;

        public GroupLabelCell(String s, Comparable sorting, CollationKey collationKey, DefaultTopoTableModel.GroupNode group) {
            super(s, sorting, collationKey);
            this.group = group;
            this.adjustIcon();
        }

        public DefaultTopoTableModel.GroupNode getGroupNode() {
            return this.group;
        }

        public int getIconPosStart() {
            return this.iconPosStart;
        }

        public int getIconPosEnd() {
            return this.iconPosEnd;
        }

        public ImageIcon getIcon() {
            if (this.group.isCollapsed) {
                return this.adjustedPlusIcon;
            }
            return this.adjustedMinusIcon;
        }

        protected void adjustIcon() {
            int level = this.group.getLevel();
            ImageIcon empty = TopoResource.ICON_BOX_EMPTY;
            int w = empty.getIconWidth();
            int h = empty.getIconHeight();
            this.iconPosStart = w * (level - 1);
            this.iconPosEnd = w * level;
            ImageIcon minus = TopoResource.ICON_BOX_MINUS;
            BufferedImage bimage = new BufferedImage(w * level, h, 2);
            Graphics2D g2D = bimage.createGraphics();
            g2D.drawImage(minus.getImage(), w * (level - 1), 0, null);
            g2D.dispose();
            this.adjustedMinusIcon = new ImageIcon(bimage);
            ImageIcon plus = TopoResource.ICON_BOX_PLUS;
            bimage = new BufferedImage(w * level, h, 2);
            g2D = bimage.createGraphics();
            g2D.drawImage(plus.getImage(), w * (level - 1), 0, null);
            g2D.dispose();
            this.adjustedPlusIcon = new ImageIcon(bimage);
        }
    }

    protected static class CollatorCell
    extends CustomCell {
        protected CollationKey collationKey;

        public CollatorCell(String s, CollationKey collationKey) {
            this(s, null, collationKey);
        }

        public CollatorCell(String s, Comparable sorting, CollationKey collationKey) {
            super(s, sorting, null);
            this.collationKey = collationKey;
        }

        public int compareTo(Object o) {
            if (!(o instanceof CollatorCell)) {
                return super.compareTo(o);
            }
            CollatorCell cell2 = (CollatorCell)o;
            try {
                Comparable sorting2 = cell2.sorting;
                if (this.sorting != null && sorting2 != null) {
                    return this.sorting.compareTo(sorting2);
                }
                if (this.sorting != null) {
                    return -1;
                }
                if (sorting2 != null) {
                    return 1;
                }
                CollationKey collationKey2 = cell2.collationKey;
                if (this.collationKey != null && collationKey2 != null) {
                    return this.collationKey.compareTo(collationKey2);
                }
                if (this.collationKey != null) {
                    return -1;
                }
                if (collationKey2 != null) {
                    return 1;
                }
                Object value2 = cell2.value;
                if (this.value != null && value2 != null) {
                    String s1 = this.value.toString();
                    String s2 = value2.toString();
                    return s1.compareTo(s2);
                }
                if (this.value != null) {
                    return -1;
                }
                if (value2 != null) {
                    return 1;
                }
                return 0;
            }
            catch (RuntimeException e) {
                return 0;
            }
        }
    }

    protected static class StatusCell
    extends CustomCell {
        public StatusCell(String label, Integer sorting, ImageIcon icon) {
            super(label, sorting, icon);
        }
    }

    protected static class FormatedStringCell
    extends CustomCell {
        public FormatedStringCell(String label, Comparable sorting) {
            super(label, sorting, null);
        }
    }

    protected static class ComparableCell
    extends CustomCell {
        public ComparableCell(Comparable value) {
            super(value, value, null);
        }
    }

    protected static class CustomCell
    implements Comparable {
        protected Object value;
        protected Comparable sorting;
        protected ImageIcon icon;
        protected String str;
        protected Object aux;
        protected boolean isHighlighted;

        public CustomCell(Object value, Comparable sorting, ImageIcon icon) {
            this.value = value;
            this.sorting = sorting;
            this.icon = icon;
            this.str = value != null ? (value instanceof String ? (String)value : value.toString()) : "";
            this.isHighlighted = false;
        }

        public String toString() {
            return this.str;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Comparable getSorting() {
            return this.sorting;
        }

        public void setSorting(Comparable sorting) {
            this.sorting = sorting;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }

        public Object getAux() {
            return this.aux;
        }

        public void setAux(Object aux) {
            this.aux = aux;
        }

        public boolean isHighlighted() {
            return this.isHighlighted;
        }

        public void setHighlighted(boolean b) {
            this.isHighlighted = b;
        }

        public int compareTo(Object o) {
            if (!(o instanceof CustomCell)) {
                throw new ClassCastException();
            }
            CustomCell cell2 = (CustomCell)o;
            try {
                Comparable sorting2 = cell2.sorting;
                if (this.sorting != null && sorting2 != null) {
                    if (this.sorting.getClass().equals(sorting2.getClass())) {
                        return this.sorting.compareTo(sorting2);
                    }
                } else {
                    if (this.sorting != null) {
                        return -1;
                    }
                    if (sorting2 != null) {
                        return 1;
                    }
                }
                Object value2 = cell2.value;
                if (this.value != null && value2 != null) {
                    String s1 = this.value.toString();
                    String s2 = value2.toString();
                    return s1.compareTo(s2);
                }
                if (this.value != null) {
                    return -1;
                }
                if (value2 != null) {
                    return 1;
                }
                return 0;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

