/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoBoxHBA
extends AbstractJTopoBox {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphHBA hba = (GraphHBA)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_HBA"));
        groupModel.setLabel(hba.getDisplayName());
        groupModel.setHealth(hba.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_HBA_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_HBA_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_HBA_16_MISSING);
        groupModel.removeAllSummaries();
        int fcportUsedTotal = hba.getNumOfFCPortsInUse();
        int fcportUsedUnfiltered = hba.getNumOfAbnormalFCPortsInUse();
        groupModel.addSummary(new ITopoGroupModel.Summary(fcportUsedTotal, fcportUsedUnfiltered, GuiUtil.getString("TOPO_LABEL_COMMON_INUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"), GuiUtil.getString("TOPO_LABEL_COMMON_INUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORTS")));
        int fcportEmptyTotal = hba.getNumOfFCPortsEmpty();
        int fcportEmptyUnfiltered = hba.getNumOfAbnormalFCPortsEmpty();
        groupModel.addSummary(new ITopoGroupModel.Summary(fcportEmptyTotal, fcportEmptyUnfiltered, GuiUtil.getString("TOPO_LABEL_COMMON_UNUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"), GuiUtil.getString("TOPO_LABEL_COMMON_UNUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORTS")));
        int total = fcportUsedTotal + fcportEmptyTotal;
        int unfiltered = fcportUsedUnfiltered + fcportEmptyUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(hba.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.HorizontalGridLayout {
            public DefaultLayout() {
                super(4);
            }
        }
    }
}

