/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoBoxTapeDrive
extends AbstractJTopoBox {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphTapeDrive drive = (GraphTapeDrive)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_TAPEDRIVE"));
        groupModel.setLabel(drive.getDisplayName());
        groupModel.setHealth(drive.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_TAPEDRIVE_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_TAPEDRIVE_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_TAPEDRIVE_16_MISSING);
        groupModel.removeAllSummaries();
        int fcportUsedTotal = drive.getNumOfFCPortsInUse();
        int fcportUsedUnfiltered = drive.getNumOfAbnormalFCPortsInUse();
        groupModel.addSummary(new ITopoGroupModel.Summary(fcportUsedTotal, fcportUsedUnfiltered, GuiUtil.getString("TOPO_LABEL_COMMON_INUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"), GuiUtil.getString("TOPO_LABEL_COMMON_INUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORTS")));
        int fcportEmptyTotal = drive.getNumOfFCPortsEmpty();
        int fcportEmptyUnfiltered = drive.getNumOfAbnormalFCPortsEmpty();
        groupModel.addSummary(new ITopoGroupModel.Summary(fcportEmptyTotal, fcportEmptyUnfiltered, GuiUtil.getString("TOPO_LABEL_COMMON_UNUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"), GuiUtil.getString("TOPO_LABEL_COMMON_UNUSED") + " " + GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORTS")));
        int total = fcportUsedTotal + fcportEmptyTotal;
        int unfiltered = fcportUsedUnfiltered + fcportEmptyUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(drive.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.HorizontalGridLayout {
            public DefaultLayout() {
                super(4);
            }
        }
    }
}

