/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoDialogGlobalSetting
extends JDialog {
    private JCheckBox healthCB;
    private JCheckBox perfCB;
    private JCheckBox policyCB;
    private JCheckBox filteringCB;
    private JCheckBox filteringCondCB;
    private JCheckBox connCB;
    private JCheckBox zoneCB;

    public JTopoDialogGlobalSetting(Frame frame, ControllerApp controllerApp) {
        super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_TITLE"), true);
        TopoSetting setting = controllerApp.getTopoSetting();
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel mainP = new JPanel();
        mainP.setBorder(new EmptyBorder(5, 5, 5, 5));
        TopoLayoutUtilities.VerticalLayout layout = new TopoLayoutUtilities.VerticalLayout();
        mainP.setLayout(layout);
        content.add((Component)mainP, "Center");
        JLabel overlayL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY"));
        overlayL.setBorder(new EmptyBorder(10, 2, 2, 2));
        mainP.add(overlayL);
        this.healthCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_HEALTH"), setting.isOverlayHealthEnabled());
        this.healthCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.healthCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JTopoDialogGlobalSetting.this.healthCB.isSelected()) {
                    JTopoDialogGlobalSetting.this.filteringCB.setEnabled(true);
                    if (JTopoDialogGlobalSetting.this.filteringCB.isSelected()) {
                        JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(true);
                    } else {
                        JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                    }
                } else {
                    JTopoDialogGlobalSetting.this.filteringCB.setEnabled(false);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                }
            }
        });
        mainP.add(this.healthCB);
        this.perfCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_PERF"), setting.isOverlayPerfEnabled());
        this.perfCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.perfCB.setVisible(false);
        mainP.add(this.perfCB);
        this.policyCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_POLICY"));
        this.policyCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.policyCB.setEnabled(false);
        JLabel filteringL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING"));
        filteringL.setBorder(new EmptyBorder(10, 2, 2, 2));
        mainP.add(filteringL);
        int filteringLevel = setting.getFilteringLevel();
        this.filteringCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING_NORMAL"), filteringLevel != 0);
        this.filteringCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.filteringCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JTopoDialogGlobalSetting.this.filteringCB.isSelected()) {
                    JTopoDialogGlobalSetting.this.healthCB.setEnabled(false);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(true);
                } else {
                    JTopoDialogGlobalSetting.this.healthCB.setEnabled(true);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                }
            }
        });
        mainP.add(this.filteringCB);
        this.filteringCondCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING_NORMAL_LESS"), filteringLevel == 1);
        this.filteringCondCB.setBorder(new EmptyBorder(2, 40, 2, 2));
        mainP.add(this.filteringCondCB);
        if (!this.healthCB.isSelected()) {
            this.filteringCB.setEnabled(false);
            this.filteringCondCB.setEnabled(false);
        }
        if (this.filteringCB.isSelected()) {
            this.healthCB.setEnabled(false);
        }
        if (!this.filteringCB.isSelected()) {
            this.filteringCondCB.setEnabled(false);
        }
        JLabel connL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_CONN"));
        connL.setBorder(new EmptyBorder(10, 2, 2, 2));
        mainP.add(connL);
        this.connCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_CONN_SHOW"), setting.isShowConnectionEnabled());
        this.connCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        mainP.add(this.connCB);
        JLabel zoneL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_ZONE"));
        zoneL.setBorder(new EmptyBorder(10, 2, 2, 2));
        mainP.add(zoneL);
        this.zoneCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_ZONE_SHOW"), setting.isShowZoneEnabled());
        this.zoneCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        mainP.add(this.zoneCB);
        JPanel buttonP = new JPanel();
        buttonP.setBorder(new EmptyBorder(10, 2, 2, 2));
        TopoLayoutUtilities.HorizontalLayout layout2 = new TopoLayoutUtilities.HorizontalLayout();
        layout2.setHorizontalJustify(4);
        buttonP.setLayout(layout2);
        content.add((Component)buttonP, "South");
        JButton okB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_OK"));
        okB.addActionListener(new PostAction(controllerApp));
        buttonP.add(okB);
        JButton cancelB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_CANCEL"));
        cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTopoDialogGlobalSetting.this.dispose();
            }
        });
        buttonP.add(cancelB);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private class PostAction
    implements ActionListener {
        private ControllerApp controllerApp;

        public PostAction(ControllerApp controllerApp) {
            this.controllerApp = controllerApp;
        }

        public void actionPerformed(ActionEvent e) {
            boolean anychange = false;
            TopoSetting setting = this.controllerApp.getTopoSetting();
            boolean b = JTopoDialogGlobalSetting.this.healthCB.isSelected();
            if (b != setting.isOverlayHealthEnabled()) {
                setting.setOverlayHealthEnabled(b);
                this.controllerApp.setOverlayHealthEnabled(b);
                anychange = true;
            }
            if ((b = JTopoDialogGlobalSetting.this.perfCB.isSelected()) != setting.isOverlayPerfEnabled()) {
                setting.setOverlayPerfEnabled(b);
                this.controllerApp.setOverlayPerfEnabled(b);
                anychange = true;
            }
            int filteringLevel = JTopoDialogGlobalSetting.this.filteringCB.isSelected() ? (JTopoDialogGlobalSetting.this.filteringCondCB.isSelected() ? 1 : 2) : 0;
            if (filteringLevel != setting.getFilteringLevel()) {
                setting.setFilteringLevel(filteringLevel);
                this.controllerApp.setFilteringLevel(filteringLevel);
                anychange = true;
            }
            if ((b = JTopoDialogGlobalSetting.this.connCB.isSelected()) != setting.isShowConnectionEnabled()) {
                setting.setShowConnectionEnabled(b);
                this.controllerApp.setShowConnectionEnabled(b);
                anychange = true;
            }
            if ((b = JTopoDialogGlobalSetting.this.zoneCB.isSelected()) != setting.isShowZoneEnabled()) {
                setting.setShowZoneEnabled(b);
                this.controllerApp.setShowZoneEnabled(b);
                anychange = true;
            }
            JTopoDialogGlobalSetting.this.dispose();
            if (anychange) {
                this.controllerApp.getBackend().persistTopoSettings(setting);
            }
        }
    }
}

