/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoDialogRefreshSetting
extends JDialog {
    private JComboBox refreshCB;

    public JTopoDialogRefreshSetting(Frame frame, ControllerApp controllerApp) {
        super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_TITLE"), true);
        TopoSetting setting = controllerApp.getTopoSetting();
        int refreshRate = setting.getRefreshRate();
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel mainP = new JPanel();
        mainP.setBorder(new EmptyBorder(5, 5, 5, 5));
        TopoLayoutUtilities.VerticalGridLayout layout = new TopoLayoutUtilities.VerticalGridLayout(3);
        layout.setHorizontalAlignment(4);
        layout.setSpacing(5);
        mainP.setLayout(layout);
        content.add((Component)mainP, "Center");
        JLabel oldTimeoutL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_MSG1"));
        mainP.add(oldTimeoutL);
        JLabel oldTimeoutValueL = new JLabel("" + refreshRate);
        mainP.add(oldTimeoutValueL);
        JLabel oldTimeoutUnitL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_UNIT"));
        mainP.add(oldTimeoutUnitL);
        JLabel mewTimeoutL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_MSG2"));
        mainP.add(mewTimeoutL);
        this.refreshCB = new JComboBox();
        this.refreshCB.addItem("1");
        this.refreshCB.addItem("2");
        this.refreshCB.addItem("3");
        this.refreshCB.addItem("4");
        this.refreshCB.addItem("5");
        this.refreshCB.addItem("10");
        this.refreshCB.addItem("15");
        this.refreshCB.addItem("20");
        this.refreshCB.addItem("30");
        this.refreshCB.addItem("45");
        this.refreshCB.addItem("60");
        mainP.add(this.refreshCB);
        JLabel newTimeoutUnitL = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_UNIT"));
        mainP.add(newTimeoutUnitL);
        JPanel buttonP = new JPanel();
        buttonP.setBorder(new EmptyBorder(10, 2, 2, 2));
        TopoLayoutUtilities.HorizontalLayout layout2 = new TopoLayoutUtilities.HorizontalLayout();
        layout2.setHorizontalJustify(4);
        buttonP.setLayout(layout2);
        content.add((Component)buttonP, "South");
        JButton okB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_OK"));
        okB.addActionListener(new PostAction(controllerApp));
        buttonP.add(okB);
        JButton cancelB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_CANCEL"));
        cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTopoDialogRefreshSetting.this.dispose();
            }
        });
        buttonP.add(cancelB);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private class PostAction
    implements ActionListener {
        private ControllerApp controllerApp;

        public PostAction(ControllerApp controllerApp) {
            this.controllerApp = controllerApp;
        }

        public void actionPerformed(ActionEvent e) {
            TopoSetting setting = this.controllerApp.getTopoSetting();
            String s = (String)JTopoDialogRefreshSetting.this.refreshCB.getSelectedItem();
            if (s != null) {
                int newRefreshRate = Integer.parseInt(s);
                setting.setRefreshRate(newRefreshRate);
                int newTimeout = newRefreshRate * 60;
                this.controllerApp.getBackend().setTimeout(newTimeout);
            }
            JTopoDialogRefreshSetting.this.dispose();
        }
    }
}

