/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.JTopoPrintable;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoPrint {
    protected AbstractJTopoCanvas canvas;
    protected PrinterJob prnJob;
    protected PageFormat pageFormat;
    protected JTopoPrintable page1;

    public JTopoPrint(AbstractJTopoCanvas canvas) {
        this.canvas = canvas;
        this.prnJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.prnJob.defaultPage();
        Book book = new Book();
        this.prnJob.setPageable(book);
        AbstractJTopoCanvas.CanvasPanel canvasPanel = canvas.getCanvasPanel();
        this.page1 = new JTopoPrintable(canvasPanel);
        book.append(this.page1, this.pageFormat);
    }

    public void print() {
        Thread t = new Thread(){

            public void run() {
                try {
                    if (!JTopoPrint.this.prnJob.printDialog()) {
                        return;
                    }
                    JTopoPrint.this.canvas.setCursor(Cursor.getPredefinedCursor(3));
                    JTopoPrint.this.prnJob.print();
                    JTopoPrint.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public void preview() {
        Frame f = (Frame)SwingUtilities.windowForComponent(this.canvas);
        PreviewDialog preview = new PreviewDialog(f);
        preview.show();
    }

    protected class PreviewDialog
    extends JDialog {
        protected JComboBox scaleCB;
        protected JPanel previewPageContainer;
        protected PreviewPage previewPage;

        public PreviewDialog(Frame f) {
            super(f, GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_TITLE"), true);
            this.setSize(TopoResource.DIMENSION_PRINTPREVIEW);
            this.setLocation((f.getWidth() - this.getWidth()) / 2, (f.getHeight() - this.getHeight()) / 2);
            JPanel contentPanel = (JPanel)this.getContentPane();
            contentPanel.setLayout(new BorderLayout());
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new FlowLayout(0));
            contentPanel.add((Component)northPanel, "North");
            JButton printB = new JButton(GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_PRINT"));
            printB.addActionListener(new AL_Print());
            northPanel.add(printB);
            JButton closeB = new JButton(GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_CLOSE"));
            closeB.addActionListener(new AL_Close());
            northPanel.add(closeB);
            JLabel scaleL = new JLabel("  " + GuiUtil.getString("TOPO_LABEL_DIALOG_PRINTPREVIEW_SCALE") + ":");
            northPanel.add(scaleL);
            this.scaleCB = new JComboBox();
            this.scaleCB.addActionListener(new AL_Scale());
            northPanel.add(this.scaleCB);
            JLabel scale2L = new JLabel(" %");
            northPanel.add(scale2L);
            JScrollPane sp = new JScrollPane();
            contentPanel.add((Component)sp, "Center");
            this.previewPageContainer = new JPanel();
            sp.setViewportView(this.previewPageContainer);
            double scale = 1.0;
            int printW = (int)(JTopoPrint.this.pageFormat.getWidth() * scale);
            int printH = (int)(JTopoPrint.this.pageFormat.getHeight() * scale);
            BufferedImage img = new BufferedImage(printW, printH, 1);
            Graphics g = img.getGraphics();
            g.setColor(TopoResource.COLOR_BACKGROUND);
            g.fillRect(0, 0, printW, printH);
            try {
                JTopoPrint.this.page1.print(g, JTopoPrint.this.pageFormat, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.previewPage = new PreviewPage(img, scale);
            this.previewPageContainer.add(this.previewPage);
            this.scaleCB.addItem("25");
            this.scaleCB.addItem("50");
            this.scaleCB.addItem("100");
            this.scaleCB.addItem("150");
            this.scaleCB.addItem("200");
            this.scaleCB.addItem("400");
            this.scaleCB.setSelectedIndex(1);
            this.setDefaultCloseOperation(2);
        }

        protected double getScale() {
            String s = (String)this.scaleCB.getSelectedItem();
            if (s == null) {
                return -1.0;
            }
            return (double)Integer.parseInt(s) / 100.0;
        }

        protected class PreviewPage
        extends JPanel {
            protected Image original;
            protected Image scaled;
            protected double scale;

            public PreviewPage(Image img, double scale) {
                this.original = img;
                this.setScale(scale);
                this.setBorder(LineBorder.createGrayLineBorder());
            }

            public void setScale(double scale) {
                this.scale = scale;
                int w = (int)((double)this.original.getWidth(null) * scale);
                int h = (int)((double)this.original.getHeight(null) * scale);
                this.scaled = this.original.getScaledInstance(w, h, 4);
            }

            public Dimension getPreferredSize() {
                Dimension dim = new Dimension(0, 0);
                Insets insets = this.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                dim.width += this.scaled.getWidth(this);
                dim.height += this.scaled.getHeight(this);
                return dim;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                g.drawImage(this.scaled, insets.left, insets.top, this);
            }
        }

        protected class AL_Scale
        implements ActionListener {
            protected AL_Scale() {
            }

            public void actionPerformed(ActionEvent e) {
                if (PreviewDialog.this.previewPage == null) {
                    return;
                }
                double scale = PreviewDialog.this.getScale();
                PreviewDialog.this.previewPage.setScale(scale);
                PreviewDialog.this.previewPageContainer.revalidate();
                PreviewDialog.this.previewPageContainer.repaint();
            }
        }

        protected class AL_Close
        implements ActionListener {
            protected AL_Close() {
            }

            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.dispose();
            }
        }

        protected class AL_Print
        implements ActionListener {
            protected AL_Print() {
            }

            public void actionPerformed(ActionEvent e) {
                JTopoPrint.this.print();
                PreviewDialog.this.dispose();
            }
        }
    }
}

