/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewComputerL2Connectivity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxFCPortGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxHBA;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSwitchGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewComputerL2Connectivity
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewComputerL2Connectivity connectivity = (GraphSubviewComputerL2Connectivity)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(connectivity.getDisplayName());
        groupModel.setLabel(connectivity.getDisplayName());
        groupModel.setHealth(connectivity.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_FABRICGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_FABRICGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_FABRICGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int hbaTotal = connectivity.getNumOfHBAs();
        int hbaUnfiltered = connectivity.getNumOfAbnormalHBAs();
        ITopoGroupModel.Summary hbaSummary = new ITopoGroupModel.Summary(hbaTotal, hbaUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_HBA"), GuiUtil.getString("TOPO_LABEL_ENTITY_HBAS"));
        int fcportTotal = connectivity.getNumOfFCPorts();
        int fcportUnfiltered = connectivity.getNumOfAbnormalFCPorts();
        ITopoGroupModel.Summary fcportSummary = new ITopoGroupModel.Summary(fcportTotal, fcportUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"), GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORTS"));
        fcportSummary.setAuxSummary(hbaSummary);
        groupModel.addSummary(fcportSummary);
        int swTotal = connectivity.getNumOfSwitches();
        int swUnfiltered = connectivity.getNumOfAbnormalSwitches();
        groupModel.addSummary(new ITopoGroupModel.Summary(swTotal, swUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"), GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES")));
        int total = fcportTotal + swTotal;
        int unfiltered = fcportUnfiltered + swUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(connectivity.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel topPanel;
        protected JPanel hbaPanel;
        protected JPanel fcportGroupPanel;
        protected JPanel swGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.topPanel = new JPanel();
            this.topPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            LayoutManager layout = new TopoLayoutUtilities.HorizontalLayout();
            layout.setSpacing(10);
            this.topPanel.setLayout(layout);
            this.hbaPanel = new JPanel();
            this.hbaPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.SquareGridLayout();
            this.hbaPanel.setLayout(layout);
            this.topPanel.add(this.hbaPanel);
            this.fcportGroupPanel = new JPanel();
            this.fcportGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.SquareGridLayout();
            this.fcportGroupPanel.setLayout(layout);
            this.topPanel.add(this.fcportGroupPanel);
            this.swGroupPanel = new JPanel();
            this.swGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.SquareGridLayout();
            this.swGroupPanel.setLayout(layout);
            this.initState();
        }

        private void initState() {
            this.add(this.topPanel);
            this.add(this.swGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxHBA || entity instanceof JTopoBoxFCPortGroup) {
                if (entity instanceof JTopoBoxHBA) {
                    this.hbaPanel.setVisible(true);
                    this.hbaPanel.add(entity);
                } else if (entity instanceof JTopoBoxFCPortGroup) {
                    this.fcportGroupPanel.setVisible(true);
                    this.fcportGroupPanel.add(entity);
                }
                this.topPanel.setVisible(true);
            } else if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.setVisible(true);
                this.swGroupPanel.add(entity);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxHBA || entity instanceof JTopoBoxFCPortGroup) {
                if (entity instanceof JTopoBoxHBA) {
                    this.hbaPanel.remove(entity);
                    this.hbaPanel.setVisible(this.hbaPanel.getComponentCount() > 0);
                } else if (entity instanceof JTopoBoxFCPortGroup) {
                    this.fcportGroupPanel.remove(entity);
                    this.fcportGroupPanel.setVisible(this.fcportGroupPanel.getComponentCount() > 0);
                }
                this.topPanel.setVisible(this.hbaPanel.isVisible() || this.fcportGroupPanel.isVisible());
            } else if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.remove(entity);
                this.swGroupPanel.setVisible(this.swGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.hbaPanel.removeAll();
            this.hbaPanel.setVisible(false);
            this.fcportGroupPanel.removeAll();
            this.fcportGroupPanel.setVisible(false);
            this.swGroupPanel.removeAll();
            this.swGroupPanel.setVisible(false);
            this.topPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(10);
                this.setAlignment(0);
            }
        }
    }
}

