/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnGroup;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnRegular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoTableHBA
extends AbstractJTopoTable {
    public JTopoTableHBA() {
        this.tableColumnModel = new DefaultTopoTableColumnModel();
        int columnCount = 0;
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_LOCATED", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_HEALTH", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnGroup(columnCount++));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_LABEL", 150));
        if (GraphDebug.isInfoVisible()) {
            this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_DEBUG", 150));
        }
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_OPERATIONALSTATUS"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_WWN", 150));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_VENDOR"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_MODEL"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_SERIAL"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_FIRMWAREVERSION"));
        this.table.setColumnModel(this.tableColumnModel);
        this.tableModel = new DefaultTopoTableModel(this.tableColumnModel);
        this.table.setModel(this.tableModel);
        this.arrangeRecordGroup = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_GROUP", true);
        this.arrangeRecord = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_LABEL", true);
    }

    protected void reattach() {
        DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
        tableModel.removeAll();
        if (this.dataModel == null) {
            return;
        }
        DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
        Enumeration enu = this.dataModel.enumerate(GraphHBA.TYPE);
        while (enu.hasMoreElements()) {
            GraphHBA hba = (GraphHBA)enu.nextElement();
            GraphHBA.ID hbaID = (GraphHBA.ID)hba.getEntityID();
            if (Boolean.TRUE.equals(hba.getIsFilterable())) continue;
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(hbaID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(hba.getHealthStatus()), hba.getHealthStatus(), TopoResource.getIconHealth(hba.getHealthStatus())));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GuiUtil.getString("TOPO_LABEL_COMMON_NA"))));
            member.addData(new JCustomRendererTable.CollatorCell(hba.getDisplayName(), hba.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)hba.getEntityID().getID().toString())));
            }
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GraphModelUtilities.getOperationalStatus(hba.getOperationalStatus()))));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)hba.getWWN())));
            String vendor = hba.getVendor();
            if ("UNKNOWN".equalsIgnoreCase(vendor)) {
                vendor = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
            }
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)vendor)));
            String model = hba.getModel();
            if ("UNKNOWN".equalsIgnoreCase(model)) {
                model = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
            }
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)model)));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)hba.getSerialNumber())));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)hba.getFirmwareVersion())));
        }
        this.arrange();
    }
}

