/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnGroup;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnRegular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoTableOverview
extends AbstractJTopoTable {
    public JTopoTableOverview() {
        this.tableColumnModel = new DefaultTopoTableColumnModel();
        int columnCount = 0;
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_LOCATED", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_HEALTH", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnGroup(columnCount++, "TOPO_LABEL_ATTR_COMMON_LABEL", 150));
        if (GraphDebug.isInfoVisible()) {
            this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_DEBUG", 150));
        }
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_SUMMARY", 300));
        this.table.setColumnModel(this.tableColumnModel);
        this.tableModel = new DefaultTopoTableModel(this.tableColumnModel);
        this.table.setModel(this.tableModel);
    }

    protected void reattach() {
        DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
        TopoSetting setting = this.tabular.getControllerView().getControllerApp().getTopoSetting();
        int filteringLevel = setting.getFilteringLevel();
        tableModel.removeAll();
        if (this.dataModel == null) {
            return;
        }
        DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
        Enumeration fabricSummaryEnu = this.dataModel.enumerate(GraphFabricSummary.TYPE);
        while (fabricSummaryEnu.hasMoreElements()) {
            GraphFabricSummary fabricSummary = (GraphFabricSummary)fabricSummaryEnu.nextElement();
            GraphFabricSummary.ID fabricSummaryID = (GraphFabricSummary.ID)fabricSummary.getEntityID();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(fabricSummaryID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(fabricSummary.getHealthStatus()), fabricSummary.getHealthStatus(), TopoResource.getIconHealth(fabricSummary.getHealthStatus())));
            member.addData(new JCustomRendererTable.CollatorCell(fabricSummary.getDisplayName(), fabricSummary.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)fabricSummary.getEntityID().getID().toString())));
            }
            int totalFabric = fabricSummary.getNumOfFabrics();
            int unfilteredlFabric = 0;
            String countStrFabric = "" + totalFabric;
            if (filteringLevel != 0) {
                unfilteredlFabric = fabricSummary.getNumOfAbnormalFabrics();
                countStrFabric = unfilteredlFabric + " / " + countStrFabric;
            }
            String countStrFullFabric = countStrFabric + " " + (totalFabric == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC") : GuiUtil.getString("TOPO_LABEL_ENTITY_FABRICS"));
            int totalVirtualFabric = fabricSummary.getNumOfVirtualFabrics();
            int unfilteredVirtualFabric = 0;
            String countStrVirtualFabric = "" + totalVirtualFabric;
            if (filteringLevel != 0) {
                unfilteredVirtualFabric = fabricSummary.getNumOfAbnormalVirtualFabrics();
                countStrVirtualFabric = unfilteredVirtualFabric + " / " + countStrVirtualFabric;
            }
            String countStrFullVirtualFabric = countStrVirtualFabric + " " + (totalVirtualFabric == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_VIRTUALFABRIC") : GuiUtil.getString("TOPO_LABEL_ENTITY_VIRTUALFABRICS"));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)(countStrFullFabric + " (" + countStrFullVirtualFabric + ")"))));
        }
        Enumeration computerSummaryEnu = this.dataModel.enumerate(GraphComputerSummary.TYPE);
        while (computerSummaryEnu.hasMoreElements()) {
            GraphComputerSummary computerSummary = (GraphComputerSummary)computerSummaryEnu.nextElement();
            GraphComputerSummary.ID computerSummaryID = (GraphComputerSummary.ID)computerSummary.getEntityID();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(computerSummaryID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(computerSummary.getHealthStatus()), computerSummary.getHealthStatus(), TopoResource.getIconHealth(computerSummary.getHealthStatus())));
            member.addData(new JCustomRendererTable.CollatorCell(computerSummary.getDisplayName(), computerSummary.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)computerSummary.getEntityID().getID().toString())));
            }
            int total = computerSummary.getNumOfComputers();
            int unfiltered = 0;
            String countStr = "" + total;
            if (filteringLevel != 0) {
                unfiltered = computerSummary.getNumOfAbnormalComputers();
                countStr = unfiltered + " / " + countStr;
            }
            String countStrFull = countStr + " " + (total == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER") : GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTERS"));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)countStrFull)));
        }
        Enumeration swSummaryEnu = this.dataModel.enumerate(GraphSwitchSummary.TYPE);
        while (swSummaryEnu.hasMoreElements()) {
            GraphSwitchSummary swSummary = (GraphSwitchSummary)swSummaryEnu.nextElement();
            GraphSwitchSummary.ID swSummaryID = (GraphSwitchSummary.ID)swSummary.getEntityID();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(swSummaryID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(swSummary.getHealthStatus()), swSummary.getHealthStatus(), TopoResource.getIconHealth(swSummary.getHealthStatus())));
            member.addData(new JCustomRendererTable.CollatorCell(swSummary.getDisplayName(), swSummary.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)swSummary.getEntityID().getID().toString())));
            }
            int total = swSummary.getNumOfSwitches();
            int unfiltered = 0;
            String countStr = "" + total;
            if (filteringLevel != 0) {
                unfiltered = swSummary.getNumOfAbnormalSwitches();
                countStr = unfiltered + " / " + countStr;
            }
            String countStrFull = countStr + " " + (total == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH") : GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES"));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)countStrFull)));
        }
        Enumeration storageSummaryEnu = this.dataModel.enumerate(GraphStorageSummary.TYPE);
        while (storageSummaryEnu.hasMoreElements()) {
            GraphStorageSummary storageSummary = (GraphStorageSummary)storageSummaryEnu.nextElement();
            GraphStorageSummary.ID storageSummaryID = (GraphStorageSummary.ID)storageSummary.getEntityID();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(storageSummaryID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(storageSummary.getHealthStatus()), storageSummary.getHealthStatus(), TopoResource.getIconHealth(storageSummary.getHealthStatus())));
            member.addData(new JCustomRendererTable.CollatorCell(storageSummary.getDisplayName(), storageSummary.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)storageSummary.getEntityID().getID().toString())));
            }
            int totalSubsystem = storageSummary.getNumOfSubsystems();
            int unfilteredSubsystem = 0;
            String countStrSubsystem = "" + totalSubsystem;
            if (filteringLevel != 0) {
                unfilteredSubsystem = storageSummary.getNumOfAbnormalSubsystems();
                countStrSubsystem = unfilteredSubsystem + " / " + countStrSubsystem;
            }
            String countStrFullSubsystem = countStrSubsystem + " " + (totalSubsystem == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM") : GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEMS"));
            int totalTapeLibrary = storageSummary.getNumOfTapeLibraries();
            int unfilteredTapeLibrary = 0;
            String countStrTapeLibrary = "" + totalTapeLibrary;
            if (filteringLevel != 0) {
                unfilteredTapeLibrary = storageSummary.getNumOfAbnormalTapeLibraries();
                countStrTapeLibrary = unfilteredTapeLibrary + " / " + countStrTapeLibrary;
            }
            String countStrFullTapeLibrary = countStrTapeLibrary + " " + (totalTapeLibrary == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY") : GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARIES"));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)(countStrFullSubsystem + ", " + countStrFullTapeLibrary))));
        }
        Enumeration otherSummaryEnu = this.dataModel.enumerate(GraphOtherSummary.TYPE);
        while (otherSummaryEnu.hasMoreElements()) {
            GraphOtherSummary otherSummary = (GraphOtherSummary)otherSummaryEnu.nextElement();
            GraphOtherSummary.ID otherSummaryID = (GraphOtherSummary.ID)otherSummary.getEntityID();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(otherSummaryID);
            root.addMember(member);
            member.addData(new JCustomRendererTable.StatusCell(null, null, null));
            member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(otherSummary.getHealthStatus()), otherSummary.getHealthStatus(), TopoResource.getIconHealth(otherSummary.getHealthStatus())));
            member.addData(new JCustomRendererTable.CollatorCell(otherSummary.getDisplayName(), otherSummary.getCollationKey()));
            if (GraphDebug.isInfoVisible()) {
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)otherSummary.getEntityID().getID().toString())));
            }
            int total = otherSummary.getNumOfOthers();
            int unfiltered = 0;
            String countStr = "" + total;
            if (filteringLevel != 0) {
                unfiltered = otherSummary.getNumOfAbnormalOthers();
                countStr = unfiltered + " / " + countStr;
            }
            String countStrFull = countStr + " " + (total == 1 ? GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER") : GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER"));
            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)countStrFull)));
        }
        tableModel.resetRowIndex();
        tableModel.fireTableDataChanged();
        this.table.getTableHeader().repaint();
    }
}

