/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasStorageL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL2;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularStorageL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL2;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class JTopoView
extends AbstractJTopoBase {
    protected ControllerView controllerView;
    protected GraphModel dataModel;
    protected JSplitPane split;
    protected AbstractJTopoCanvas canvas;
    protected JTopoMiniMap miniMap;
    protected AbstractJTopoTabular tabular;
    protected boolean refreshInProgress;
    protected Object refreshInProgressLock;
    protected InvalidPanel invalidPanel;
    protected String viewTitle;
    protected Integer viewStatus;

    public JTopoView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, constructor");
        }
        this.setLayout(this.createDefaultLayout());
        this.split = new JSplitPane(0);
        this.split.setDividerSize(5);
        this.split.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (JTopoView.this.dataModel != null && !JTopoView.this.dataModel.isEmpty()) {
                    double ratio = (double)JTopoView.this.split.getDividerLocation() / (double)JTopoView.this.split.getHeight();
                    TopoSetting setting = JTopoView.this.controllerView.getControllerApp().getTopoSetting();
                    TopoSetting.SettingPerViewType settingPerViewType = setting.getSettingPerViewType(JTopoView.this.dataModel.getModelID().getFocusLevel());
                    settingPerViewType.setSplitRatio(ratio);
                }
            }
        });
        this.add(this.split);
        this.refreshInProgressLock = new Object();
        this.invalidPanel = new InvalidPanel();
        this.initState();
    }

    private void initState() {
        this.controllerView = null;
        this.dataModel = null;
        this.split.setTopComponent(null);
        this.split.setBottomComponent(null);
        this.canvas = null;
        this.miniMap = null;
        this.tabular = null;
        this.refreshInProgress = false;
        this.viewTitle = null;
        this.viewStatus = null;
        this.setEnabled(true);
    }

    public void resetState() {
        WidgetPool widgetPool = WidgetPool.getInstance();
        widgetPool.recycleWidget(this.canvas);
        widgetPool.recycleWidget(this.miniMap);
        widgetPool.recycleWidget(this.tabular);
        this.initState();
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        GraphModel.ID modelID = controllerView.getModelID();
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setSessionModel(), modelID=" + modelID + ", controllerView=" + controllerView);
        }
        this.controllerView = controllerView;
        this.canvas = this.createCanvas(modelID);
        this.split.setTopComponent(this.canvas);
        this.miniMap = this.createMiniMap(this.canvas);
        this.tabular = this.createTabular(modelID);
        this.split.setBottomComponent(this.tabular);
        this.canvas.setSessionModel(controllerView);
        this.tabular.setSessionModel(controllerView);
    }

    public GraphModel getDtataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel dataModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setDataModel(), modelID=" + dataModel.getModelID());
        }
        if (dataModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("JTopoView.setDataModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = dataModel;
        GraphModel.ID modelID = dataModel.getModelID();
        String focusLevel = modelID.getFocusLevel();
        String title = GraphModelUtilities.getViewAlias(focusLevel);
        GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
        if (focusEntityID != null) {
            GraphEntity focusEntity = dataModel.get(focusEntityID);
            String ss = null;
            ss = focusEntity != null ? focusEntity.getDisplayName() : focusEntityID.getID().toString();
            if (ss.length() > 6) {
                ss = ss.substring(0, 6) + "...";
            }
            title = title + "-" + ss;
        }
        this.setTitle(title);
        this.setStatus(null);
        this.canvas.setDataModel(dataModel);
        this.tabular.setDataModel(dataModel);
        TopoSetting setting = this.controllerView.getControllerApp().getTopoSetting();
        TopoSetting.SettingPerViewType settingPerViewType = setting.getSettingPerViewType(dataModel.getModelID().getFocusLevel());
        double ratio = settingPerViewType.getSplitRatio();
        SwingUtilities.invokeLater(new SplitDividerLocation(this.split, ratio));
        this.updateContainer();
    }

    protected void reattach() {
    }

    public JSplitPane getSplitPane() {
        return this.split;
    }

    public AbstractJTopoCanvas getCanvas() {
        return this.canvas;
    }

    public AbstractJTopoTabular getTabular() {
        return this.tabular;
    }

    public JTopoMiniMap getMiniMap() {
        return this.miniMap;
    }

    protected AbstractJTopoCanvas createCanvas(GraphModel.ID modelID) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, createCanvas(), modelID=" + modelID);
        }
        String focusLevel = modelID.getFocusLevel();
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoCanvas c = null;
        if ("Overview".equals(focusLevel)) {
            c = (JTopoCanvasOverview)widgetPool.getWidget(JTopoCanvasOverview.class);
        } else if ("FabricL0".equals(focusLevel)) {
            c = (JTopoCanvasFabricL0)widgetPool.getWidget(JTopoCanvasFabricL0.class);
        } else if ("FabricL2".equals(focusLevel)) {
            c = (JTopoCanvasFabricL2)widgetPool.getWidget(JTopoCanvasFabricL2.class);
        } else if ("ComputerL0".equals(focusLevel)) {
            c = (JTopoCanvasComputerL0)widgetPool.getWidget(JTopoCanvasComputerL0.class);
        } else if ("ComputerL1".equals(focusLevel)) {
            c = (JTopoCanvasComputerL1)widgetPool.getWidget(JTopoCanvasComputerL1.class);
        } else if ("ComputerL2".equals(focusLevel)) {
            c = (JTopoCanvasComputerL2)widgetPool.getWidget(JTopoCanvasComputerL2.class);
        } else if ("SwitchL0".equals(focusLevel)) {
            c = (JTopoCanvasSwitchL0)widgetPool.getWidget(JTopoCanvasSwitchL0.class);
        } else if ("SwitchL1".equals(focusLevel)) {
            c = (JTopoCanvasSwitchL1)widgetPool.getWidget(JTopoCanvasSwitchL1.class);
        } else if ("SwitchL2".equals(focusLevel)) {
            c = (JTopoCanvasSwitchL2)widgetPool.getWidget(JTopoCanvasSwitchL2.class);
        } else if ("StorageL0".equals(focusLevel)) {
            c = (JTopoCanvasStorageL0)widgetPool.getWidget(JTopoCanvasStorageL0.class);
        } else if ("SubsystemL1".equals(focusLevel)) {
            c = (JTopoCanvasSubsystemL1)widgetPool.getWidget(JTopoCanvasSubsystemL1.class);
        } else if ("SubsystemL2".equals(focusLevel)) {
            c = (JTopoCanvasSubsystemL2)widgetPool.getWidget(JTopoCanvasSubsystemL2.class);
        } else if ("TapeLibraryL1".equals(focusLevel)) {
            c = (JTopoCanvasTapeLibraryL1)widgetPool.getWidget(JTopoCanvasTapeLibraryL1.class);
        } else if ("TapeLibraryL2".equals(focusLevel)) {
            c = (JTopoCanvasTapeLibraryL2)widgetPool.getWidget(JTopoCanvasTapeLibraryL2.class);
        } else if ("OtherL0".equals(focusLevel)) {
            c = (JTopoCanvasOtherL0)widgetPool.getWidget(JTopoCanvasOtherL0.class);
        } else if ("OtherL1".equals(focusLevel)) {
            c = (JTopoCanvasOtherL1)widgetPool.getWidget(JTopoCanvasOtherL1.class);
        } else if ("OtherL2".equals(focusLevel)) {
            c = (JTopoCanvasOtherL2)widgetPool.getWidget(JTopoCanvasOtherL2.class);
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("JTopoViewer, createCanvas(), invalid focusLevel=" + focusLevel);
        }
        return c;
    }

    protected JTopoMiniMap createMiniMap(AbstractJTopoCanvas c) {
        WidgetPool widgetPool = WidgetPool.getInstance();
        JTopoMiniMap m = (JTopoMiniMap)widgetPool.getWidget(JTopoMiniMap.class);
        m.setDataModel(c);
        return m;
    }

    protected AbstractJTopoTabular createTabular(GraphModel.ID modelID) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, createTabular(), modelID=" + modelID);
        }
        String focusLevel = modelID.getFocusLevel();
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoTabular t = null;
        if ("Overview".equals(focusLevel)) {
            t = (JTopoTabularOverview)widgetPool.getWidget(JTopoTabularOverview.class);
        } else if ("FabricL0".equals(focusLevel)) {
            t = (JTopoTabularFabricL0)widgetPool.getWidget(JTopoTabularFabricL0.class);
        } else if ("FabricL2".equals(focusLevel)) {
            t = (JTopoTabularFabricL2)widgetPool.getWidget(JTopoTabularFabricL2.class);
        } else if ("ComputerL0".equals(focusLevel)) {
            t = (JTopoTabularComputerL0)widgetPool.getWidget(JTopoTabularComputerL0.class);
        } else if ("ComputerL1".equals(focusLevel)) {
            t = (JTopoTabularComputerL1)widgetPool.getWidget(JTopoTabularComputerL1.class);
        } else if ("ComputerL2".equals(focusLevel)) {
            t = (JTopoTabularComputerL2)widgetPool.getWidget(JTopoTabularComputerL2.class);
        } else if ("SwitchL0".equals(focusLevel)) {
            t = (JTopoTabularSwitchL0)widgetPool.getWidget(JTopoTabularSwitchL0.class);
        } else if ("SwitchL1".equals(focusLevel)) {
            t = (JTopoTabularSwitchL1)widgetPool.getWidget(JTopoTabularSwitchL1.class);
        } else if ("SwitchL2".equals(focusLevel)) {
            t = (JTopoTabularSwitchL2)widgetPool.getWidget(JTopoTabularSwitchL2.class);
        } else if ("StorageL0".equals(focusLevel)) {
            t = (JTopoTabularStorageL0)widgetPool.getWidget(JTopoTabularStorageL0.class);
        } else if ("SubsystemL1".equals(focusLevel)) {
            t = (JTopoTabularSubsystemL1)widgetPool.getWidget(JTopoTabularSubsystemL1.class);
        } else if ("SubsystemL2".equals(focusLevel)) {
            t = (JTopoTabularSubsystemL2)widgetPool.getWidget(JTopoTabularSubsystemL2.class);
        } else if ("TapeLibraryL1".equals(focusLevel)) {
            t = (JTopoTabularTapeLibraryL1)widgetPool.getWidget(JTopoTabularTapeLibraryL1.class);
        } else if ("TapeLibraryL2".equals(focusLevel)) {
            t = (JTopoTabularTapeLibraryL2)widgetPool.getWidget(JTopoTabularTapeLibraryL2.class);
        } else if ("OtherL0".equals(focusLevel)) {
            t = (JTopoTabularOtherL0)widgetPool.getWidget(JTopoTabularOtherL0.class);
        } else if ("OtherL1".equals(focusLevel)) {
            t = (JTopoTabularOtherL1)widgetPool.getWidget(JTopoTabularOtherL1.class);
        } else if ("OtherL2".equals(focusLevel)) {
            t = (JTopoTabularOtherL2)widgetPool.getWidget(JTopoTabularOtherL2.class);
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("JTopoViewer, createTabular(), invalid focusLevel=" + focusLevel);
        }
        return t;
    }

    public String getTitle() {
        return this.viewTitle;
    }

    public void setTitle(String viewTitle) {
        this.viewTitle = viewTitle;
        this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup().setViewTitle(this, viewTitle);
    }

    public Integer getStatus() {
        return this.viewStatus;
    }

    public void setStatus(Integer viewStatus) {
        this.viewStatus = viewStatus;
        this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup().setViewStatus(this, viewStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRefreshInProgress() {
        Object object = this.refreshInProgressLock;
        synchronized (object) {
            return this.refreshInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshInProgress(boolean b) {
        Object object = this.refreshInProgressLock;
        synchronized (object) {
            this.refreshInProgress = b;
        }
    }

    public void setEnabled(boolean enabled) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setEnabled(), enabled=" + enabled);
        }
        this.remove(this.invalidPanel);
        if (!enabled) {
            this.add((Component)this.invalidPanel, 0);
        }
        super.setEnabled(enabled);
        if (this.miniMap != null) {
            this.miniMap.setEnabled(enabled);
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected DefaultLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = parent.getWidth() - insets.left - insets.right;
            int h = parent.getHeight() - insets.top - insets.bottom;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setBounds(x, y, w, h);
            }
        }
    }

    protected class InvalidPanel
    extends JPanel {
        public InvalidPanel() {
            this.setBackground(new Color(255, 255, 255, 200));
            this.addMouseListener(new DummyMouseAdapter());
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(TopoResource.COLOR_MISSING);
            g2D.setFont(TopoResource.FONT_CANVASPANELCONTAINER);
            g2D.drawString(GuiUtil.getString("TOPO_LABEL_VIEW_INVALID"), 0, 70);
        }

        protected class DummyMouseAdapter
        extends MouseAdapter {
            protected DummyMouseAdapter() {
            }
        }
    }

    private class SplitDividerLocation
    implements Runnable {
        private JSplitPane split;
        private double ratio;

        public SplitDividerLocation(JSplitPane split, double ratio) {
            this.split = split;
            this.ratio = ratio;
        }

        public void run() {
            this.split.setDividerLocation((int)(this.ratio * (double)this.split.getHeight()));
            this.split.setResizeWeight(this.ratio);
        }
    }
}

