/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;

public class TopoUtilities {
    public static boolean expand(AbstractJTopoEntity widget) {
        if (widget == null) {
            return false;
        }
        AbstractJTopoEntity m = widget;
        AbstractJTopoEntity parent = null;
        boolean needRevalidate = false;
        try {
            while ((parent = m.getLogicalParent()) != null) {
                AbstractJTopoGroup group;
                if (parent instanceof AbstractJTopoGroup && !(group = (AbstractJTopoGroup)parent).isExpanded()) {
                    group.setExpanded(true);
                    needRevalidate = true;
                }
                m = parent;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (needRevalidate) {
            m.revalidate();
            m.repaint();
        }
        return needRevalidate;
    }

    public static void focus(AbstractJTopoEntity widget, AbstractJTopoCanvas canvas) {
        Point p = SwingUtilities.convertPoint(widget.getParent(), widget.getLocation(), canvas.getCanvasPanel());
        Dimension d = canvas.getViewport().getExtentSize();
        Point old = canvas.getViewPosition();
        Rectangle r = new Rectangle(old.x, old.y, d.width, d.height);
        int offset = 50;
        if (r.width > offset * 2) {
            r.x += offset;
            r.width -= offset * 2;
        }
        if (r.height > offset * 2) {
            r.y += offset;
            r.height -= offset * 2;
        }
        if (!r.contains(p)) {
            p.x -= d.width / 2;
            p.y -= d.height / 2;
            canvas.setViewPosition(p);
        }
    }

    public static void dumpComponentTree(Container comp) {
        for (Container c = comp; c != null; c = c.getParent()) {
            System.out.println(c);
        }
    }

    public static boolean contain(Container container, Component comp) {
        Component[] comps = container.getComponents();
        for (int j = 0; j < comps.length; ++j) {
            if (comps[j] != comp) continue;
            return true;
        }
        return false;
    }
}

