/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.guid;

import java.io.Serializable;
import org.eclipse.aperi.guid.impl.GUIDImpl;

public class GUID
implements Serializable {
    static final long serialVersionUID = 8852999985820224541L;
    private GUIDImpl guidImpl;

    public static GUID readGUID() {
        return new GUID(GUIDImpl.readGUID());
    }

    private GUID(GUIDImpl impl) {
        this.guidImpl = impl;
    }

    public GUID(String dottedGUID) throws Exception {
        this.guidImpl = new GUIDImpl(dottedGUID);
    }

    public GUID(String undottedGUID, int dummy) {
        this.guidImpl = new GUIDImpl(undottedGUID, dummy);
    }

    public String toString() {
        return this.guidImpl.toString();
    }

    public String toNoDotString() {
        return this.guidImpl.toNoDotString();
    }

    public String toJava15String() {
        return this.guidImpl.toJava15String();
    }

    public byte[] toByteArray() {
        return this.guidImpl.toByteArray();
    }

    public static void main(String[] argv) {
        try {
            GUID.testDottedGUID();
            GUID.testUndottedGUID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testDottedGUID() throws Exception {
        String in = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String j15 = "44bdbe51-ce67-11da-816e-000d606f7fc9";
        String dots = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String nodots = "44bdbe51ce6711da816e000d606f7fc9";
        short[] bytes = new short[]{68, 189, 190, 81, 206, 103, 17, 218, 129, 110, 0, 13, 96, 111, 127, 201};
        GUID guid = new GUID(in);
        System.out.println("Test dots constructor for " + in);
        if (!guid.toJava15String().equals(j15)) {
            throw new Exception("test FAILED");
        }
        System.out.println("j15    PASSED: " + j15);
        if (!guid.toString().equals(dots)) {
            throw new Exception("test FAILED");
        }
        System.out.println("dots   PASSED: " + dots);
        if (!guid.toNoDotString().equals(nodots)) {
            throw new Exception("test FAILED");
        }
        System.out.println("nodots PASSED: " + nodots);
        byte[] b = guid.toByteArray();
        for (int i = 0; i < b.length; ++i) {
            if ((b[i] & 0xFF) == (bytes[i] & 0xFF)) continue;
            throw new Exception("Test FAILED " + b[i] + " != " + (bytes[i] & 0xFF));
        }
        System.out.println("toByteArray() PASSED");
        System.out.println("");
    }

    private static void testUndottedGUID() throws Exception {
        String in = "44bdbe51ce6711da816e000d606f7fc9";
        String j15 = "44bdbe51-ce67-11da-816e-000d606f7fc9";
        String dots = "44.bd.be.51.ce.67.11.da.81.6e.00.0d.60.6f.7f.c9";
        String nodots = "44bdbe51ce6711da816e000d606f7fc9";
        short[] bytes = new short[]{68, 189, 190, 81, 206, 103, 17, 218, 129, 110, 0, 13, 96, 111, 127, 201};
        GUID guid = new GUID(in, 1);
        System.out.println("Test no dots constructor for " + in);
        if (!guid.toJava15String().equals(j15)) {
            throw new Exception("test FAILED");
        }
        System.out.println("j15    PASSED: " + j15);
        if (!guid.toString().equals(dots)) {
            throw new Exception("test FAILED");
        }
        System.out.println("dots   PASSED: " + dots);
        if (!guid.toNoDotString().equals(nodots)) {
            throw new Exception("test FAILED");
        }
        System.out.println("nodots PASSED: " + nodots);
        byte[] b = guid.toByteArray();
        for (int i = 0; i < b.length; ++i) {
            if ((b[i] & 0xFF) == (bytes[i] & 0xFF)) continue;
            throw new Exception("Test FAILED " + b[i] + " != " + (bytes[i] & 0xFF));
        }
        System.out.println("toByteArray() PASSED");
        System.out.println("");
    }
}

