/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.identity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class MainframeLinuxHWID {
    public static boolean underVM;
    private static final String PROC_CPUINFO = "/proc/cpuinfo";
    private static final long MIN_VM_IDENT = 0xFF0000000000L;
    private static final String CPINT = "cpint";
    private static final String PROC_DEVICES = "/proc/devices";
    private static final String SLASH_DEV = "/dev";
    private static final String QUERY_USERID = "QUERY USERID";
    private static final String[] cpuIdentTags;
    private static final int[] cpuIdentFieldNumbers;
    private static final String[] devSymLinks;
    private static final int[] devFileMinorNumbers;

    private static native boolean isModuleLoaded(String var0) throws LocalizableException;

    private static native void mknod(String var0, int var1, int var2, boolean var3) throws LocalizableException;

    private static native void makeSymbolicLink(String var0, String var1) throws LocalizableException;

    private static native String issueCPCmd(String var0) throws LocalizableException;

    private static long getCPUID() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(MainframeLinuxHWID.class.getName(), "getCPUID", "");
        }
        FileReader reader = null;
        try {
            reader = new FileReader(PROC_CPUINFO);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getCPUID", e);
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
            }
            throw new NestableException("GEN0029E", null, e);
        }
        BufferedReader in = new BufferedReader(reader);
        NestableException exception = null;
        String line = null;
        try {
            while ((line = in.readLine()) != null && !line.startsWith("processor ")) {
            }
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getCPUID", e);
            }
            Object[] parms = new Object[]{PROC_CPUINFO};
            exception = new NestableException("GEN0133E", parms, e);
        }
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (exception != null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
            }
            throw exception;
        }
        in = null;
        reader = null;
        if (line == null) {
            Object[] parms = new Object[]{PROC_CPUINFO};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
            }
            throw new LocalizableException("GEN0135E", parms);
        }
        List list = Util.splitLine(line, 0);
        int i = list.size();
        if (i < 11) {
            Object[] parms = new Object[]{line, "11"};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
            }
            throw new LocalizableException("GEN0202E", parms);
        }
        String[] fields = new String[i];
        list.toArray(fields);
        for (i = 0; i < cpuIdentTags.length; ++i) {
            int fieldNumber = cpuIdentFieldNumbers[i];
            if (fields[fieldNumber].equals(cpuIdentTags[i])) continue;
            Object[] parms = new Object[]{line, new Integer(fieldNumber), cpuIdentTags[i]};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
            }
            throw new LocalizableException("GEN0203E", parms);
        }
        long[] components = new long[3];
        for (i = 0; i < components.length; ++i) {
            int fieldNumber = cpuIdentFieldNumbers[i] + 2;
            String hexString = fields[fieldNumber];
            if (hexString.endsWith(",")) {
                hexString = hexString.substring(0, hexString.length() - 1);
            }
            try {
                components[i] = Long.parseLong(hexString, 16);
                continue;
            }
            catch (NumberFormatException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getCPUID", e);
                }
                Object[] parms = new Object[]{line, new Integer(fieldNumber)};
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID");
                }
                throw new LocalizableException("GEN0204E", parms);
            }
        }
        long traceResult = components[0] << 40 | components[1] << 16 | components[2];
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getCPUID", traceResult);
        }
        return traceResult;
    }

    private static String getVMUser() throws LocalizableException {
        String line;
        List list;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(MainframeLinuxHWID.class.getName(), "getVMUser", "");
        }
        if (!MainframeLinuxHWID.isModuleLoaded(CPINT)) {
            File file;
            int i;
            String s;
            Process insmod = null;
            String[] argv = new String[]{"/sbin/modprobe", CPINT};
            try {
                insmod = Runtime.getRuntime().exec(argv);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getVMUser", e);
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
                }
                Object[] parms = new Object[]{argv[0]};
                throw new NestableException("AGT0116E", parms, e);
            }
            InputStreamReader x = new InputStreamReader(insmod.getErrorStream());
            BufferedReader in = new BufferedReader(x);
            StringBuffer buf = new StringBuffer(200);
            try {
                while ((s = in.readLine()) != null) {
                    buf.append(s);
                    buf.append('\n');
                }
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getVMUser", e);
                }
                MessageLog.logException("AGT0016E", e);
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                insmod.waitFor();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            int exitCode = insmod.exitValue();
            if (exitCode != 0) {
                String number = Integer.toString(exitCode);
                Object[] parms = new Object[]{argv[0], number, buf.toString()};
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
                }
                throw new LocalizableException("GEN0205E", parms);
            }
            FileReader reader = null;
            try {
                reader = new FileReader(PROC_DEVICES);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getVMUser", e);
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
                }
                throw new NestableException("GEN0029E", null, e);
            }
            int major = -1;
            LocalizableException exception = null;
            in = new BufferedReader(reader);
            block17: while (true) {
                try {
                    while (exception == null && major < 0 && (s = in.readLine()) != null) {
                        List list2 = Util.splitLine(s, 0);
                        if (list2.size() != 2 || !(s = (String)list2.get(1)).equals(CPINT)) continue;
                        s = (String)list2.get(0);
                        try {
                            major = Integer.parseInt(s);
                            continue block17;
                        }
                        catch (NumberFormatException e) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getVMUser", e);
                            }
                            Object[] arr = new Object[]{CPINT};
                            exception = new LocalizableException("GEN0207E", arr);
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(MainframeLinuxHWID.class.getName(), "getVMUser", e);
                    }
                    Object[] parms = new Object[]{PROC_DEVICES};
                    exception = new NestableException("GEN0133E", parms, e);
                    break;
                }
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (exception != null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
                }
                throw exception;
            }
            if (major < 0) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
                }
                Object[] parms = new Object[]{CPINT};
                throw new LocalizableException("GEN0208E", parms);
            }
            File devDir = new File(SLASH_DEV);
            String[] devFiles = devDir.list();
            for (i = 0; i < devFiles.length; ++i) {
                if (!devFiles[i].startsWith(CPINT)) continue;
                file = new File(devDir, devFiles[i]);
                file.delete();
            }
            for (i = 1; i < devSymLinks.length; ++i) {
                file = new File(devDir, devSymLinks[i]);
                file.delete();
            }
            buf.setLength(0);
            buf.append(SLASH_DEV);
            buf.append('/');
            int baseLength = buf.length();
            for (int i2 = 0; i2 < devFileMinorNumbers.length; ++i2) {
                buf.setLength(baseLength);
                buf.append(CPINT);
                buf.append(devFileMinorNumbers[i2]);
                s = buf.toString();
                MainframeLinuxHWID.mknod(s, major, devFileMinorNumbers[i2], false);
                if (devSymLinks[i2] == null) continue;
                buf.setLength(baseLength);
                buf.append(devSymLinks[i2]);
                MainframeLinuxHWID.makeSymbolicLink(s, buf.toString());
            }
        }
        if ((list = Util.splitLine(line = MainframeLinuxHWID.issueCPCmd(QUERY_USERID), 0)).size() == 0) {
            Object[] parms = new Object[]{QUERY_USERID};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser");
            }
            throw new LocalizableException("GEN0213E", parms);
        }
        String traceResult = (String)list.get(0);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(MainframeLinuxHWID.class.getName(), "getVMUser", traceResult);
        }
        return traceResult;
    }

    public static void query(HardwareID hardwareID) throws LocalizableException {
        byte[] vmUserBytes;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(MainframeLinuxHWID.class.getName(), "query", "hardwareID");
        }
        String vmUser = null;
        long cpuID = MainframeLinuxHWID.getCPUID();
        boolean bl = underVM = cpuID >= 0xFF0000000000L;
        if (underVM) {
            vmUser = MainframeLinuxHWID.getVMUser();
        }
        int totalLength = 10;
        if (vmUser == null) {
            vmUserBytes = null;
        } else {
            vmUserBytes = vmUser.getBytes();
            totalLength += vmUserBytes.length;
        }
        byte[] result = new byte[totalLength];
        result[0] = 83;
        result[1] = 51;
        result[2] = 57;
        result[3] = 48;
        for (int i = 0; i < 6; ++i) {
            result[4 + i] = (byte)cpuID;
            cpuID >>= 8;
        }
        if (vmUserBytes != null) {
            System.arraycopy(vmUserBytes, 0, result, 10, vmUserBytes.length);
        }
        hardwareID.hardwareID = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(MainframeLinuxHWID.class.getName(), "query");
        }
    }

    static {
        cpuIdentTags = new String[]{"version", "identification", "machine"};
        cpuIdentFieldNumbers = new int[]{2, 5, 8};
        devSymLinks = new String[]{null, "cpcmd", "cpact", "cpmon"};
        devFileMinorNumbers = new int[]{0, 8, 76, 220};
    }
}

