/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;

public class CurrentTime {
    private static boolean initialized = false;
    private static long delta = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(DBConnection dCon) throws SQLException {
        if (!initialized || dCon != null) {
            DBConnection dbcon = null;
            DBPreparedStatement stmt = null;
            try {
                dbcon = dCon == null ? (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection() : dCon;
                Connection con = dbcon.getConnection();
                DatabaseMetaData dbmd = con.getMetaData();
                String db_vendor = dbmd.getDatabaseProductName();
                Timestamp ts = null;
                long current = 0L;
                if (db_vendor.startsWith("DB2") || db_vendor.startsWith("Apache Derby")) {
                    stmt = dbcon.prepareStatement("SELECT current timestamp FROM sysibm.sysdummy1");
                    DBResultSet rs = stmt.executeQuery();
                    current = System.currentTimeMillis();
                    if (rs.next()) {
                        ts = rs.getTimestamp(1);
                    }
                } else if (db_vendor.startsWith("Oracle")) {
                    stmt = dbcon.prepareStatement("SELECT SYSTIMESTAMP FROM DUAL");
                    DBResultSet rs = stmt.executeQuery();
                    current = System.currentTimeMillis();
                    if (rs.next()) {
                        String str = rs.getString(1);
                        String[] tselems = str.split(" ");
                        tselems[1] = tselems[1].replaceFirst("\\.", ":");
                        tselems[1] = tselems[1].replaceFirst("\\.", ":");
                        str = tselems[0] + " " + tselems[1];
                        ts = Timestamp.valueOf(str);
                    }
                } else if (db_vendor.startsWith("Microsoft SQL Server")) {
                    stmt = dbcon.prepareStatement("SELECT GETDATE()");
                    DBResultSet rs = stmt.executeQuery();
                    current = System.currentTimeMillis();
                    if (rs.next()) {
                        ts = rs.getTimestamp(1);
                    }
                } else {
                    throw new SQLException("Database vendor " + db_vendor + " is not supported");
                }
                if (ts == null) {
                    throw new SQLException("Unable to retrieve timestamp from db server");
                }
                delta = current - ts.getTime();
                initialized = true;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
                if (dbcon != null && dCon == null) {
                    try {
                        dbcon.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static Timestamp getTimestamp(DBConnection dbcon) throws SQLException {
        return CurrentTime.getTimestamp();
    }

    public static synchronized Timestamp getTimestamp() throws SQLException {
        CurrentTime.initialize(null);
        return new Timestamp(System.currentTimeMillis() - delta);
    }
}

