/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DBPreparedStatement {
    DBConnection connection = null;
    PreparedStatement preparedStatement = null;
    ResultSetMetaData rsmd = null;
    private String sql;
    private static String className = DBPreparedStatement.class.getName();
    public static final int EXECUTE_FAILED = -3;
    public static final int SUCCESS_NO_INFO = -2;

    public DBPreparedStatement(PreparedStatement preparedStatement, DBConnection connection) throws SQLException {
        if (preparedStatement == null || connection == null) {
            throw new SQLException("DBPreparedStatement constructor called with null PreparedStatement or DBConnection");
        }
        this.preparedStatement = preparedStatement;
        this.connection = connection;
    }

    public void close() throws SQLException {
        this.connection.removeFromPsCache(this);
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
    }

    public void addBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.addBatch();
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] count = null;
        String methodName = "executeBatch";
        String traceLog = this.preparedStatement.toString();
        ILogger traceLogger = DBConstants.getLogger();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, methodName, traceLog);
        }
        if (this.preparedStatement != null) {
            this.connection.setTransactionActive(this.sql);
            count = this.preparedStatement.executeBatch();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return count;
    }

    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
        }
    }

    public DBResultSet executeQuery() throws SQLException {
        DBResultSet dbr = null;
        String methodName = "executeQuery";
        String traceLog = this.preparedStatement.toString() + (this.sql != null ? ", " + this.sql : "");
        ILogger traceLogger = DBConstants.getLogger();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, methodName, traceLog);
        }
        this.connection.setTransactionActive(this.sql);
        ResultSet rs = this.preparedStatement.executeQuery();
        dbr = new DBResultSet(rs, this);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbr;
    }

    public int executeUpdate() throws SQLException {
        int count = 0;
        String methodName = "executeUpdate";
        String traceLog = this.preparedStatement.toString() + (this.sql != null ? ", " + this.sql : "");
        ILogger traceLogger = DBConstants.getLogger();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, methodName, traceLog);
        }
        this.connection.setTransactionActive(this.sql);
        count = this.preparedStatement.executeUpdate();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return count;
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void setNull(int index, int type) throws SQLException {
        this.preparedStatement.setNull(index, type);
    }

    public void setShort(int index, short value) throws SQLException {
        this.preparedStatement.setShort(index, value);
    }

    public void setInt(int index, int value) throws SQLException {
        this.preparedStatement.setInt(index, value);
    }

    public void setDouble(int index, double value) throws SQLException {
        this.preparedStatement.setDouble(index, value);
    }

    public void setLong(int index, long value) throws SQLException {
        this.preparedStatement.setLong(index, value);
    }

    public void setFloat(int index, float value) throws SQLException {
        this.preparedStatement.setFloat(index, value);
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        this.preparedStatement.setBoolean(index, value);
    }

    public void setString(int index, String value) throws SQLException {
        this.preparedStatement.setString(index, value);
    }

    public void setByte(int index, byte value) throws SQLException {
        this.preparedStatement.setByte(index, value);
    }

    public void setByteArray(int index, byte[] value) throws SQLException {
        this.preparedStatement.setBytes(index, value);
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        this.preparedStatement.setTimestamp(index, value);
    }

    public void setDate(int index, Date value) throws SQLException {
        this.preparedStatement.setDate(index, value);
    }

    public void setTime(int index, Time value) throws SQLException {
        this.preparedStatement.setTime(index, value);
    }

    public void setClob(int index, Clob value) throws SQLException {
        this.preparedStatement.setClob(index, value);
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        this.preparedStatement.setBigDecimal(index, value);
    }

    private ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.rsmd = this.preparedStatement.getMetaData();
        }
        return this.rsmd;
    }

    public DBResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = null;
        DBResultSet dbr = null;
        rs = this.preparedStatement.getGeneratedKeys();
        dbr = new DBResultSet(rs, this);
        return dbr;
    }

    protected void setSql(String sql) {
        this.sql = sql;
    }
}

