/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Null;

public class DBQueryAssistant {
    private static boolean debug = false;
    private static final String DELIMITER = "'";

    private DBQueryAssistant() {
    }

    public static void processBoolean(ColumnInfo col, Hashtable htInput) {
        String booleanValue = (String)htInput.get(col);
        if (booleanValue != null) {
            if (booleanValue.equalsIgnoreCase("true")) {
                htInput.put(col, "1");
            } else if (booleanValue.equalsIgnoreCase("false")) {
                htInput.put(col, "0");
            }
        }
    }

    public static void closeResultSet(DBResultSet rs) throws SQLException {
        rs.closeAll();
    }

    private static String buildWhereClause(Hashtable htWhereClause) {
        StringBuffer sb = new StringBuffer();
        TreeMap tMap = new TreeMap(htWhereClause);
        Iterator iterator = tMap.keySet().iterator();
        while (iterator.hasNext()) {
            ColumnInfo colInfo = (ColumnInfo)iterator.next();
            sb.append(colInfo.getName());
            if (htWhereClause.get(colInfo).getClass() != Null.class) {
                if (colInfo.getOperator() != null) {
                    sb.append(colInfo.getOperator());
                } else {
                    sb.append("=");
                }
                sb.append("?");
            } else {
                sb.append(" IS NULL");
            }
            if (!iterator.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private static boolean insert(DBPreparedStatement stmt, Hashtable htColsAndValues) throws SQLException {
        if (stmt == null) {
            throw new SQLException("Error - prepared statemetn is null");
        }
        if (htColsAndValues == null) {
            throw new SQLException("Error - data input is null");
        }
        TreeMap tMap = new TreeMap(htColsAndValues);
        Iterator iterator = tMap.keySet().iterator();
        int paramCounter = 1;
        while (iterator.hasNext()) {
            ColumnInfo colInfo = (ColumnInfo)iterator.next();
            DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo, paramCounter, htColsAndValues);
            ++paramCounter;
        }
        int rowCount = stmt.executeUpdate();
        return rowCount == 1;
    }

    private static int update(DBPreparedStatement stmt, Hashtable htColsAndValues, Hashtable htWhereClause) throws SQLException {
        if (stmt == null) {
            throw new SQLException("Error - statement is null");
        }
        if (htColsAndValues == null) {
            throw new SQLException("Error - column/value hashtable is null");
        }
        if (htWhereClause == null) {
            throw new SQLException("Error - where clause hashtable is null");
        }
        ColumnInfo colInfo2 = null;
        TreeMap tMap = new TreeMap(htColsAndValues);
        Iterator iterator = tMap.keySet().iterator();
        int paramCounter = 1;
        while (iterator.hasNext()) {
            colInfo2 = (ColumnInfo)iterator.next();
            DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo2, paramCounter, htColsAndValues);
            ++paramCounter;
        }
        tMap = null;
        iterator = null;
        tMap = new TreeMap(htWhereClause);
        for (ColumnInfo colInfo2 : tMap.keySet()) {
            DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo2, paramCounter, htWhereClause);
            ++paramCounter;
        }
        tMap = null;
        iterator = null;
        int rowCount = stmt.executeUpdate();
        return rowCount;
    }

    private static DBResultSet query(DBPreparedStatement stmt, Hashtable htWhereClause) throws SQLException {
        DBResultSet DBrs = null;
        if (stmt == null) {
            throw new SQLException("Error - prepared statement is null");
        }
        if (htWhereClause != null) {
            TreeMap tMap = new TreeMap(htWhereClause);
            Iterator iterator = tMap.keySet().iterator();
            ColumnInfo colInfo = null;
            int paramCounter = 1;
            while (iterator.hasNext()) {
                colInfo = (ColumnInfo)iterator.next();
                if (htWhereClause.get(colInfo).getClass() == Null.class) continue;
                DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo, paramCounter, htWhereClause);
                ++paramCounter;
            }
        }
        DBrs = stmt.executeQuery();
        return DBrs;
    }

    private static int delete(DBPreparedStatement stmt, Hashtable htWhereClause) throws SQLException {
        if (stmt == null) {
            throw new SQLException("Error - prepared statemetn is null");
        }
        if (htWhereClause != null) {
            TreeMap tMap = new TreeMap(htWhereClause);
            Iterator iterator = tMap.keySet().iterator();
            int paramCounter = 1;
            while (iterator.hasNext()) {
                ColumnInfo colInfo = (ColumnInfo)iterator.next();
                DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo, paramCounter, htWhereClause);
                ++paramCounter;
            }
        }
        int rowCount = stmt.executeUpdate();
        return rowCount;
    }

    private static String buildQueryPreparedStatement(String tableName, DBConnection con, Hashtable whereClause, Vector columns) throws SQLException {
        if (tableName == null) {
            throw new SQLException("Error - table name is null");
        }
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        if (columns == null) {
            sqlStatement.append("* FROM ");
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                sqlStatement.append(columns.elementAt(i));
                if (i >= columns.size() - 1) continue;
                sqlStatement.append(",");
            }
            sqlStatement.append(" FROM ");
        }
        sqlStatement.append(tableName);
        if (whereClause != null) {
            sqlStatement.append(" WHERE ");
            String whereString = DBQueryAssistant.buildWhereClause(whereClause);
            sqlStatement.append(whereString);
        }
        return sqlStatement.toString();
    }

    private static String buildInsertPreparedStatement(String tableName, DBConnection con, Hashtable colsAndValues) throws SQLException {
        if (tableName == null) {
            throw new SQLException("Invalid call - null table name");
        }
        if (colsAndValues == null) {
            throw new SQLException("Invalid call - null column/value hashtable");
        }
        StringBuffer s1 = new StringBuffer("INSERT INTO ");
        StringBuffer s2 = new StringBuffer(" VALUES (");
        s1.append(tableName);
        s1.append(" (");
        TreeMap tMap = new TreeMap(colsAndValues);
        Iterator iterator = tMap.keySet().iterator();
        while (iterator.hasNext()) {
            ColumnInfo colInfo = (ColumnInfo)iterator.next();
            s1.append(colInfo.getName());
            s2.append("?");
            if (!iterator.hasNext()) continue;
            s1.append(",");
            s2.append(",");
        }
        s1.append(")");
        s2.append(")");
        return s1.append(s2).toString();
    }

    private static String buildUpdatePreparedStatement(String tableName, DBConnection con, Hashtable htColsAndValues, Hashtable htWhereClause) throws SQLException {
        ColumnInfo colInfo;
        if (tableName == null) {
            throw new SQLException("Error - table name is null");
        }
        if (htColsAndValues == null) {
            throw new SQLException("Error - column/value hashtable name is null");
        }
        if (htWhereClause == null) {
            throw new SQLException("Error - where clause hashtable name is null");
        }
        StringBuffer s1 = new StringBuffer("UPDATE ");
        StringBuffer s2 = new StringBuffer("WHERE ");
        s1.append(tableName);
        s1.append(" SET ");
        TreeMap tMap = new TreeMap(htWhereClause);
        Iterator iterator = tMap.keySet().iterator();
        while (iterator.hasNext()) {
            colInfo = (ColumnInfo)iterator.next();
            s2.append(colInfo.getName());
            if (colInfo.getOperator() != null) {
                s2.append(colInfo.getOperator());
            } else {
                s2.append("=");
            }
            s2.append("? ");
            if (!iterator.hasNext()) continue;
            s2.append("AND ");
        }
        tMap = null;
        iterator = null;
        colInfo = null;
        tMap = new TreeMap(htColsAndValues);
        iterator = tMap.keySet().iterator();
        while (iterator.hasNext()) {
            colInfo = (ColumnInfo)iterator.next();
            s1.append(colInfo.getName());
            s1.append(" = ?");
            if (!iterator.hasNext()) continue;
            s1.append(",");
        }
        s1.append(" ");
        return s1.append(s2).toString();
    }

    private static String buildDeletePreparedStatement(String tableName, DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (tableName == null) {
            throw new SQLException("Error -table name is null");
        }
        ColumnInfo colInfo = null;
        StringBuffer s1 = new StringBuffer("DELETE FROM ");
        StringBuffer s2 = null;
        s1.append(tableName);
        if (htWhereClause != null) {
            s2 = new StringBuffer(" WHERE ");
            TreeMap tMap = new TreeMap(htWhereClause);
            Iterator iterator = tMap.keySet().iterator();
            while (iterator.hasNext()) {
                colInfo = (ColumnInfo)iterator.next();
                s2.append(colInfo.getName());
                if (colInfo.getOperator() != null) {
                    s2.append(colInfo.getOperator());
                } else {
                    s2.append("=");
                }
                s2.append("?");
                if (!iterator.hasNext()) continue;
                s2.append(" AND ");
            }
        }
        String result = s2 == null ? s1.toString() : s1.append(s2).toString();
        return result;
    }

    public static void setPreparedStatementParameter(DBPreparedStatement stmt, ColumnInfo colInfo, int paramNum, Hashtable htValues) throws SQLException {
        if (htValues.get(colInfo).getClass() != Null.class) {
            try {
                switch (colInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        String str1 = (String)htValues.get(colInfo);
                        stmt.setString(paramNum, str1);
                        break;
                    }
                    case 2005: {
                        Clob cb1 = (Clob)htValues.get(colInfo);
                        stmt.setClob(paramNum, cb1);
                        break;
                    }
                    case 3: {
                        Object obj5 = htValues.get(colInfo);
                        BigDecimal setVal5 = DBConstants.INVALID_BIGDECIMAL_VALUE;
                        if (obj5 instanceof Float) {
                            setVal5 = (BigDecimal)obj5;
                        } else if (obj5 instanceof String) {
                            setVal5 = new BigDecimal((String)obj5);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj5.getClass() + " to a Java bigdecimal");
                        }
                        stmt.setBigDecimal(paramNum, setVal5);
                        break;
                    }
                    case 8: {
                        Object obj4 = htValues.get(colInfo);
                        double setVal4 = Double.MIN_VALUE;
                        if (obj4 instanceof Double) {
                            setVal4 = (Double)obj4;
                        } else if (obj4 instanceof String) {
                            setVal4 = Double.parseDouble((String)obj4);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj4.getClass() + " to a Java double");
                        }
                        stmt.setDouble(paramNum, setVal4);
                        break;
                    }
                    case 6: 
                    case 7: {
                        Object obj3 = htValues.get(colInfo);
                        float setVal3 = Float.MIN_VALUE;
                        if (obj3 instanceof Float) {
                            setVal3 = ((Float)obj3).floatValue();
                        } else if (obj3 instanceof String) {
                            setVal3 = Float.parseFloat((String)obj3);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj3.getClass() + " to a Java float");
                        }
                        stmt.setFloat(paramNum, setVal3);
                        break;
                    }
                    case 4: {
                        Object obj1 = htValues.get(colInfo);
                        int setVal1 = Integer.MIN_VALUE;
                        if (obj1 instanceof Integer) {
                            setVal1 = (Integer)obj1;
                        } else if (obj1 instanceof String) {
                            setVal1 = Integer.parseInt((String)obj1);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj1.getClass() + " to a Java int");
                        }
                        stmt.setInt(paramNum, setVal1);
                        break;
                    }
                    case 2: {
                        throw new SQLException("Error - Unsupported type - NUMERIC");
                    }
                    case 5: {
                        Object obj2 = htValues.get(colInfo);
                        int setVal2 = Short.MIN_VALUE;
                        if (obj2 instanceof Short) {
                            setVal2 = ((Short)obj2).shortValue();
                        } else if (obj2 instanceof String) {
                            setVal2 = Short.parseShort((String)obj2);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj2.getClass() + " to a Java short");
                        }
                        stmt.setInt(paramNum, setVal2);
                        break;
                    }
                    case 16: {
                        String str = (String)htValues.get(colInfo);
                        short val = str.equalsIgnoreCase("true") ? (short)1 : 0;
                        stmt.setShort(paramNum, val);
                        break;
                    }
                    case -6: {
                        throw new SQLException("Error - Unsupported type - TINYINT");
                    }
                    case 93: {
                        Object obj6 = htValues.get(colInfo);
                        Timestamp ts1 = DBConstants.INVALID_TIMESTAMP_VALUE;
                        if (obj6 instanceof Timestamp) {
                            ts1 = (Timestamp)obj6;
                        } else if (obj6 instanceof String) {
                            ts1 = Timestamp.valueOf((String)obj6);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj6.getClass() + " to a Java timestamp");
                        }
                        stmt.setTimestamp(paramNum, ts1);
                        break;
                    }
                    case 2003: {
                        throw new SQLException("Error - Unsupported type - ARRAY");
                    }
                    case 2004: {
                        throw new SQLException("Error - Unsupported type - BLOB");
                    }
                    case -7: {
                        throw new SQLException("Error - Unsupported type - BIT");
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] ba1 = ((String)htValues.get(colInfo)).getBytes();
                        stmt.setByteArray(paramNum, ba1);
                        break;
                    }
                    case 70: {
                        throw new SQLException("Error - Unsupported type - DATALINK");
                    }
                    case 91: {
                        Date dt1 = (Date)htValues.get(colInfo);
                        stmt.setDate(paramNum, dt1);
                        break;
                    }
                    case 92: {
                        Time tm1 = (Time)htValues.get(colInfo);
                        stmt.setTime(paramNum, tm1);
                        break;
                    }
                    case -5: {
                        Object obj = htValues.get(colInfo);
                        long setVal = Long.MIN_VALUE;
                        if (obj instanceof BigInteger) {
                            setVal = ((BigInteger)obj).longValue();
                        } else if (obj instanceof Long) {
                            setVal = (Long)obj;
                        } else if (obj instanceof String) {
                            setVal = Long.parseLong((String)obj);
                        } else {
                            throw new SQLException("Error - unable to conver " + obj.getClass() + " to a Java long");
                        }
                        stmt.setLong(paramNum, setVal);
                        break;
                    }
                    default: {
                        throw new SQLException("Error - Unknown type encountered - " + colInfo.getDataType());
                    }
                }
            }
            catch (NumberFormatException e) {
                String emsg = "Number Format exception on " + htValues.get(colInfo) + " and field " + colInfo.getName();
                System.out.println(emsg);
                throw new SQLException(emsg);
            }
        } else {
            stmt.setNull(paramNum, colInfo.getDataType());
        }
    }

    public static boolean performInsert(String tableName, DBConnection con, Hashtable htColsAndValues) throws SQLException {
        boolean result = false;
        String sqlStatement = DBQueryAssistant.buildInsertPreparedStatement(tableName, con, htColsAndValues);
        DBPreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            result = DBQueryAssistant.insert(pStmt, htColsAndValues);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception ignore) {}
                pStmt = null;
            }
        }
        return result;
    }

    public static int performUpdate(String tableName, DBConnection con, Hashtable htColsAndValues, Hashtable htWhereClause) throws SQLException {
        String sqlStatement = DBQueryAssistant.buildUpdatePreparedStatement(tableName, con, htColsAndValues, htWhereClause);
        int result = 0;
        DBPreparedStatement pStmt = null;
        try {
            pStmt = con.prepareStatement(sqlStatement);
            result = DBQueryAssistant.update(pStmt, htColsAndValues, htWhereClause);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception ignore) {}
                pStmt = null;
            }
        }
        return result;
    }

    public static DBResultSet performRetrieve(String tableName, DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        DBResultSet DBrs = null;
        String sqlString = DBQueryAssistant.buildQueryPreparedStatement(tableName, con, htWhereClause, columns);
        DBPreparedStatement pStmt = con.prepareStatement(sqlString);
        DBrs = DBQueryAssistant.query(pStmt, htWhereClause);
        return DBrs;
    }

    public static int performDelete(String tableName, DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (tableName == null) {
            throw new SQLException("ERRROR - table name is null");
        }
        if (con == null) {
            throw new SQLException("ERRROR - DBConnection is null");
        }
        int rowCount = 0;
        String sqlString = null;
        DBPreparedStatement pStmt = null;
        sqlString = DBQueryAssistant.buildDeletePreparedStatement(tableName, con, htWhereClause);
        try {
            pStmt = con.prepareStatement(sqlString);
            rowCount = DBQueryAssistant.delete(pStmt, htWhereClause);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception ignore) {}
                pStmt = null;
            }
        }
        return rowCount;
    }
}

