/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;

public class DBResultSet {
    private ResultSet resultSet;
    private DBPreparedStatement dbps = null;

    public DBResultSet(ResultSet resultSet, DBPreparedStatement dbps) throws SQLException {
        if (resultSet == null || dbps == null) {
            throw new SQLException("DBResultSet constructor called with null ResultSet or DBPreparedStatement");
        }
        this.resultSet = resultSet;
        this.dbps = dbps;
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    public DBPreparedStatement getStatement() throws SQLException {
        return this.dbps;
    }

    public void closeAll() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            if (this.dbps != null) {
                this.dbps.close();
            }
            if (this.dbps != null) {
                this.dbps.close();
            }
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public int current() throws SQLException {
        return this.resultSet.getRow();
    }

    public short getShort(int index) throws SQLException {
        short ret = this.resultSet.getShort(index);
        return ret;
    }

    public int getInt(int index) throws SQLException {
        int ret = this.resultSet.getInt(index);
        return ret;
    }

    public double getDouble(int index) throws SQLException {
        double ret = this.resultSet.getDouble(index);
        return ret;
    }

    public long getLong(int index) throws SQLException {
        long ret = this.resultSet.getLong(index);
        return ret;
    }

    public float getFloat(int index) throws SQLException {
        float ret = this.resultSet.getFloat(index);
        return ret;
    }

    public boolean getBoolean(int index) throws SQLException {
        return this.resultSet.getBoolean(index);
    }

    public String getString(int index) throws SQLException {
        String ret = this.resultSet.getString(index);
        return ret;
    }

    public byte getByte(int index) throws SQLException {
        return this.resultSet.getByte(index);
    }

    public byte[] getBytes(int index) throws SQLException {
        byte[] ret = this.resultSet.getBytes(index);
        return ret;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        byte[] ret = this.resultSet.getBytes(columnName);
        return ret;
    }

    public Timestamp getTimestamp(int index) throws SQLException {
        Timestamp ret = this.resultSet.getTimestamp(index);
        return ret;
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchSize(rows);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public BigDecimal getBigDecimal(int index) throws SQLException {
        BigDecimal ret = this.resultSet.getBigDecimal(index);
        return ret;
    }

    public BigDecimal getBigDecimal(String name) throws SQLException {
        BigDecimal ret = this.resultSet.getBigDecimal(name);
        return ret;
    }

    public String getString(String name) throws SQLException {
        String ret = this.resultSet.getString(name);
        return ret;
    }

    public short getShort(String name) throws SQLException {
        short ret = this.resultSet.getShort(name);
        return ret;
    }

    public double getDouble(String name) throws SQLException {
        double ret = this.resultSet.getDouble(name);
        return ret;
    }

    public int getInt(String name) throws SQLException {
        int ret = this.resultSet.getInt(name);
        return ret;
    }

    public long getLong(String name) throws SQLException {
        long ret = this.resultSet.getLong(name);
        return ret;
    }

    public float getFloat(String name) throws SQLException {
        float ret = this.resultSet.getFloat(name);
        return ret;
    }

    public Timestamp getTimestamp(String name) throws SQLException {
        Timestamp ret = this.resultSet.getTimestamp(name);
        return ret;
    }

    public Date getDate(String name) throws SQLException {
        Date ret = this.resultSet.getDate(name);
        return ret;
    }

    public Time getTime(String name) throws SQLException {
        Time ret = this.resultSet.getTime(name);
        return ret;
    }

    public Date getDate(int index) throws SQLException {
        Date ret = this.resultSet.getDate(index);
        return ret;
    }

    public Time getTime(int index) throws SQLException {
        Time ret = this.resultSet.getTime(index);
        return ret;
    }

    public Object getObject(String name) throws SQLException {
        return this.resultSet.getObject(name);
    }

    public Object getObject(int index) throws SQLException {
        return this.resultSet.getObject(index);
    }

    public Clob getClob(int index) throws SQLException {
        Clob ret = this.resultSet.getClob(index);
        return ret;
    }

    public Clob getClob(String name) throws SQLException {
        Clob ret = this.resultSet.getClob(name);
        return ret;
    }

    public Object[] getAttribute(Vector attributeNameVec, Vector columns) throws SQLException {
        if (attributeNameVec.size() <= 0) {
            return null;
        }
        Object[] returnVec = new Object[attributeNameVec.size()];
        for (int i = 0; i < attributeNameVec.size(); ++i) {
            int attributeIndex = columns.indexOf(attributeNameVec.elementAt(i)) + 1;
            returnVec[i] = this.resultSet.getObject(attributeIndex);
        }
        return returnVec;
    }
}

