/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResAliasTable;

public class Alias
extends TResAliasTable {
    public static AliasCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new AliasCursor(con, htWhereClause, columns);
    }

    public Alias() {
        this.clear();
    }

    public Alias(int AliasId, String FabricWwn, String AliasName, String Description) {
        this.clear();
        this.m_AliasId = AliasId;
        this.m_FabricWwn = FabricWwn;
        this.m_AliasName = AliasName;
        this.m_Description = Description;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_AliasId != Integer.MIN_VALUE) {
            htColsAndValues.put(Alias.getColumnInfo("ALIAS_ID"), String.valueOf(this.m_AliasId));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Alias.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htColsAndValues.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htColsAndValues.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_ALIAS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        if (htinput.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_ALIAS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), htinput.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), htinput.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), htinput.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), htinput.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_ALIAS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alias retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Alias el = null;
        if (htinput.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), htinput.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), htinput.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_ALIAS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Alias();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setAliasId(DBrs.getInt("ALIAS_ID"));
        this.setFabricWwn(DBrs.getString("FABRIC_WWN"));
        this.setAliasName(DBrs.getString("ALIAS_NAME"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
    }

    public static class AliasCursor
    extends DBCursor {
        private Alias element = new Alias();
        private DBConnection con;

        public AliasCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_ALIAS", con, htWhereClause, columns);
            this.con = con;
        }

        public Alias getObject() throws SQLException {
            Alias el = null;
            if (this.DBrs != null) {
                el = new Alias();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Alias getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

