/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;

public class BackendController
extends TResBackendControllerTable {
    private String m_SystemCreationClassNameId_str;
    private String m_SystemNamesId_str;
    private String m_CreationClassNameId_str;
    private String m_VendorId_str;

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static BackendControllerCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new BackendControllerCursor(con, htWhereClause, columns);
    }

    public BackendController() {
        this.clear();
    }

    public BackendController(int BackendControllerId, short SystemCreationClassNameId, short SystemNamesId, short CreationClassNameId, String DeviceId, int OperationalStatus, String NodeWwn, String WwpnPathCount, String SerialNumber, short VendorId, int OwningSubsystemId, int ReferencedSubsystemId, String PortWwns) {
        this.clear();
        this.m_BackendControllerId = BackendControllerId;
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_DeviceId = DeviceId;
        this.m_OperationalStatus = OperationalStatus;
        this.m_NodeWwn = NodeWwn;
        this.m_WwpnPathCount = WwpnPathCount;
        this.m_SerialNumber = SerialNumber;
        this.m_VendorId = VendorId;
        this.m_OwningSubsystemId = OwningSubsystemId;
        this.m_ReferencedSubsystemId = ReferencedSubsystemId;
        this.m_PortWwns = PortWwns;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_BackendControllerId != Integer.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("BACKEND_CONTROLLER_ID"), String.valueOf(this.m_BackendControllerId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NodeWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("NODE_WWN"), this.m_NodeWwn);
        }
        if (this.m_WwpnPathCount != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("WWPN_PATH_COUNT"), this.m_WwpnPathCount);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_OwningSubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("OWNING_SUBSYSTEM_ID"), String.valueOf(this.m_OwningSubsystemId));
        }
        if (this.m_ReferencedSubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("REFERENCED_SUBSYSTEM_ID"), String.valueOf(this.m_ReferencedSubsystemId));
        }
        if (this.m_PortWwns != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BackendController.getColumnInfo("PORT_WWNS"), this.m_PortWwns);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(BackendController.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htColsAndValues.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_BACKEND_CONTROLLER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_BACKEND_CONTROLLER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_BACKEND_CONTROLLER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), htinput.get(BackendController.getColumnInfo("DEVICE_ID")));
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_BACKEND_CONTROLLER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_BACKEND_CONTROLLER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), htinput.get(BackendController.getColumnInfo("DEVICE_ID")));
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_BACKEND_CONTROLLER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_BACKEND_CONTROLLER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackendController retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        BackendController el = null;
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        htWhereClause.put(BackendController.getColumnInfo("DEVICE_ID"), htinput.get(BackendController.getColumnInfo("DEVICE_ID")));
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_BACKEND_CONTROLLER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new BackendController();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_BACKEND_CONTROLLER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(BackendController.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(BackendController.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(BackendController.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_BACKEND_CONTROLLER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setBackendControllerId(DBrs.getInt("BACKEND_CONTROLLER_ID"));
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setNodeWwn(DBrs.getString("NODE_WWN"));
        this.setWwpnPathCount(DBrs.getString("WWPN_PATH_COUNT"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setOwningSubsystemId(DBrs.getInt("OWNING_SUBSYSTEM_ID"));
        this.setReferencedSubsystemId(DBrs.getInt("REFERENCED_SUBSYSTEM_ID"));
        this.setPortWwns(DBrs.getString("PORT_WWNS"));
    }

    public static class BackendControllerCursor
    extends DBCursor {
        private BackendController element = new BackendController();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResBackendControllerTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResBackendControllerTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResBackendControllerTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResBackendControllerTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResBackendControllerTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResBackendControllerTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            if (htWhereClause.get(TResBackendControllerTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResBackendControllerTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResBackendControllerTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResBackendControllerTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResBackendControllerTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResBackendControllerTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public BackendControllerCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_BACKEND_CONTROLLER", con, BackendControllerCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public BackendController getObject() throws SQLException {
            BackendController el = null;
            if (this.DBrs != null) {
                el = new BackendController();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public BackendController getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

