/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TBatchReportTable;

public class BatchReport
extends TBatchReportTable {
    public static BatchReportCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new BatchReportCursor(con, htWhereClause, columns);
    }

    public BatchReport() {
        this.clear();
    }

    public BatchReport(int ReportId, String FileMask, String ReportType, String ScriptName, byte[] Definition, String Headers, String Totals2, String HistoryHeader, String SpaceUnits) {
        this.clear();
        this.m_ReportId = ReportId;
        this.m_FileMask = FileMask;
        this.m_ReportType = ReportType;
        this.m_ScriptName = ScriptName;
        this.m_Definition = Definition;
        this.m_Headers = Headers;
        this.m_Totals = Totals2;
        this.m_HistoryHeader = HistoryHeader;
        this.m_SpaceUnits = SpaceUnits;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ReportId != Integer.MIN_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("REPORT_ID"), String.valueOf(this.m_ReportId));
        }
        if (this.m_FileMask != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("FILE_MASK"), this.m_FileMask);
        }
        if (this.m_ReportType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("REPORT_TYPE"), this.m_ReportType);
        }
        if (this.m_ScriptName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("SCRIPT_NAME"), this.m_ScriptName);
        }
        if (this.m_Definition != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("DEFINITION"), new String(this.m_Definition));
        }
        if (this.m_Headers != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("HEADERS"), this.m_Headers);
        }
        if (this.m_Totals != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("TOTALS"), this.m_Totals);
        }
        if (this.m_HistoryHeader != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("HISTORY_HEADER"), this.m_HistoryHeader);
        }
        if (this.m_SpaceUnits != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(BatchReport.getColumnInfo("SPACE_UNITS"), this.m_SpaceUnits);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_BATCH_REPORT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_BATCH_REPORT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_BATCH_REPORT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_BATCH_REPORT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_BATCH_REPORT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_BATCH_REPORT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_BATCH_REPORT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchReport retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        BatchReport el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_BATCH_REPORT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new BatchReport();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_BATCH_REPORT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_BATCH_REPORT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setReportId(DBrs.getInt("REPORT_ID"));
        this.setFileMask(DBrs.getString("FILE_MASK"));
        this.setReportType(DBrs.getString("REPORT_TYPE"));
        this.setScriptName(DBrs.getString("SCRIPT_NAME"));
        this.setDefinition(DBrs.getBytes("DEFINITION"));
        this.setHeaders(DBrs.getString("HEADERS"));
        this.setTotals(DBrs.getString("TOTALS"));
        this.setHistoryHeader(DBrs.getString("HISTORY_HEADER"));
        this.setSpaceUnits(DBrs.getString("SPACE_UNITS"));
    }

    public static class BatchReportCursor
    extends DBCursor {
        private BatchReport element = new BatchReport();
        private DBConnection con;

        public BatchReportCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_BATCH_REPORT", con, htWhereClause, columns);
            this.con = con;
        }

        public BatchReport getObject() throws SQLException {
            BatchReport el = null;
            if (this.DBrs != null) {
                el = new BatchReport();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public BatchReport getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

