/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkTable;

public class Chunk
extends TResChunkTable {
    public static ChunkCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ChunkCursor(con, htWhereClause, columns);
    }

    public Chunk() {
        this.clear();
    }

    public Chunk(int DiskId, int CollectionId, int LogicalDiskId, short Partition, short Seqno, String HasDb, int UnitSize, double ChunkSize, double Offset) {
        this.clear();
        this.m_DiskId = DiskId;
        this.m_CollectionId = CollectionId;
        this.m_LogicalDiskId = LogicalDiskId;
        this.m_Partition = Partition;
        this.m_Seqno = Seqno;
        this.m_HasDb = HasDb;
        this.m_UnitSize = UnitSize;
        this.m_ChunkSize = ChunkSize;
        this.m_Offset = Offset;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_DiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("DISK_ID"), String.valueOf(this.m_DiskId));
        }
        if (this.m_CollectionId != Integer.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("COLLECTION_ID"), String.valueOf(this.m_CollectionId));
        }
        if (this.m_LogicalDiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("LOGICAL_DISK_ID"), String.valueOf(this.m_LogicalDiskId));
        }
        if (this.m_Partition != Short.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("partition"), String.valueOf(this.m_Partition));
        }
        if (this.m_Seqno != Short.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("SEQNO"), String.valueOf(this.m_Seqno));
        }
        if (this.m_HasDb != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("HAS_DB"), this.m_HasDb);
        }
        if (this.m_UnitSize != Integer.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("UNIT_SIZE"), String.valueOf(this.m_UnitSize));
        }
        if (this.m_ChunkSize != Double.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("CHUNK_SIZE"), String.valueOf(this.m_ChunkSize));
        }
        if (this.m_Offset != Double.MIN_VALUE) {
            htColsAndValues.put(Chunk.getColumnInfo("OFFSET"), String.valueOf(this.m_Offset));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CHUNK", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_CHUNK", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CHUNK", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CHUNK", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CHUNK", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CHUNK", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CHUNK", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chunk retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Chunk el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CHUNK", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Chunk();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_CHUNK", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_CHUNK", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setDiskId(DBrs.getInt("DISK_ID"));
        this.setCollectionId(DBrs.getInt("COLLECTION_ID"));
        this.setLogicalDiskId(DBrs.getInt("LOGICAL_DISK_ID"));
        this.setPartition(DBrs.getShort("partition"));
        this.setSeqno(DBrs.getShort("SEQNO"));
        this.setHasDb(DBrs.getString("HAS_DB"));
        this.setUnitSize(DBrs.getInt("UNIT_SIZE"));
        this.setChunkSize(DBrs.getDouble("CHUNK_SIZE"));
        this.setOffset(DBrs.getDouble("OFFSET"));
    }

    public static class ChunkCursor
    extends DBCursor {
        private Chunk element = new Chunk();
        private DBConnection con;

        public ChunkCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CHUNK", con, htWhereClause, columns);
            this.con = con;
        }

        public Chunk getObject() throws SQLException {
            Chunk el = null;
            if (this.DBrs != null) {
                el = new Chunk();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Chunk getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

