/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeSnapshotTable;

public class CimkeyVolumeSnapshot
extends TResCimkeyVolumeSnapshotTable {
    private String m_SystemNamesId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemCreationClassNameId_str;

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public static CimkeyVolumeSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new CimkeyVolumeSnapshotCursor(con, htWhereClause, columns);
    }

    public CimkeyVolumeSnapshot() {
        this.clear();
    }

    public CimkeyVolumeSnapshot(int SnapshotId, int VolumeId, int CimNamespaceId, short SystemNamesId, short CreationClassNameId, short SystemCreationClassNameId, String DeviceId, short Active, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_VolumeId = VolumeId;
        this.m_CimNamespaceId = CimNamespaceId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_DeviceId = DeviceId;
        this.m_Active = Active;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_DeviceId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        }
        if (this.m_Active != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CimkeyVolumeSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        CimkeyVolumeSnapshot el = null;
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CIM_NAMESPACE_ID")));
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new CimkeyVolumeSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(CimkeyVolumeSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setVolumeId(DBrs.getInt("VOLUME_ID"));
        this.setCimNamespaceId(DBrs.getInt("CIM_NAMESPACE_ID"));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setActive(DBrs.getShort("ACTIVE"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class CimkeyVolumeSnapshotCursor
    extends DBCursor {
        private CimkeyVolumeSnapshot element = new CimkeyVolumeSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            if (htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResCimkeyVolumeSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResCimkeyVolumeSnapshotTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public CimkeyVolumeSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CIMKEY_VOLUME_SNAPSHOT", con, CimkeyVolumeSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public CimkeyVolumeSnapshot getObject() throws SQLException {
            CimkeyVolumeSnapshot el = null;
            if (this.DBrs != null) {
                el = new CimkeyVolumeSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public CimkeyVolumeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

