/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatCompHistTable;

public class CompHist
extends TStatCompHistTable {
    public static CompHistCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new CompHistCursor(con, htWhereClause, columns);
    }

    public CompHist() {
        this.clear();
    }

    public CompHist(int ComputerId, String StatisticType, Timestamp MonitorStart, Timestamp MonitorEnd, int PowerCycles, int DownTime) {
        this.clear();
        this.m_ComputerId = ComputerId;
        this.m_StatisticType = StatisticType;
        this.m_MonitorStart = MonitorStart;
        this.m_MonitorEnd = MonitorEnd;
        this.m_PowerCycles = PowerCycles;
        this.m_DownTime = DownTime;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_MonitorStart != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("MONITOR_START"), this.m_MonitorStart);
        }
        if (this.m_MonitorEnd != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("MONITOR_END"), this.m_MonitorEnd);
        }
        if (this.m_PowerCycles != Integer.MIN_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("POWER_CYCLES"), String.valueOf(this.m_PowerCycles));
        }
        if (this.m_DownTime != Integer.MIN_VALUE) {
            htColsAndValues.put(CompHist.getColumnInfo("DOWN_TIME"), String.valueOf(this.m_DownTime));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_COMP_HIST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_COMP_HIST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_COMP_HIST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompHist retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        CompHist el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_COMP_HIST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new CompHist();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMP_HIST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMP_HIST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setStatisticType(DBrs.getString("STATISTIC_TYPE"));
        this.setMonitorStart(DBrs.getTimestamp("MONITOR_START"));
        this.setMonitorEnd(DBrs.getTimestamp("MONITOR_END"));
        this.setPowerCycles(DBrs.getInt("POWER_CYCLES"));
        this.setDownTime(DBrs.getInt("DOWN_TIME"));
    }

    public static class CompHistCursor
    extends DBCursor {
        private CompHist element = new CompHist();
        private DBConnection con;

        public CompHistCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_COMP_HIST", con, htWhereClause, columns);
            this.con = con;
        }

        public CompHist getObject() throws SQLException {
            CompHist el = null;
            if (this.DBrs != null) {
                el = new CompHist();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public CompHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

