/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TConfigSettingsTable;

public class ConfigSettings
extends TConfigSettingsTable {
    public static ConfigSettingsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ConfigSettingsCursor(con, htWhereClause, columns);
    }

    public ConfigSettings() {
        this.clear();
    }

    public ConfigSettings(String SnmpServer, int SnmpPort, String SnmpCommunity2, String SmtpServer, int SmtpPort, String SmtpReplyTo, String SmtpReturn, String SmtpDfltDomain, int RetainCopies, int RetainDays, int DellogAfterDays, String TecServer, int TecPort, String Snmp2Server, int Snmp2Port, String Snmp2Community) {
        this.clear();
        this.m_SnmpServer = SnmpServer;
        this.m_SnmpPort = SnmpPort;
        this.m_SnmpCommunity = SnmpCommunity2;
        this.m_SmtpServer = SmtpServer;
        this.m_SmtpPort = SmtpPort;
        this.m_SmtpReplyTo = SmtpReplyTo;
        this.m_SmtpReturn = SmtpReturn;
        this.m_SmtpDfltDomain = SmtpDfltDomain;
        this.m_RetainCopies = RetainCopies;
        this.m_RetainDays = RetainDays;
        this.m_DellogAfterDays = DellogAfterDays;
        this.m_TecServer = TecServer;
        this.m_TecPort = TecPort;
        this.m_Snmp2Server = Snmp2Server;
        this.m_Snmp2Port = Snmp2Port;
        this.m_Snmp2Community = Snmp2Community;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SnmpServer != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP_SERVER"), this.m_SnmpServer);
        }
        if (this.m_SnmpPort != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP_PORT"), String.valueOf(this.m_SnmpPort));
        }
        if (this.m_SnmpCommunity != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP_COMMUNITY"), this.m_SnmpCommunity);
        }
        if (this.m_SmtpServer != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SMTP_SERVER"), this.m_SmtpServer);
        }
        if (this.m_SmtpPort != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SMTP_PORT"), String.valueOf(this.m_SmtpPort));
        }
        if (this.m_SmtpReplyTo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SMTP_REPLY_TO"), this.m_SmtpReplyTo);
        }
        if (this.m_SmtpReturn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SMTP_RETURN"), this.m_SmtpReturn);
        }
        if (this.m_SmtpDfltDomain != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SMTP_DFLT_DOMAIN"), this.m_SmtpDfltDomain);
        }
        if (this.m_RetainCopies != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("RETAIN_COPIES"), String.valueOf(this.m_RetainCopies));
        }
        if (this.m_RetainDays != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("RETAIN_DAYS"), String.valueOf(this.m_RetainDays));
        }
        if (this.m_DellogAfterDays != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("DELLOG_AFTER_DAYS"), String.valueOf(this.m_DellogAfterDays));
        }
        if (this.m_TecServer != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("TEC_SERVER"), this.m_TecServer);
        }
        if (this.m_TecPort != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("TEC_PORT"), String.valueOf(this.m_TecPort));
        }
        if (this.m_Snmp2Server != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP2_SERVER"), this.m_Snmp2Server);
        }
        if (this.m_Snmp2Port != Integer.MIN_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP2_PORT"), String.valueOf(this.m_Snmp2Port));
        }
        if (this.m_Snmp2Community != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ConfigSettings.getColumnInfo("SNMP2_COMMUNITY"), this.m_Snmp2Community);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_CONFIG_SETTINGS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_CONFIG_SETTINGS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_CONFIG_SETTINGS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_CONFIG_SETTINGS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_CONFIG_SETTINGS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_CONFIG_SETTINGS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_CONFIG_SETTINGS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigSettings retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ConfigSettings el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_CONFIG_SETTINGS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ConfigSettings();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_CONFIG_SETTINGS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_CONFIG_SETTINGS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnmpServer(DBrs.getString("SNMP_SERVER"));
        this.setSnmpPort(DBrs.getInt("SNMP_PORT"));
        this.setSnmpCommunity(DBrs.getString("SNMP_COMMUNITY"));
        this.setSmtpServer(DBrs.getString("SMTP_SERVER"));
        this.setSmtpPort(DBrs.getInt("SMTP_PORT"));
        this.setSmtpReplyTo(DBrs.getString("SMTP_REPLY_TO"));
        this.setSmtpReturn(DBrs.getString("SMTP_RETURN"));
        this.setSmtpDfltDomain(DBrs.getString("SMTP_DFLT_DOMAIN"));
        this.setRetainCopies(DBrs.getInt("RETAIN_COPIES"));
        this.setRetainDays(DBrs.getInt("RETAIN_DAYS"));
        this.setDellogAfterDays(DBrs.getInt("DELLOG_AFTER_DAYS"));
        this.setTecServer(DBrs.getString("TEC_SERVER"));
        this.setTecPort(DBrs.getInt("TEC_PORT"));
        this.setSnmp2Server(DBrs.getString("SNMP2_SERVER"));
        this.setSnmp2Port(DBrs.getInt("SNMP2_PORT"));
        this.setSnmp2Community(DBrs.getString("SNMP2_COMMUNITY"));
    }

    public static class ConfigSettingsCursor
    extends DBCursor {
        private ConfigSettings element = new ConfigSettings();
        private DBConnection con;

        public ConfigSettingsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_CONFIG_SETTINGS", con, htWhereClause, columns);
            this.con = con;
        }

        public ConfigSettings getObject() throws SQLException {
            ConfigSettings el = null;
            if (this.DBrs != null) {
                el = new ConfigSettings();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ConfigSettings getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

