/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupSnapshotTable;

public class DiskGroupSnapshot
extends TResDiskGroupSnapshotTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static DiskGroupSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new DiskGroupSnapshotCursor(con, htWhereClause, columns);
    }

    public DiskGroupSnapshot() {
        this.clear();
    }

    public DiskGroupSnapshot(int SnapshotId, int DiskGroupId, String Name2, String Description, String RaidLevel, String Loop2, String Array2, int SubsystemId, short Width, int StorageExtentId, String DeviceAdapter1, String DeviceAdapter2, int DaPairId, double DdmCap, String DdmSpeed, Timestamp UpdateTimestamp, String Tag2, short DiskGroupNumber, short CreationClassNameId) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_DiskGroupId = DiskGroupId;
        this.m_Name = Name2;
        this.m_Description = Description;
        this.m_RaidLevel = RaidLevel;
        this.m_Loop = Loop2;
        this.m_Array = Array2;
        this.m_SubsystemId = SubsystemId;
        this.m_Width = Width;
        this.m_StorageExtentId = StorageExtentId;
        this.m_DeviceAdapter1 = DeviceAdapter1;
        this.m_DeviceAdapter2 = DeviceAdapter2;
        this.m_DaPairId = DaPairId;
        this.m_DdmCap = DdmCap;
        this.m_DdmSpeed = DdmSpeed;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Tag = Tag2;
        this.m_DiskGroupNumber = DiskGroupNumber;
        this.m_CreationClassNameId = CreationClassNameId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_RaidLevel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("RAID_LEVEL"), this.m_RaidLevel);
        }
        if (this.m_Loop != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("LOOP"), this.m_Loop);
        }
        if (this.m_Array != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("ARRAY"), this.m_Array);
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_Width != Short.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("WIDTH"), String.valueOf(this.m_Width));
        }
        if (this.m_StorageExtentId != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        }
        if (this.m_DeviceAdapter1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DEVICE_ADAPTER1"), this.m_DeviceAdapter1);
        }
        if (this.m_DeviceAdapter2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DEVICE_ADAPTER2"), this.m_DeviceAdapter2);
        }
        if (this.m_DaPairId != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DA_PAIR_ID"), String.valueOf(this.m_DaPairId));
        }
        if (this.m_DdmCap != Double.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DDM_CAP"), String.valueOf(this.m_DdmCap));
        }
        if (this.m_DdmSpeed != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DDM_SPEED"), this.m_DdmSpeed);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_DiskGroupNumber != Short.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("DISK_GROUP_NUMBER"), String.valueOf(this.m_DiskGroupNumber));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("TAG"), this.m_Tag);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DISK_GROUP_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_DISK_GROUP_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), this.m_Tag);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")));
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), this.m_Tag);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")));
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), this.m_Tag);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DISK_GROUP_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskGroupSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        DiskGroupSnapshot el = null;
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        htWhereClause.put(DiskGroupSnapshot.getColumnInfo("TAG"), htinput.get(DiskGroupSnapshot.getColumnInfo("TAG")));
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(DiskGroupSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DISK_GROUP_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new DiskGroupSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(DiskGroupSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setDiskGroupId(DBrs.getInt("DISK_GROUP_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
        this.setRaidLevel(DBrs.getString("RAID_LEVEL"));
        this.setLoop(DBrs.getString("LOOP"));
        this.setArray(DBrs.getString("ARRAY"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setWidth(DBrs.getShort("WIDTH"));
        this.setStorageExtentId(DBrs.getInt("STORAGE_EXTENT_ID"));
        this.setDeviceAdapter1(DBrs.getString("DEVICE_ADAPTER1"));
        this.setDeviceAdapter2(DBrs.getString("DEVICE_ADAPTER2"));
        this.setDaPairId(DBrs.getInt("DA_PAIR_ID"));
        this.setDdmCap(DBrs.getDouble("DDM_CAP"));
        this.setDdmSpeed(DBrs.getString("DDM_SPEED"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setTag(DBrs.getString("TAG"));
        this.setDiskGroupNumber(DBrs.getShort("DISK_GROUP_NUMBER"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
    }

    public static class DiskGroupSnapshotCursor
    extends DBCursor {
        private DiskGroupSnapshot element = new DiskGroupSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResDiskGroupSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResDiskGroupSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResDiskGroupSnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public DiskGroupSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_DISK_GROUP_SNAPSHOT", con, DiskGroupSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public DiskGroupSnapshot getObject() throws SQLException {
            DiskGroupSnapshot el = null;
            if (this.DBrs != null) {
                el = new DiskGroupSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public DiskGroupSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

