/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatFsHistTable;

public class FsHist
extends TStatFsHistTable {
    public static FsHistCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new FsHistCursor(con, htWhereClause, columns);
    }

    public FsHist() {
        this.clear();
    }

    public FsHist(int FilesystemId, String StatisticType, Timestamp StatisticTime, short AccumCount, double FileCount, double Capacity, double FreeSpace, int ProductId, double UsedSpace) {
        this.clear();
        this.m_FilesystemId = FilesystemId;
        this.m_StatisticType = StatisticType;
        this.m_StatisticTime = StatisticTime;
        this.m_AccumCount = AccumCount;
        this.m_FileCount = FileCount;
        this.m_Capacity = Capacity;
        this.m_FreeSpace = FreeSpace;
        this.m_ProductId = ProductId;
        this.m_UsedSpace = UsedSpace;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_AccumCount != Short.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("ACCUM_COUNT"), String.valueOf(this.m_AccumCount));
        }
        if (this.m_FileCount != Double.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("FILE_COUNT"), String.valueOf(this.m_FileCount));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_ProductId != Integer.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("PRODUCT_ID"), String.valueOf(this.m_ProductId));
        }
        if (this.m_UsedSpace != Double.MIN_VALUE) {
            htColsAndValues.put(FsHist.getColumnInfo("USED_SPACE"), String.valueOf(this.m_UsedSpace));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_FS_HIST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_FS_HIST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_FS_HIST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FsHist retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        FsHist el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_FS_HIST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new FsHist();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setFilesystemId(DBrs.getInt("FILESYSTEM_ID"));
        this.setStatisticType(DBrs.getString("STATISTIC_TYPE"));
        this.setStatisticTime(DBrs.getTimestamp("STATISTIC_TIME"));
        this.setAccumCount(DBrs.getShort("ACCUM_COUNT"));
        this.setFileCount(DBrs.getDouble("FILE_COUNT"));
        this.setCapacity(DBrs.getDouble("CAPACITY"));
        this.setFreeSpace(DBrs.getDouble("FREE_SPACE"));
        this.setProductId(DBrs.getInt("PRODUCT_ID"));
        this.setUsedSpace(DBrs.getDouble("USED_SPACE"));
    }

    public static class FsHistCursor
    extends DBCursor {
        private FsHist element = new FsHist();
        private DBConnection con;

        public FsHistCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_FS_HIST", con, htWhereClause, columns);
            this.con = con;
        }

        public FsHist getObject() throws SQLException {
            FsHist el = null;
            if (this.DBrs != null) {
                el = new FsHist();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public FsHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

