/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResHbaTable;

public class Hba
extends TResHbaTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static HbaCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new HbaCursor(con, htWhereClause, columns);
    }

    public Hba() {
        this.clear();
    }

    public Hba(short VendorId, short ModelId, short ApiVersion, String HbaWwn, int HbaId, String Name2, String SerialNumber, String DriverVersion, String DriverName, String RomVersion, String HwVersion, String FirmwareVersion, int HostId, int LparId, int IoEnclosureId, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_ApiVersion = ApiVersion;
        this.m_HbaWwn = HbaWwn;
        this.m_HbaId = HbaId;
        this.m_Name = Name2;
        this.m_SerialNumber = SerialNumber;
        this.m_DriverVersion = DriverVersion;
        this.m_DriverName = DriverName;
        this.m_RomVersion = RomVersion;
        this.m_HwVersion = HwVersion;
        this.m_FirmwareVersion = FirmwareVersion;
        this.m_HostId = HostId;
        this.m_LparId = LparId;
        this.m_IoEnclosureId = IoEnclosureId;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ApiVersion != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("API_VERSION"), String.valueOf(this.m_ApiVersion));
        }
        if (this.m_HbaId != Integer.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_DriverVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("DRIVER_VERSION"), this.m_DriverVersion);
        }
        if (this.m_DriverName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("DRIVER_NAME"), this.m_DriverName);
        }
        if (this.m_RomVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("ROM_VERSION"), this.m_RomVersion);
        }
        if (this.m_HwVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("HW_VERSION"), this.m_HwVersion);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_LparId != Integer.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        }
        if (this.m_IoEnclosureId != Integer.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("IO_ENCLOSURE_ID"), String.valueOf(this.m_IoEnclosureId));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Hba.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_HBA", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        if (htinput.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        if (htinput.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_HBA", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), htinput.get(Hba.getColumnInfo("HBA_WWN")));
        if (htinput.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), htinput.get(Hba.getColumnInfo("HOST_ID")));
        if (htinput.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), htinput.get(Hba.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), htinput.get(Hba.getColumnInfo("HBA_WWN")));
        if (htinput.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), htinput.get(Hba.getColumnInfo("HOST_ID")));
        if (htinput.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), htinput.get(Hba.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_HBA", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hba retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Hba el = null;
        if (htinput.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), htinput.get(Hba.getColumnInfo("HBA_WWN")));
        if (htinput.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        htWhereClause.put(Hba.getColumnInfo("HOST_ID"), htinput.get(Hba.getColumnInfo("HOST_ID")));
        if (htinput.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        htWhereClause.put(Hba.getColumnInfo("NAME"), htinput.get(Hba.getColumnInfo("NAME")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_HBA", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Hba();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setApiVersion(DBrs.getShort("API_VERSION"));
        this.setHbaWwn(DBrs.getString("HBA_WWN"));
        this.setHbaId(DBrs.getInt("HBA_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setDriverVersion(DBrs.getString("DRIVER_VERSION"));
        this.setDriverName(DBrs.getString("DRIVER_NAME"));
        this.setRomVersion(DBrs.getString("ROM_VERSION"));
        this.setHwVersion(DBrs.getString("HW_VERSION"));
        this.setFirmwareVersion(DBrs.getString("FIRMWARE_VERSION"));
        this.setHostId(DBrs.getInt("HOST_ID"));
        this.setLparId(DBrs.getInt("LPAR_ID"));
        this.setIoEnclosureId(DBrs.getInt("IO_ENCLOSURE_ID"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class HbaCursor
    extends DBCursor {
        private Hba element = new Hba();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResHbaTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResHbaTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResHbaTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResHbaTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResHbaTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResHbaTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public HbaCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_HBA", con, HbaCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Hba getObject() throws SQLException {
            Hba el = null;
            if (this.DBrs != null) {
                el = new Hba();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Hba getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

