/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResHostTable;

public class Host
extends TResHostTable {
    private String m_VendorId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static HostCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new HostCursor(con, htWhereClause, columns);
    }

    public Host() {
        this.clear();
    }

    public Host(String Guid, String HostUrl, short OsType, String OsVersion, String NetworkName, String DomainName, int ComputerId, String HostName, byte[] HardwareId, short VendorId, String TimeZone2, Timestamp DiscoveredTime, byte[] ProductStates, short CpuArchitecture, String OriginalAlias, String IpAddress, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp ChangedTimestamp, Timestamp UpdateTimestamp, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_Guid = Guid;
        this.m_HostUrl = HostUrl;
        this.m_OsType = OsType;
        this.m_OsVersion = OsVersion;
        this.m_NetworkName = NetworkName;
        this.m_DomainName = DomainName;
        this.m_ComputerId = ComputerId;
        this.m_HostName = HostName;
        this.m_HardwareId = HardwareId;
        this.m_VendorId = VendorId;
        this.m_TimeZone = TimeZone2;
        this.m_DiscoveredTime = DiscoveredTime;
        this.m_ProductStates = ProductStates;
        this.m_CpuArchitecture = CpuArchitecture;
        this.m_OriginalAlias = OriginalAlias;
        this.m_IpAddress = IpAddress;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Guid != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("GUID"), this.m_Guid);
        }
        if (this.m_HostUrl != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("HOST_URL"), this.m_HostUrl);
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_OsVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("OS_VERSION"), this.m_OsVersion);
        }
        if (this.m_NetworkName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("NETWORK_NAME"), this.m_NetworkName);
        }
        if (this.m_DomainName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("DOMAIN_NAME"), this.m_DomainName);
        }
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_HardwareId != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("HARDWARE_ID"), new String(this.m_HardwareId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_TimeZone != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("TIME_ZONE"), this.m_TimeZone);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_ProductStates != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("PRODUCT_STATES"), new String(this.m_ProductStates));
        }
        if (this.m_CpuArchitecture != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("CPU_ARCHITECTURE"), String.valueOf(this.m_CpuArchitecture));
        }
        if (this.m_OriginalAlias != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("ORIGINAL_ALIAS"), this.m_OriginalAlias);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Host.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ComputerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key COMPUTER_ID not found");
        }
        this.htColsAndValues.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_HOST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Host.getColumnInfo("COMPUTER_ID")) == null) {
            throw new SQLException(" ERROR: key COMPUTER_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_HOST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ComputerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key COMPUTER_ID not found");
        }
        this.htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HOST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Host.getColumnInfo("COMPUTER_ID")) == null) {
            throw new SQLException(" ERROR: key COMPUTER_ID not found");
        }
        this.htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), htinput.get(Host.getColumnInfo("COMPUTER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HOST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ComputerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key COMPUTER_ID not found");
        }
        this.htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HOST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Host.getColumnInfo("COMPUTER_ID")) == null) {
            throw new SQLException(" ERROR: key COMPUTER_ID not found");
        }
        this.htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), htinput.get(Host.getColumnInfo("COMPUTER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HOST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ComputerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key COMPUTER_ID not found");
        }
        this.htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_HOST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Host el = null;
        if (htinput.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(Host.getColumnInfo("COMPUTER_ID")) == null) {
            throw new SQLException(" ERROR: key COMPUTER_ID not found");
        }
        htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), htinput.get(Host.getColumnInfo("COMPUTER_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_HOST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Host();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_HOST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Host.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Host.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Host.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_HOST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setGuid(DBrs.getString("GUID"));
        this.setHostUrl(DBrs.getString("HOST_URL"));
        this.setOsType(DBrs.getShort("OS_TYPE"));
        this.setOsVersion(DBrs.getString("OS_VERSION"));
        this.setNetworkName(DBrs.getString("NETWORK_NAME"));
        this.setDomainName(DBrs.getString("DOMAIN_NAME"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setHostName(DBrs.getString("HOST_NAME"));
        this.setHardwareId(DBrs.getBytes("HARDWARE_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setTimeZone(DBrs.getString("TIME_ZONE"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
        this.setProductStates(DBrs.getBytes("PRODUCT_STATES"));
        this.setCpuArchitecture(DBrs.getShort("CPU_ARCHITECTURE"));
        this.setOriginalAlias(DBrs.getString("ORIGINAL_ALIAS"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class HostCursor
    extends DBCursor {
        private Host element = new Host();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResHostTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResHostTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResHostTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public HostCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_HOST", con, HostCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Host getObject() throws SQLException {
            Host el = null;
            if (this.DBrs != null) {
                el = new Host();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Host getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

